/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InheritorsHolder;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class CatchTypeProvider
extends CompletionProvider<CompletionParameters> {
    static final ElementPattern<PsiElement> CATCH_CLAUSE_TYPE = PlatformPatterns.psiElement().insideStarting((ElementPattern)PlatformPatterns.psiElement(PsiTypeElement.class).withParent((ElementPattern)PlatformPatterns.psiElement(PsiCatchSection.class)));

    CatchTypeProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, final @NotNull CompletionResultSet result2) {
        PsiCodeBlock tryBlock;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/CatchTypeProvider", "addCompletions"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/CatchTypeProvider", "addCompletions"));
        }
        PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), PsiTryStatement.class);
        PsiCodeBlock psiCodeBlock = tryBlock = tryStatement == null ? null : tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        final InheritorsHolder holder = new InheritorsHolder(result2);
        for (PsiClassType type : ExceptionUtil.getThrownExceptions((PsiElement[])tryBlock.getStatements())) {
            PsiClass typeClass = type.resolve();
            if (typeClass == null) continue;
            result2.addElement(CatchTypeProvider.createCatchTypeVariant(tryBlock, type));
            holder.registerClass(typeClass);
        }
        List<PsiClassType> expectedClassTypes = Collections.singletonList(JavaPsiFacade.getElementFactory((Project)tryBlock.getProject()).createTypeByFQClassName("java.lang.Throwable"));
        JavaInheritorsGetter.processInheritors(parameters, expectedClassTypes, result2.getPrefixMatcher(), new Consumer<PsiType>(){

            public void consume(PsiType type) {
                PsiClass psiClass;
                PsiClass psiClass2 = psiClass = type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
                if (psiClass == null || psiClass instanceof PsiTypeParameter) {
                    return;
                }
                if (!holder.alreadyProcessed(psiClass)) {
                    result2.addElement(CatchTypeProvider.createCatchTypeVariant(tryBlock, (PsiClassType)type));
                }
            }
        });
    }

    @NotNull
    private static LookupElement createCatchTypeVariant(PsiCodeBlock tryBlock, PsiClassType type) {
        TailTypeDecorator<PsiTypeLookupItem> tailTypeDecorator = TailTypeDecorator.withTail(PsiTypeLookupItem.createLookupItem((PsiType)type, (PsiElement)tryBlock), TailType.HUMBLE_SPACE_BEFORE_WORD);
        if (tailTypeDecorator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CatchTypeProvider", "createCatchTypeVariant"));
        }
        return tailTypeDecorator;
    }
}

