/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.execution.CantRunException;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGTestObject;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class TestNGTestClass
extends TestNGTestObject {
    public TestNGTestClass(TestNGConfiguration config) {
        super(config);
    }

    @Override
    public void fillTestObjects(Map<PsiClass, Map<PsiMethod, List<String>>> classes) throws CantRunException {
        final TestData data = this.myConfig.getPersistantData();
        final PsiClass psiClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            @Nullable
            public PsiClass compute() {
                return ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)TestNGTestClass.this.myConfig.getProject()), (String)data.getMainClassName().replace('/', '.'), null, (boolean)true, (GlobalSearchScope)TestNGTestClass.this.getSearchScope());
            }
        });
        if (psiClass == null) {
            throw new CantRunException("No tests found in the class \"" + data.getMainClassName() + '\"');
        }
        if (null == ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                return psiClass.getQualifiedName();
            }
        })) {
            throw new CantRunException("Cannot test anonymous or local class \"" + data.getMainClassName() + '\"');
        }
        TestNGTestClass.calculateDependencies(null, classes, this.getSearchScope(), psiClass);
    }

    @Override
    public String getGeneratedName() {
        return JavaExecutionUtil.getPresentableClassName((String)this.myConfig.getPersistantData().getMainClassName());
    }

    @Override
    public String getActionName() {
        return JavaExecutionUtil.getShortClassName((String)this.myConfig.getPersistantData().MAIN_CLASS_NAME);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        TestData data = this.myConfig.getPersistantData();
        SourceScope scope = data.getScope().getSourceScope((ModuleBasedConfiguration)this.myConfig);
        if (scope == null) {
            throw new RuntimeConfigurationException("Invalid scope specified");
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myConfig.getProject());
        PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)manager, (String)data.getMainClassName(), null, (boolean)true, (GlobalSearchScope)scope.getGlobalSearchScope());
        if (psiClass == null) {
            throw new RuntimeConfigurationException("Class '" + data.getMainClassName() + "' not found");
        }
    }

    @Override
    public boolean isConfiguredByElement(PsiElement element) {
        if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class, (boolean)false)) instanceof PsiClass) {
            return Comparing.strEqual((String)this.myConfig.getPersistantData().getMainClassName(), (String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)element)));
        }
        return false;
    }
}

