/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command.mq;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgCommitTypeCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgQNewCommand
extends HgCommitTypeCommand {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yy_MM_dd_HH-mm-ss");

    public HgQNewCommand(@NotNull Project project, @NotNull HgRepository repository, String message, boolean amend) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/mq/HgQNewCommand", "<init>"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/command/mq/HgQNewCommand", "<init>"));
        }
        super(project, repository, message, amend);
    }

    @Override
    protected void executeChunked(@NotNull List<List<String>> chunkedCommits) throws HgCommandException, VcsException {
        if (chunkedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunkedCommits", "org/zmlx/hg4idea/command/mq/HgQNewCommand", "executeChunked"));
        }
        if (chunkedCommits.isEmpty()) {
            this.executeQNew(ContainerUtil.emptyList());
        } else {
            int size = chunkedCommits.size();
            int i = 0;
            if (!this.myAmend) {
                this.executeQNew(chunkedCommits.get(0));
                i = 1;
            }
            while (i < size) {
                this.executeQRefresh(chunkedCommits.get(i));
                ++i;
            }
        }
        this.myRepository.update();
        MessageBus messageBus = this.myProject.getMessageBus();
        ((HgUpdater)messageBus.syncPublisher(HgVcs.REMOTE_TOPIC)).update(this.myProject, null);
    }

    private void executeQRefresh(@NotNull List<String> chunkFiles) throws VcsException {
        if (chunkFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunkFiles", "org/zmlx/hg4idea/command/mq/HgQNewCommand", "executeQRefresh"));
        }
        ArrayList args = ContainerUtil.newArrayList();
        args.add("-l");
        args.add(this.saveCommitMessage().getAbsolutePath());
        args.add("-s");
        args.addAll(chunkFiles);
        new HgCommandExecutor(this.myProject).execute(this.myRepository.getRoot(), "qrefresh", args, new HgCommandResultHandler(){

            @Override
            public void process(@Nullable HgCommandResult result) {
                if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                    new HgCommandResultNotifier(HgQNewCommand.this.myProject).notifyError(result, "QRefresh Failed", "Could not amend selected changes to newly created patch");
                }
            }
        });
    }

    private void executeQNew(@NotNull List<String> chunkFiles) throws VcsException {
        if (chunkFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunkFiles", "org/zmlx/hg4idea/command/mq/HgQNewCommand", "executeQNew"));
        }
        ArrayList args = ContainerUtil.newArrayList();
        args.add("-l");
        args.add(this.saveCommitMessage().getAbsolutePath());
        args.add("-UD");
        String patchName = DATE_FORMAT.format(new Date()).concat(".diff");
        args.add(patchName);
        args.addAll(chunkFiles);
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        executor.execute(this.myRepository.getRoot(), "qnew", args, new HgCommandResultHandler(){

            @Override
            public void process(@Nullable HgCommandResult result) {
                if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                    new HgCommandResultNotifier(HgQNewCommand.this.myProject).notifyError(result, "Qnew Failed", "Could not create mq patch for selected changes");
                }
            }
        });
    }
}

