/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.editor.IgnoredPropertiesFilesSuffixesManager;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoreIncompletePropertyPropertiesFilesAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(IgnoreIncompletePropertyPropertiesFilesAction.class);

    public IgnoreIncompletePropertyPropertiesFilesAction() {
        super("Ignore Properties Files Without Translation");
    }

    public void actionPerformed(AnActionEvent e) {
        final ResourceBundleEditor resourceBundleEditor = (ResourceBundleEditor)((Object)PlatformDataKeys.FILE_EDITOR.getData(e.getDataContext()));
        LOG.assertTrue(resourceBundleEditor != null);
        Project project = IgnoreIncompletePropertyPropertiesFilesAction.getEventProject((AnActionEvent)e);
        LOG.assertTrue(project != null);
        final HashSet<String> properties = new HashSet<String>();
        IgnoreIncompletePropertyPropertiesFilesAction.processSelectedIncompleteProperties(new Processor<IProperty>(){

            public boolean process(IProperty property) {
                properties.add(property.getKey());
                return true;
            }
        }, resourceBundleEditor, project);
        IgnoredPropertiesFilesSuffixesManager suffixesManager = IgnoredPropertiesFilesSuffixesManager.getInstance(project);
        List<PropertiesFile> allFilesWithoutTranslation = suffixesManager.getPropertiesFilesWithoutTranslation(resourceBundleEditor.getResourceBundle(), properties);
        if (allFilesWithoutTranslation.isEmpty()) {
            return;
        }
        Collections.sort(allFilesWithoutTranslation, new Comparator<PropertiesFile>(){

            @Override
            public int compare(PropertiesFile p1, PropertiesFile p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        List<PropertiesFile> suffixRepresentatives = new IgnoredSuffixesDialog(allFilesWithoutTranslation, project).showAndGetSuffixesRepresentatives();
        if (suffixRepresentatives == null) {
            return;
        }
        List suffixesToIgnore = ContainerUtil.map(suffixRepresentatives, (Function)new NotNullFunction<PropertiesFile, String>(){

            @NotNull
            public String fun(PropertiesFile propertiesFile) {
                String string = PropertiesUtil.getSuffix(propertiesFile);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/IgnoreIncompletePropertyPropertiesFilesAction$3", "fun"));
                }
                return string;
            }
        });
        if (!suffixesToIgnore.isEmpty()) {
            suffixesManager.addSuffixes(suffixesToIgnore);
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    resourceBundleEditor.queueUpdateTree();
                }
            });
        }
    }

    public void update(AnActionEvent e) {
        FileEditor fileEditor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(e.getDataContext());
        if (fileEditor instanceof ResourceBundleEditor) {
            ResourceBundleEditor resourceBundleEditor = (ResourceBundleEditor)fileEditor;
            Project project = IgnoreIncompletePropertyPropertiesFilesAction.getEventProject((AnActionEvent)e);
            if (project != null && !IgnoreIncompletePropertyPropertiesFilesAction.processSelectedIncompleteProperties(new Processor<IProperty>(){

                public boolean process(IProperty property) {
                    return false;
                }
            }, resourceBundleEditor, project)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    private static boolean processSelectedIncompleteProperties(@NotNull Processor<IProperty> processor, @NotNull ResourceBundleEditor resourceBundleEditor, @NotNull Project project) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/properties/editor/IgnoreIncompletePropertyPropertiesFilesAction", "processSelectedIncompleteProperties"));
        }
        if (resourceBundleEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundleEditor", "com/intellij/lang/properties/editor/IgnoreIncompletePropertyPropertiesFilesAction", "processSelectedIncompleteProperties"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/editor/IgnoreIncompletePropertyPropertiesFilesAction", "processSelectedIncompleteProperties"));
        }
        IgnoredPropertiesFilesSuffixesManager suffixesManager = IgnoredPropertiesFilesSuffixesManager.getInstance(project);
        for (ResourceBundleEditorViewElement element : resourceBundleEditor.getSelectedElements()) {
            IProperty[] properties = element.getProperties();
            if (properties == null) continue;
            for (IProperty property : properties) {
                if (suffixesManager.isPropertyComplete(resourceBundleEditor.getResourceBundle(), property.getKey()) || processor.process((Object)property)) continue;
                return false;
            }
        }
        return true;
    }

    private static class IgnoredSuffixesDialog
    extends DialogWrapper {
        @NotNull
        private final List<PropertiesFile> myPropertiesFiles;
        private CollectionListModel<PropertiesFile> myModel;

        protected IgnoredSuffixesDialog(@NotNull List<PropertiesFile> propertiesFiles, @NotNull Project project) {
            if (propertiesFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFiles", "com/intellij/lang/properties/editor/IgnoreIncompletePropertyPropertiesFilesAction$IgnoredSuffixesDialog", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/editor/IgnoreIncompletePropertyPropertiesFilesAction$IgnoredSuffixesDialog", "<init>"));
            }
            super(project);
            this.myPropertiesFiles = propertiesFiles;
            this.setTitle("Suffixes to Ignore:");
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JBList list = new JBList();
            this.myModel = new CollectionListModel(this.myPropertiesFiles);
            list.setModel(this.myModel);
            list.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    label.setText(PropertiesUtil.getSuffix((PropertiesFile)value));
                    return label;
                }
            });
            return ToolbarDecorator.createDecorator((JList)list).disableUpDownActions().disableAddAction().createPanel();
        }

        @Nullable
        public List<PropertiesFile> showAndGetSuffixesRepresentatives() {
            return this.showAndGet() ? this.myModel.getItems() : null;
        }
    }
}

