/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.updater;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskFactory;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.NullTaskMonitor;
import com.android.sdklib.internal.repository.UserCredentials;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.updater.SettingsController;
import com.android.sdklib.internal.repository.updater.UpdaterData;
import com.android.utils.ILogger;
import com.android.utils.IReaderLogger;
import com.android.utils.NullLogger;
import com.android.utils.Pair;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

@Deprecated
public class SdkUpdaterNoWindow {
    private final UpdaterData mUpdaterData;
    private final ILogger mSdkLog;
    private final boolean mForce;

    public SdkUpdaterNoWindow(String osSdkRoot, SdkManager sdkManager, ILogger sdkLog, boolean force, boolean useHttp, String proxyHost, String proxyPort) {
        this.mSdkLog = sdkLog;
        this.mForce = force;
        this.mUpdaterData = new UpdaterData(osSdkRoot, sdkLog);
        SettingsController settingsController = this.mUpdaterData.getSettingsController();
        settingsController.loadSettings();
        settingsController.applySettings();
        this.setupProxy(proxyHost, proxyPort);
        settingsController.setSetting("sdkman.force.http", useHttp);
        this.mUpdaterData.setTaskFactory(new ConsoleTaskFactory());
        if (this.mUpdaterData.checkIfInitFailed()) {
            return;
        }
        this.mUpdaterData.setupDefaultSources();
        this.mUpdaterData.getLocalSdkParser().parseSdk(osSdkRoot, sdkManager, new NullTaskMonitor(sdkLog));
    }

    @Deprecated
    public void updateAll(ArrayList<String> pkgFilter, boolean includeAll, boolean dryMode, String acceptLicense) {
        this.updateAll(pkgFilter, includeAll, dryMode, acceptLicense, false);
    }

    public void updateAll(ArrayList<String> pkgFilter, boolean includeAll, boolean dryMode, String acceptLicense, boolean includeDependencies) {
        this.mUpdaterData.updateOrInstallAll_NoGUI(pkgFilter, includeAll, dryMode, acceptLicense, includeDependencies);
    }

    public void listRemotePackages(boolean includeAll, boolean extendedOutput) {
        this.mUpdaterData.listRemotePackages_NoGUI(includeAll, extendedOutput);
    }

    public Pair<Boolean, File> installPlatformPackage(String hashString) {
        assert (this.mSdkLog instanceof IReaderLogger);
        SdkManager sm = this.mUpdaterData.getSdkManager();
        IAndroidTarget target = sm.getTargetFromHashString(hashString);
        if (target == null) {
            ArrayList<String> filter = new ArrayList<String>();
            filter.add(hashString);
            List<Archive> installed = this.mUpdaterData.updateOrInstallAll_NoGUI(filter, true, false, null);
            if (installed != null) {
                sm.reloadSdk((ILogger)new NullLogger());
                target = sm.getTargetFromHashString(hashString);
            }
        }
        if (target != null) {
            return Pair.of((Object)Boolean.TRUE, (Object)new File(target.getLocation()));
        }
        return null;
    }

    private void setupProxy(String proxyHost, String proxyPort) {
        String JAVA_PROP_HTTP_PROXY_HOST = "http.proxyHost";
        String JAVA_PROP_HTTP_PROXY_PORT = "http.proxyPort";
        String JAVA_PROP_HTTPS_PROXY_HOST = "https.proxyHost";
        String JAVA_PROP_HTTPS_PROXY_PORT = "https.proxyPort";
        Properties props = System.getProperties();
        if (proxyHost != null && proxyHost.length() > 0) {
            props.setProperty("http.proxyHost", proxyHost);
            props.setProperty("https.proxyHost", proxyHost);
        }
        if (proxyPort != null && proxyPort.length() > 0) {
            props.setProperty("http.proxyPort", proxyPort);
            props.setProperty("https.proxyPort", proxyPort);
        }
    }

    private static class ConsoleSubTaskMonitor
    implements IConsoleSubTaskMonitor {
        private final ConsoleTaskMonitor mRoot;
        private final IConsoleSubTaskMonitor mParent;
        private final double mStart;
        private final double mSpan;
        private double mSubValue;
        private double mSubCoef;

        public ConsoleSubTaskMonitor(ConsoleTaskMonitor root, IConsoleSubTaskMonitor parent, double start, double span) {
            this.mRoot = root;
            this.mParent = parent;
            this.mStart = start;
            this.mSpan = span;
            this.mSubValue = start;
        }

        @Override
        public boolean isCancelRequested() {
            return this.mRoot.isCancelRequested();
        }

        @Override
        public void setDescription(String format, Object ... args) {
            this.mRoot.setDescription(format, args);
        }

        @Override
        public void log(String format, Object ... args) {
            this.mRoot.log(format, args);
        }

        @Override
        public void logError(String format, Object ... args) {
            this.mRoot.logError(format, args);
        }

        @Override
        public void logVerbose(String format, Object ... args) {
            this.mRoot.logVerbose(format, args);
        }

        @Override
        public void setProgressMax(int max) {
            assert (max > 0);
            double d = this.mSubCoef = max > 0 ? this.mSpan / (double)max : 0.0;
            assert (this.mSubCoef > 0.0);
        }

        @Override
        public int getProgressMax() {
            return this.mSubCoef > 0.0 ? (int)(this.mSpan / this.mSubCoef) : 0;
        }

        @Override
        public int getProgress() {
            assert (this.mSubCoef > 0.0);
            return this.mSubCoef > 0.0 ? (int)((this.mSubValue - this.mStart) / this.mSubCoef) : 0;
        }

        @Override
        public void incProgress(int delta) {
            if (delta > 0 && this.mSubCoef > 0.0) {
                this.subIncProgress((double)delta * this.mSubCoef);
            }
        }

        @Override
        public void subIncProgress(double realDelta) {
            this.mSubValue += realDelta;
            if (this.mParent != null) {
                this.mParent.subIncProgress(realDelta);
            } else {
                this.mRoot.internalIncProgress(realDelta);
            }
        }

        @Override
        public boolean displayPrompt(String title, String message) {
            return this.mRoot.displayPrompt(title, message);
        }

        @Override
        public UserCredentials displayLoginCredentialsPrompt(String title, String message) {
            return this.mRoot.displayLoginCredentialsPrompt(title, message);
        }

        @Override
        public ITaskMonitor createSubMonitor(int tickCount) {
            assert (this.mSubCoef > 0.0);
            assert (tickCount > 0);
            return new ConsoleSubTaskMonitor(this.mRoot, this, this.mSubValue, (double)tickCount * this.mSubCoef);
        }

        public void error(@Nullable Throwable t, @Nullable String errorFormat, Object ... args) {
            this.mRoot.error(t, errorFormat, args);
        }

        public void warning(@NonNull String warningFormat, Object ... args) {
            this.mRoot.warning(warningFormat, args);
        }

        public void info(@NonNull String msgFormat, Object ... args) {
            this.mRoot.info(msgFormat, args);
        }

        public void verbose(@NonNull String msgFormat, Object ... args) {
            this.mRoot.verbose(msgFormat, args);
        }
    }

    private static interface IConsoleSubTaskMonitor
    extends ITaskMonitor {
        public void subIncProgress(double var1);
    }

    private class ConsoleTaskMonitor
    implements ITaskMonitor {
        private static final double MAX_COUNT = 10000.0;
        private double mIncCoef = 0.0;
        private double mValue = 0.0;
        private String mLastDesc = null;
        private String mLastProgressBase = null;

        public ConsoleTaskMonitor(String title, ITask task) {
            SdkUpdaterNoWindow.this.mSdkLog.info("%s:\n", new Object[]{title});
        }

        @Override
        public void setDescription(String format, Object ... args) {
            String last = this.mLastDesc;
            String line = String.format("  " + format, args);
            int pos = line.indexOf(37);
            if (pos > -1) {
                String base = line.trim();
                if (this.mLastProgressBase != null && base.startsWith(this.mLastProgressBase)) {
                    line = "    " + base.substring(this.mLastProgressBase.length());
                }
                line = line + '\r';
            } else {
                this.mLastProgressBase = line.trim();
                line = line + '\n';
            }
            if (last != null && last.equals(line.trim())) {
                return;
            }
            this.mLastDesc = line.trim();
            if (last != null && last.endsWith("\r") && !line.endsWith("\r")) {
                line = '\n' + line;
            }
            SdkUpdaterNoWindow.this.mSdkLog.info("%s", new Object[]{line});
        }

        @Override
        public void log(String format, Object ... args) {
            this.setDescription("  " + format, args);
        }

        @Override
        public void logError(String format, Object ... args) {
            this.setDescription(format, args);
        }

        @Override
        public void logVerbose(String format, Object ... args) {
        }

        public void error(@Nullable Throwable t, @Nullable String errorFormat, Object ... args) {
            SdkUpdaterNoWindow.this.mSdkLog.error(t, errorFormat, args);
        }

        public void warning(@NonNull String warningFormat, Object ... args) {
            SdkUpdaterNoWindow.this.mSdkLog.warning(warningFormat, args);
        }

        public void info(@NonNull String msgFormat, Object ... args) {
            SdkUpdaterNoWindow.this.mSdkLog.info(msgFormat, args);
        }

        public void verbose(@NonNull String msgFormat, Object ... args) {
            SdkUpdaterNoWindow.this.mSdkLog.verbose(msgFormat, args);
        }

        @Override
        public void setProgressMax(int max) {
            assert (max > 0);
            double d = this.mIncCoef = max > 0 ? 10000.0 / (double)max : 0.0;
            assert (this.mIncCoef > 0.0);
        }

        @Override
        public int getProgressMax() {
            return this.mIncCoef > 0.0 ? (int)(10000.0 / this.mIncCoef) : 0;
        }

        @Override
        public void incProgress(int delta) {
            if (delta > 0 && this.mIncCoef > 0.0) {
                this.internalIncProgress((double)delta * this.mIncCoef);
            }
        }

        private void internalIncProgress(double realDelta) {
            this.mValue += realDelta;
        }

        @Override
        public int getProgress() {
            assert (this.mIncCoef > 0.0);
            return this.mIncCoef > 0.0 ? (int)(this.mValue / this.mIncCoef) : 0;
        }

        @Override
        public boolean isCancelRequested() {
            return false;
        }

        @Override
        public boolean displayPrompt(String title, String message) {
            SdkUpdaterNoWindow.this.mSdkLog.info("\n%1$s\n%2$s\n%3$s", new Object[]{title, message, SdkUpdaterNoWindow.this.mForce ? "--force used, will reply yes\n" : "Note: you  can use --force to override to yes.\n"});
            if (SdkUpdaterNoWindow.this.mForce) {
                return true;
            }
            while (true) {
                SdkUpdaterNoWindow.this.mSdkLog.info("%1$s", new Object[]{"[y/n] =>"});
                try {
                    byte[] readBuffer = new byte[2048];
                    String reply = this.readLine(readBuffer).trim();
                    SdkUpdaterNoWindow.this.mSdkLog.info("\n", new Object[0]);
                    if (reply.length() > 0 && reply.length() <= 3) {
                        char c = reply.charAt(0);
                        if (c == 'y' || c == 'Y') {
                            return true;
                        }
                        if (c == 'n' || c == 'N') {
                            return false;
                        }
                    }
                    SdkUpdaterNoWindow.this.mSdkLog.info("Unknown reply '%s'. Please use y[es]/n[o].\n", new Object[0]);
                }
                catch (IOException e) {
                    SdkUpdaterNoWindow.this.mSdkLog.info("\n", new Object[0]);
                    return false;
                }
            }
        }

        @Override
        public UserCredentials displayLoginCredentialsPrompt(String title, String message) {
            String login = "";
            String password = "";
            String workstation = "";
            String domain = "";
            SdkUpdaterNoWindow.this.mSdkLog.info("\n%1$s\n%2$s", new Object[]{title, message});
            byte[] readBuffer = new byte[2048];
            try {
                SdkUpdaterNoWindow.this.mSdkLog.info("\nLogin: ", new Object[0]);
                login = this.readLine(readBuffer);
                SdkUpdaterNoWindow.this.mSdkLog.info("\nPassword: ", new Object[0]);
                password = this.readLine(readBuffer);
                SdkUpdaterNoWindow.this.mSdkLog.info("\nIf your proxy uses NTLM authentication, provide the following information. Leave blank otherwise.", new Object[0]);
                SdkUpdaterNoWindow.this.mSdkLog.info("\nWorkstation: ", new Object[0]);
                workstation = this.readLine(readBuffer);
                SdkUpdaterNoWindow.this.mSdkLog.info("\nDomain: ", new Object[0]);
                domain = this.readLine(readBuffer);
            }
            catch (IOException e) {
                login = "";
                password = "";
                workstation = "";
                domain = "";
                SdkUpdaterNoWindow.this.mSdkLog.info("\nError occurred during login/pass query: %s\n", new Object[]{e.getMessage()});
            }
            return new UserCredentials(login, password, workstation, domain);
        }

        private String readLine(byte[] buffer) throws IOException {
            int count = SdkUpdaterNoWindow.this.mSdkLog instanceof IReaderLogger ? ((IReaderLogger)SdkUpdaterNoWindow.this.mSdkLog).readLine(buffer) : System.in.read(buffer);
            if (count == buffer.length && buffer[count - 1] != 10) {
                throw new IOException(String.format("Input is longer than the buffer size, (%1$s) bytes", buffer.length));
            }
            while (count > 0 && (buffer[count - 1] == 13 || buffer[count - 1] == 10)) {
                --count;
            }
            return new String(buffer, 0, count);
        }

        @Override
        public ITaskMonitor createSubMonitor(int tickCount) {
            assert (this.mIncCoef > 0.0);
            assert (tickCount > 0);
            return new ConsoleSubTaskMonitor(this, null, this.mValue, (double)tickCount * this.mIncCoef);
        }
    }

    private class ConsoleTaskFactory
    implements ITaskFactory {
        private ConsoleTaskFactory() {
        }

        @Override
        public void start(String title, ITask task) {
            this.start(title, null, task);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start(String title, ITaskMonitor parentMonitor, ITask task) {
            if (parentMonitor == null) {
                task.run(new ConsoleTaskMonitor(title, task));
            } else {
                if (parentMonitor.getProgressMax() == 0) {
                    parentMonitor.setProgressMax(1);
                }
                ITaskMonitor sub = parentMonitor.createSubMonitor(parentMonitor.getProgressMax() - parentMonitor.getProgress());
                try {
                    task.run(sub);
                }
                finally {
                    int delta = sub.getProgressMax() - sub.getProgress();
                    if (delta > 0) {
                        sub.incProgress(delta);
                    }
                }
            }
        }
    }
}

