/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.SystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.internal.repository.packages.BrokenPackage;
import com.android.sdklib.internal.repository.packages.IAndroidVersionProvider;
import com.android.sdklib.internal.repository.packages.IPlatformDependency;
import com.android.sdklib.internal.repository.packages.MajorRevisionPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.local.LocalSysImgPkgInfo;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

@Deprecated
public class SystemImagePackage
extends MajorRevisionPackage
implements IAndroidVersionProvider,
IPlatformDependency {
    private final AndroidVersion mVersion;
    private final String mAbi;
    private final IPkgDesc mPkgDesc;
    private final IdDisplay mTag;
    private final IdDisplay mAddonVendor;

    public SystemImagePackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        int apiLevel = PackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = PackageParserUtils.getXmlString(packageNode, "codename");
        if (codeName.length() == 0) {
            codeName = null;
        }
        this.mVersion = new AndroidVersion(apiLevel, codeName);
        this.mAbi = PackageParserUtils.getXmlString(packageNode, "abi");
        String tagId = PackageParserUtils.getXmlString(packageNode, "tag-id", SystemImage.DEFAULT_TAG.getId());
        String tagDisp = PackageParserUtils.getOptionalXmlString(packageNode, "tag-display");
        if (tagDisp == null || tagDisp.isEmpty()) {
            tagDisp = LocalSysImgPkgInfo.tagIdToDisplay(tagId);
        }
        assert (tagId != null);
        assert (tagDisp != null);
        this.mTag = new IdDisplay(tagId, tagDisp);
        Node addonNode = PackageParserUtils.findChildElement(packageNode, "add-on");
        IPkgDesc desc = null;
        IdDisplay vendor = null;
        if (addonNode == null) {
            desc = this.setDescriptions(PkgDesc.Builder.newSysImg(this.mVersion, this.mTag, this.mAbi, (MajorRevision)this.getRevision())).create();
        } else {
            String vendorId = PackageParserUtils.getXmlString(addonNode, "vendor-id");
            String vendorDisp = PackageParserUtils.getXmlString(addonNode, "vendor-display", vendorId);
            assert (vendorId.length() > 0);
            assert (vendorDisp.length() > 0);
            vendor = new IdDisplay(vendorId, vendorDisp);
            desc = this.setDescriptions(PkgDesc.Builder.newAddonSysImg(this.mVersion, vendor, this.mTag, this.mAbi, (MajorRevision)this.getRevision())).create();
        }
        this.mPkgDesc = desc;
        this.mAddonVendor = vendor;
    }

    public SystemImagePackage(AndroidVersion platformVersion, int revision, String abi, Properties props, String localOsPath) {
        this(null, platformVersion, revision, abi, props, localOsPath);
    }

    protected SystemImagePackage(SdkSource source, AndroidVersion platformVersion, int revision, String abi, Properties props, String localOsPath) {
        super(source, props, revision, null, null, null, localOsPath);
        this.mVersion = platformVersion;
        if (abi == null && props != null) {
            abi = props.getProperty("SystemImage.Abi");
        }
        assert (abi != null) : "To use this SystemImagePackage constructor you must pass an ABI as a parameter or as a PROP_ABI property";
        this.mAbi = abi;
        this.mTag = LocalSysImgPkgInfo.extractTagFromProps(props);
        String vendorId = SystemImagePackage.getProperty(props, "Addon.VendorId", null);
        String vendorDisp = SystemImagePackage.getProperty(props, "Addon.VendorDisplay", vendorId);
        IPkgDesc desc = null;
        IdDisplay vendor = null;
        if (vendorId == null) {
            desc = this.setDescriptions(PkgDesc.Builder.newSysImg(this.mVersion, this.mTag, this.mAbi, (MajorRevision)this.getRevision())).create();
        } else {
            assert (vendorId.length() > 0);
            assert (vendorDisp.length() > 0);
            vendor = new IdDisplay(vendorId, vendorDisp);
            desc = this.setDescriptions(PkgDesc.Builder.newAddonSysImg(this.mVersion, vendor, this.mTag, this.mAbi, (MajorRevision)this.getRevision())).create();
        }
        this.mPkgDesc = desc;
        this.mAddonVendor = vendor;
    }

    public static Package createBroken(File abiDir, Properties props) {
        AndroidVersion version = null;
        String abiType = abiDir.getName();
        String error = null;
        IdDisplay tag = null;
        if (props == null) {
            error = String.format("Missing file %1$s", "source.properties");
        } else {
            try {
                version = new AndroidVersion(props);
                tag = LocalSysImgPkgInfo.extractTagFromProps(props);
                String abi = props.getProperty("SystemImage.Abi");
                if (abi != null) {
                    abiType = abi;
                } else {
                    error = String.format("Invalid file %1$s: Missing property %2$s", "source.properties", "SystemImage.Abi");
                }
            }
            catch (AndroidVersion.AndroidVersionException e) {
                error = String.format("Invalid file %1$s: %2$s", "source.properties", e.getMessage());
            }
        }
        try {
            String[] segments = abiDir.getAbsolutePath().split(Pattern.quote(File.separator));
            int len = segments.length;
            for (int i = len - 2; version == null && i >= 0; --i) {
                String abiOrTag;
                if (!"system-images".equals(segments[i])) continue;
                if (version == null) {
                    String platform = segments[i + 1];
                    try {
                        platform = platform.replaceAll("[^0-9]+", " ").trim();
                        int pos = platform.indexOf(32);
                        if (pos >= 0) {
                            platform = platform.substring(0, pos);
                        }
                        int apiLevel = Integer.parseInt(platform);
                        version = new AndroidVersion(apiLevel, null);
                    }
                    catch (Exception pos) {
                        // empty catch block
                    }
                }
                if (tag != null || i + 2 >= len || !(abiOrTag = segments[i + 2].trim()).matches("[A-Za-z0-9_-]+") || Abi.getEnum(abiOrTag) != null) continue;
                tag = new IdDisplay(abiOrTag, LocalSysImgPkgInfo.tagIdToDisplay(abiOrTag));
            }
        }
        catch (Exception segments) {
            // empty catch block
        }
        String vendorId = SystemImagePackage.getProperty(props, "Addon.VendorId", null);
        String vendorDisp = SystemImagePackage.getProperty(props, "Addon.VendorDisplay", vendorId);
        StringBuilder sb = new StringBuilder("Broken ");
        sb.append(SystemImagePackage.getAbiDisplayNameInternal(abiType)).append(' ');
        if (tag != null && !tag.getId().equals(SystemImage.DEFAULT_TAG.getId())) {
            sb.append(tag).append(' ');
        }
        sb.append("System Image");
        if (vendorDisp != null) {
            sb.append(", by ").append(vendorDisp);
        }
        if (version != null) {
            sb.append(String.format(", API %1$s", version.getApiString()));
        }
        String shortDesc = sb.toString();
        if (error != null) {
            sb.append('\n').append(error);
        }
        String longDesc = sb.toString();
        if (tag == null) {
            tag = SystemImage.DEFAULT_TAG;
        }
        assert (tag != null);
        IPkgDesc desc = PkgDesc.Builder.newSysImg(version != null ? version : new AndroidVersion(0, null), tag, abiType, new MajorRevision(0)).setDescriptionShort(shortDesc).create();
        return new BrokenPackage(props, shortDesc, longDesc, 0, version == null ? 0 : version.getApiLevel(), abiDir.getAbsolutePath(), desc);
    }

    @Override
    @NonNull
    public IPkgDesc getPkgDesc() {
        return this.mPkgDesc;
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        this.mVersion.saveProperties(props);
        props.setProperty("SystemImage.Abi", this.mAbi);
        props.setProperty("SystemImage.TagId", this.mTag.getId());
        props.setProperty("SystemImage.TagDisplay", this.mTag.getDisplay());
        if (this.mAddonVendor != null) {
            props.setProperty("Addon.VendorId", this.mAddonVendor.getId());
            props.setProperty("Addon.VendorDisplay", this.mAddonVendor.getDisplay());
        }
    }

    @NonNull
    public IdDisplay getTag() {
        return this.mTag;
    }

    public String getAbi() {
        return this.mAbi;
    }

    public String getAbiDisplayName() {
        return SystemImagePackage.getAbiDisplayNameInternal(this.mAbi);
    }

    private static String getAbiDisplayNameInternal(String abi) {
        return abi.replace("armeabi", "ARM EABI").replace("arm64", "ARM 64").replace("x86", "Intel x86 Atom").replace("x86_64", "Intel x86_64 Atom").replace("mips", "MIPS").replace("-", " ");
    }

    @Override
    @NonNull
    public AndroidVersion getAndroidVersion() {
        return this.mVersion;
    }

    public boolean isPlatform() {
        return this.mAddonVendor == null;
    }

    @Nullable
    public IdDisplay getAddonVendor() {
        return this.mAddonVendor;
    }

    @Override
    public String installId() {
        StringBuilder sb = new StringBuilder("sys-img-");
        sb.append(this.getAbi()).append('-');
        if (!this.isPlatform()) {
            sb.append("addon-");
        }
        sb.append(SystemImage.DEFAULT_TAG.equals(this.getTag()) ? "android" : this.getTag().getId());
        sb.append('-');
        if (!this.isPlatform()) {
            sb.append(this.getAddonVendor().getId()).append('-');
        }
        sb.append(this.getAndroidVersion().getApiString());
        String s = sb.toString();
        s = s.toLowerCase(Locale.US).replaceAll("[^a-z0-9_.-]+", "_").replaceAll("_+", "_");
        return s;
    }

    @Override
    public String getListDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s%2$s", ld, this.isObsolete() ? " (Obsolete)" : "");
        }
        boolean isDefaultTag = SystemImage.DEFAULT_TAG.equals(this.mTag);
        return String.format("%1$s%2$s System Image%3$s", isDefaultTag ? "" : this.mTag.getDisplay() + " ", this.getAbiDisplayName(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getShortDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s, %2$s API %3$s, revision %4$s%5$s", ld, this.mAddonVendor == null ? "Android" : this.mAddonVendor.getDisplay(), this.mVersion.getApiString(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        boolean isDefaultTag = SystemImage.DEFAULT_TAG.equals(this.mTag);
        return String.format("%1$s%2$s System Image, %3$s API %4$s, revision %5$s%6$s", isDefaultTag ? "" : this.mTag.getDisplay() + " ", this.getAbiDisplayName(), this.mAddonVendor == null ? "Android" : this.mAddonVendor.getDisplay(), this.mVersion.getApiString(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String s = this.getDescription();
        if (s == null || s.length() == 0) {
            s = this.getShortDescription();
        }
        if (s.indexOf("revision") == -1) {
            s = s + String.format("\nRevision %1$s%2$s", this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        s = s + String.format("\nRequires SDK Platform Android API %1$s", this.mVersion.getApiString());
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        File folder = new File(osSdkRoot, "system-images");
        folder = new File(folder, AndroidTargetHash.getPlatformHashString(this.mVersion));
        String tag = this.mTag.getId();
        tag = tag.toLowerCase(Locale.US);
        tag = tag.replaceAll("[^a-z0-9_-]+", "_");
        tag = tag.replaceAll("_+", "_");
        tag = tag.replaceAll("-+", "-");
        folder = new File(folder, tag);
        String abi = this.mAbi;
        abi = abi.toLowerCase(Locale.US);
        abi = abi.replaceAll("[^a-z0-9_-]+", "_");
        abi = abi.replaceAll("_+", "_");
        abi = abi.replaceAll("-+", "-");
        folder = new File(folder, abi);
        return folder;
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        if (pkg instanceof SystemImagePackage) {
            SystemImagePackage newPkg = (SystemImagePackage)pkg;
            return this.getTag().equals(newPkg.getTag()) && this.getAbi().equals(newPkg.getAbi()) && this.getAndroidVersion().equals(newPkg.getAndroidVersion()) && (this.mAddonVendor == newPkg.mAddonVendor || this.mAddonVendor != null && this.mAddonVendor.equals(newPkg.mAddonVendor));
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mAddonVendor == null ? 0 : this.mAddonVendor.hashCode());
        result = 31 * result + (this.mTag == null ? 0 : this.mTag.hashCode());
        result = 31 * result + (this.mAbi == null ? 0 : this.mAbi.hashCode());
        result = 31 * result + (this.mVersion == null ? 0 : this.mVersion.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SystemImagePackage)) {
            return false;
        }
        SystemImagePackage other = (SystemImagePackage)obj;
        if (this.mAddonVendor == null ? other.mAddonVendor != null : !this.mAddonVendor.equals(other.mAddonVendor)) {
            return false;
        }
        if (this.mTag == null ? other.mTag != null : !this.mTag.equals(other.mTag)) {
            return false;
        }
        if (this.mAbi == null ? other.mAbi != null : !this.mAbi.equals(other.mAbi)) {
            return false;
        }
        return !(this.mVersion == null ? other.mVersion != null : !this.mVersion.equals(other.mVersion));
    }

    @Override
    protected String comparisonKey() {
        String s = super.comparisonKey();
        int pos = s.indexOf("|r:");
        assert (pos > 0);
        s = s.substring(0, pos) + "|vend:" + (this.mAddonVendor == null ? "" : this.mAddonVendor.getId()) + "|tag:" + this.getTag().getId() + "|abi:" + this.getAbiDisplayName() + s.substring(pos);
        return s;
    }
}

