/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.actions;

import com.intellij.CommonBundle;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilderInfo;

public class OpenInSceneBuilderAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + OpenInSceneBuilderAction.class.getName()));
    public static final String OLD_LAUNCHER = "scenebuilder-launcher.sh";

    public void actionPerformed(AnActionEvent e) {
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        LOG.assertTrue(virtualFile != null);
        String path = virtualFile.getPath();
        Project project = OpenInSceneBuilderAction.getEventProject((AnActionEvent)e);
        SceneBuilderInfo info = SceneBuilderInfo.get(project, true);
        if (info == SceneBuilderInfo.EMPTY) {
            return;
        }
        String pathToSceneBuilder = info.path;
        if (SystemInfo.isMac) {
            pathToSceneBuilder = new File(pathToSceneBuilder = pathToSceneBuilder + "/Contents/MacOS/", OLD_LAUNCHER).exists() ? pathToSceneBuilder + OLD_LAUNCHER : pathToSceneBuilder + "SceneBuilder";
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        try {
            commandLine.setExePath(FileUtil.toSystemDependentName((String)pathToSceneBuilder));
            commandLine.addParameter(path);
            commandLine.createProcess();
        }
        catch (Exception ex) {
            Messages.showErrorDialog((String)("Failed to start SceneBuilder: " + commandLine.getCommandLineString()), (String)CommonBundle.getErrorTitle());
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        presentation.setVisible(false);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile != null && JavaFxFileTypeFactory.isFxml(virtualFile) && e.getProject() != null) {
            presentation.setEnabled(true);
            presentation.setVisible(true);
        }
    }
}

