/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import javax.activation.DataSource;
import org.jvnet.ws.wadl.util.StreamDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSDispatcher {
    public DataSource doGET(String url, Map<String, Object> httpHeaders, String expectedMimeType) throws MalformedURLException, IOException {
        URL u = new URL(url);
        URLConnection c = u.openConnection();
        InputStream in = null;
        String mediaType = null;
        if (c instanceof HttpURLConnection) {
            HttpURLConnection h = (HttpURLConnection)c;
            h.setRequestMethod("GET");
            h.setRequestProperty("Accept", expectedMimeType);
            for (String key : httpHeaders.keySet()) {
                h.setRequestProperty(key, httpHeaders.get(key).toString());
            }
            h.connect();
            mediaType = h.getContentType();
            in = h.getResponseCode() < 400 ? h.getInputStream() : h.getErrorStream();
        }
        return new StreamDataSource(mediaType, in);
    }

    public DataSource doDELETE(String url, Map<String, Object> httpHeaders, String expectedMimeType) throws MalformedURLException, IOException {
        URL u = new URL(url);
        URLConnection c = u.openConnection();
        InputStream in = null;
        String mediaType = null;
        if (c instanceof HttpURLConnection) {
            HttpURLConnection h = (HttpURLConnection)c;
            h.setRequestMethod("DELETE");
            if (expectedMimeType != null) {
                h.setRequestProperty("Accept", expectedMimeType);
            }
            for (String key : httpHeaders.keySet()) {
                h.setRequestProperty(key, httpHeaders.get(key).toString());
            }
            h.connect();
            mediaType = h.getContentType();
            in = h.getResponseCode() < 400 ? h.getInputStream() : h.getErrorStream();
        }
        return new StreamDataSource(mediaType, in);
    }

    public DataSource doPOST(DataSource input, String inputMimeType, String url, Map<String, Object> httpHeaders, String expectedMimeType) throws MalformedURLException, IOException {
        URL u = new URL(url);
        URLConnection c = u.openConnection();
        InputStream in = null;
        String mediaType = null;
        if (c instanceof HttpURLConnection) {
            int bytes;
            HttpURLConnection h = (HttpURLConnection)c;
            h.setRequestMethod("POST");
            h.setChunkedStreamingMode(-1);
            h.setRequestProperty("Accept", expectedMimeType);
            h.setRequestProperty("Content-Type", inputMimeType);
            for (String key : httpHeaders.keySet()) {
                h.setRequestProperty(key, httpHeaders.get(key).toString());
            }
            h.setDoOutput(true);
            h.connect();
            OutputStream out = h.getOutputStream();
            byte[] buffer = new byte[4096];
            InputStream inputStream = input.getInputStream();
            while ((bytes = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, bytes);
            }
            out.close();
            mediaType = h.getContentType();
            in = h.getResponseCode() < 400 ? h.getInputStream() : h.getErrorStream();
        }
        return new StreamDataSource(mediaType, in);
    }

    public DataSource doPUT(DataSource input, String inputMimeType, String url, Map<String, Object> httpHeaders, String expectedMimeType) throws MalformedURLException, IOException {
        URL u = new URL(url);
        URLConnection c = u.openConnection();
        InputStream in = null;
        String mediaType = null;
        if (c instanceof HttpURLConnection) {
            int bytes;
            HttpURLConnection h = (HttpURLConnection)c;
            h.setRequestMethod("PUT");
            h.setChunkedStreamingMode(-1);
            if (expectedMimeType != null) {
                h.setRequestProperty("Accept", expectedMimeType);
            }
            h.setRequestProperty("Content-Type", inputMimeType);
            for (String key : httpHeaders.keySet()) {
                h.setRequestProperty(key, httpHeaders.get(key).toString());
            }
            h.setDoOutput(true);
            h.connect();
            OutputStream out = h.getOutputStream();
            byte[] buffer = new byte[4096];
            InputStream inputStream = input.getInputStream();
            while ((bytes = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, bytes);
            }
            out.close();
            mediaType = h.getContentType();
            in = h.getResponseCode() < 400 ? h.getInputStream() : h.getErrorStream();
        }
        return new StreamDataSource(mediaType, in);
    }
}

