/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertificateUtils;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.SecurityUtil;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class CertificatePane
extends JPanel {
    private ArrayList<X509Certificate> certs = null;
    private static final Dimension TABLE_DIMENSION = new Dimension(500, 200);
    private String[][] issuedToAndBy = null;
    private final String[] columnNames = new String[]{Translator.R("CVIssuedTo"), Translator.R("CVIssuedBy")};
    private final CertificateType[] certificateTypes = new CertificateType[]{new CertificateType(KeyStores.Type.CA_CERTS), new CertificateType(KeyStores.Type.JSSE_CA_CERTS), new CertificateType(KeyStores.Type.CERTS), new CertificateType(KeyStores.Type.JSSE_CERTS), new CertificateType(KeyStores.Type.CLIENT_CERTS)};
    JTabbedPane tabbedPane;
    private final JTable userTable;
    private final JTable systemTable;
    private JComboBox certificateTypeCombo;
    private KeyStores.Type currentKeyStoreType;
    private KeyStores.Level currentKeyStoreLevel;
    private final List<JComponent> disableForSystem;
    private JDialog parent;
    private JComponent defaultFocusComponent = null;
    private KeyStore keyStore = null;

    public CertificatePane(JDialog parent) {
        this.parent = parent;
        this.userTable = new JTable(null);
        this.systemTable = new JTable(null);
        this.disableForSystem = new ArrayList<JComponent>();
        this.addComponents();
        this.currentKeyStoreType = ((CertificateType)this.certificateTypeCombo.getSelectedItem()).getType();
        this.currentKeyStoreLevel = this.tabbedPane.getSelectedIndex() == 0 ? KeyStores.Level.USER : KeyStores.Level.SYSTEM;
        this.repopulateTables();
    }

    private void initializeKeyStore() {
        try {
            this.keyStore = KeyStores.getKeyStore(this.currentKeyStoreLevel, this.currentKeyStoreType);
        }
        catch (Exception e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
    }

    private void addComponents() {
        JButton button;
        int i;
        JPanel main = new JPanel(new BorderLayout());
        JPanel certificateTypePanel = new JPanel(new BorderLayout());
        certificateTypePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel certificateTypeLabel = new JLabel(Translator.R("CVCertificateType"));
        this.certificateTypeCombo = new JComboBox<CertificateType>(this.certificateTypes);
        this.certificateTypeCombo.addActionListener(new CertificateTypeListener());
        certificateTypePanel.add((Component)certificateTypeLabel, "Before");
        certificateTypePanel.add((Component)this.certificateTypeCombo, "Center");
        JPanel tablePanel = new JPanel(new BorderLayout());
        DefaultTableModel userTableModel = new DefaultTableModel(this.issuedToAndBy, this.columnNames);
        this.userTable.setModel(userTableModel);
        this.userTable.getTableHeader().setReorderingAllowed(false);
        this.userTable.setFillsViewportHeight(true);
        JScrollPane userTablePane = new JScrollPane(this.userTable);
        userTablePane.setPreferredSize(TABLE_DIMENSION);
        userTablePane.setSize(TABLE_DIMENSION);
        userTablePane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        DefaultTableModel systemTableModel = new DefaultTableModel(this.issuedToAndBy, this.columnNames);
        this.systemTable.setModel(systemTableModel);
        this.systemTable.getTableHeader().setReorderingAllowed(false);
        this.systemTable.setFillsViewportHeight(true);
        JScrollPane systemTablePane = new JScrollPane(this.systemTable);
        systemTablePane.setPreferredSize(TABLE_DIMENSION);
        systemTablePane.setSize(TABLE_DIMENSION);
        systemTablePane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(Translator.R("CVUser"), userTablePane);
        this.tabbedPane.addTab(Translator.R("CVSystem"), systemTablePane);
        this.tabbedPane.addChangeListener(new TabChangeListener());
        JPanel buttonPanel = new JPanel(new FlowLayout());
        String[] buttonNames = new String[]{Translator.R("CVImport"), Translator.R("CVExport"), Translator.R("CVRemove"), Translator.R("CVDetails")};
        char[] buttonMnemonics = new char[]{'I', 'E', 'M', 'D'};
        ActionListener[] listeners = new ActionListener[]{new ImportButtonListener(), new ExportButtonListener(), new RemoveButtonListener(), new DetailsButtonListener()};
        int maxWidth = 0;
        for (i = 0; i < buttonNames.length; ++i) {
            button = new JButton(buttonNames[i]);
            maxWidth = Math.max(maxWidth, button.getMinimumSize().width);
        }
        for (i = 0; i < buttonNames.length; ++i) {
            button = new JButton(buttonNames[i]);
            button.setMnemonic(buttonMnemonics[i]);
            button.addActionListener(listeners[i]);
            button.setSize(maxWidth, button.getSize().height);
            if (i == 0 || i == 2) {
                this.disableForSystem.add(button);
            }
            buttonPanel.add(button);
        }
        tablePanel.add((Component)this.tabbedPane, "Center");
        tablePanel.add((Component)buttonPanel, "South");
        main.add((Component)certificateTypePanel, "North");
        main.add((Component)tablePanel, "Center");
        if (this.parent != null) {
            JPanel closePanel = new JPanel(new BorderLayout());
            closePanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
            JButton closeButton = new JButton(Translator.R("ButClose"));
            closeButton.addActionListener(new CloseButtonListener());
            this.defaultFocusComponent = closeButton;
            closePanel.add((Component)closeButton, "East");
            main.add((Component)closePanel, "South");
        }
        this.setLayout(new GridLayout(0, 1));
        this.add(main);
    }

    private void readKeyStore() {
        Enumeration<String> aliases = null;
        this.certs = new ArrayList();
        try {
            aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate c = this.keyStore.getCertificate(aliases.nextElement());
                if (!(c instanceof X509Certificate)) continue;
                this.certs.add((X509Certificate)c);
            }
            this.issuedToAndBy = new String[this.certs.size()][2];
            for (int i = 0; i < this.certs.size(); ++i) {
                X509Certificate c = this.certs.get(i);
                this.issuedToAndBy[i][0] = SecurityUtil.getCN(c.getSubjectX500Principal().getName());
                this.issuedToAndBy[i][1] = SecurityUtil.getCN(c.getIssuerX500Principal().getName());
            }
        }
        catch (Exception e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
    }

    private void repopulateTables() {
        this.initializeKeyStore();
        this.readKeyStore();
        DefaultTableModel tableModel = new DefaultTableModel(this.issuedToAndBy, this.columnNames);
        this.userTable.setModel(tableModel);
        tableModel = new DefaultTableModel(this.issuedToAndBy, this.columnNames);
        this.systemTable.setModel(tableModel);
    }

    public void focusOnDefaultButton() {
        if (this.defaultFocusComponent != null) {
            this.defaultFocusComponent.requestFocusInWindow();
        }
    }

    private char[] getPassword(String label) {
        JPasswordField jpf = new JPasswordField();
        int result = JOptionPane.showConfirmDialog(this.parent, new Object[]{label, jpf}, Translator.R("CVPasswordTitle"), 2, 1);
        if (result == 0) {
            return jpf.getPassword();
        }
        return null;
    }

    private class CloseButtonListener
    implements ActionListener {
        private CloseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CertificatePane.this.parent.dispose();
        }
    }

    private class DetailsButtonListener
    implements ActionListener {
        private DetailsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = CertificatePane.this.currentKeyStoreLevel == KeyStores.Level.USER ? CertificatePane.this.userTable : CertificatePane.this.systemTable;
            int selectedRow = table.getSelectedRow();
            if (selectedRow != -1 && selectedRow >= 0) {
                X509Certificate c = (X509Certificate)CertificatePane.this.certs.get(selectedRow);
                SecurityDialog.showSingleCertInfoDialog(c, CertificatePane.this.parent);
            }
        }
    }

    private class RemoveButtonListener
    implements ActionListener {
        private RemoveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = CertificatePane.this.currentKeyStoreLevel == KeyStores.Level.USER ? CertificatePane.this.userTable : CertificatePane.this.systemTable;
            try {
                int selectedRow = table.getSelectedRow();
                if (selectedRow != -1) {
                    int i;
                    String alias = CertificatePane.this.keyStore.getCertificateAlias((Certificate)CertificatePane.this.certs.get(selectedRow));
                    if (alias != null && (i = JOptionPane.showConfirmDialog(CertificatePane.this.parent, Translator.R("CVRemoveConfirmMessage"), Translator.R("CVRemoveConfirmTitle"), 0)) == 0) {
                        CertificatePane.this.keyStore.deleteEntry(alias);
                        File keyStoreFile = new File(KeyStores.getKeyStoreLocation(CertificatePane.this.currentKeyStoreLevel, CertificatePane.this.currentKeyStoreType));
                        if (!keyStoreFile.isFile()) {
                            FileUtils.createRestrictedFile(keyStoreFile, true);
                        }
                        FileOutputStream fos = new FileOutputStream(keyStoreFile);
                        CertificatePane.this.keyStore.store(fos, KeyStores.getPassword());
                        fos.close();
                    }
                    CertificatePane.this.repopulateTables();
                }
            }
            catch (Exception ex) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
            }
        }
    }

    private class ExportButtonListener
    implements ActionListener {
        private ExportButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = CertificatePane.this.currentKeyStoreLevel == KeyStores.Level.USER ? CertificatePane.this.userTable : CertificatePane.this.systemTable;
            try {
                String alias;
                JFileChooser chooser;
                int returnVal;
                int selectedRow = table.getSelectedRow();
                if (selectedRow != -1 && (returnVal = (chooser = new JFileChooser()).showOpenDialog(CertificatePane.this.parent)) == 0 && (alias = CertificatePane.this.keyStore.getCertificateAlias((Certificate)CertificatePane.this.certs.get(selectedRow))) != null) {
                    if (CertificatePane.this.currentKeyStoreType == KeyStores.Type.CLIENT_CERTS) {
                        char[] password = CertificatePane.this.getPassword(Translator.R("CVExportPasswordMessage"));
                        if (password != null) {
                            CertificateUtils.dumpPKCS12(alias, chooser.getSelectedFile(), CertificatePane.this.keyStore, password);
                        }
                    } else {
                        Certificate c = CertificatePane.this.keyStore.getCertificate(alias);
                        PrintStream ps = new PrintStream(chooser.getSelectedFile().getAbsolutePath());
                        CertificateUtils.dump(c, ps);
                    }
                    CertificatePane.this.repopulateTables();
                }
            }
            catch (Exception ex) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
            }
        }
    }

    private class ImportButtonListener
    implements ActionListener {
        private ImportButtonListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showOpenDialog(CertificatePane.this.parent);
            if (returnVal != 0) return;
            try {
                KeyStore ks = CertificatePane.this.keyStore;
                if (CertificatePane.this.currentKeyStoreType == KeyStores.Type.CLIENT_CERTS) {
                    char[] password = CertificatePane.this.getPassword(Translator.R("CVImportPasswordMessage"));
                    if (password == null) return;
                    CertificateUtils.addPKCS12ToKeyStore(chooser.getSelectedFile(), ks, password);
                } else {
                    CertificateUtils.addToKeyStore(chooser.getSelectedFile(), ks);
                }
                File keyStoreFile = new File(KeyStores.getKeyStoreLocation(CertificatePane.this.currentKeyStoreLevel, CertificatePane.this.currentKeyStoreType));
                if (!keyStoreFile.isFile()) {
                    FileUtils.createRestrictedFile(keyStoreFile, true);
                }
                FileOutputStream os = new FileOutputStream(keyStoreFile);
                try {
                    ks.store(os, KeyStores.getPassword());
                }
                finally {
                    ((OutputStream)os).close();
                }
                CertificatePane.this.repopulateTables();
                return;
            }
            catch (Exception ex) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
            }
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPane source = (JTabbedPane)e.getSource();
            switch (source.getSelectedIndex()) {
                case 0: {
                    CertificatePane.this.currentKeyStoreLevel = KeyStores.Level.USER;
                    for (JComponent component : CertificatePane.this.disableForSystem) {
                        component.setEnabled(true);
                    }
                    break;
                }
                case 1: {
                    CertificatePane.this.currentKeyStoreLevel = KeyStores.Level.SYSTEM;
                    for (JComponent component : CertificatePane.this.disableForSystem) {
                        component.setEnabled(false);
                    }
                    break;
                }
            }
            CertificatePane.this.repopulateTables();
        }
    }

    private class CertificateTypeListener
    implements ActionListener {
        private CertificateTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox source = (JComboBox)e.getSource();
            CertificateType type = (CertificateType)source.getSelectedItem();
            CertificatePane.this.currentKeyStoreType = type.getType();
            CertificatePane.this.repopulateTables();
        }
    }

    private static class CertificateType {
        private final KeyStores.Type type;

        public CertificateType(KeyStores.Type type) {
            this.type = type;
        }

        public KeyStores.Type getType() {
            return this.type;
        }

        public String toString() {
            return KeyStores.toDisplayableString(null, this.type);
        }
    }
}

