/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.jnlp.security.policyeditor.PermissionActions;

public class CustomPermission
implements Comparable<CustomPermission> {
    public static final Pattern ACTIONS_PERMISSION = Pattern.compile("\\s*permission\\s+([\\w\\.]+)\\s+\"([^\"]+)\",\\s*\"([^\"]*)\";.*");
    public static final Pattern TARGET_PERMISSION = Pattern.compile("\\s*permission\\s+([\\w\\.]+)\\s+\"([^\"]+)\";.*");
    public final String type;
    public final String target;
    public final String actions;

    public CustomPermission(String type, String target, String actions) {
        this.type = type;
        this.target = target;
        this.actions = actions;
    }

    public static CustomPermission fromString(String string) {
        String actionsStr;
        String targetStr;
        String typeStr;
        Matcher actionMatcher = ACTIONS_PERMISSION.matcher(string);
        if (actionMatcher.matches()) {
            typeStr = actionMatcher.group(1);
            targetStr = actionMatcher.group(2);
            actionsStr = actionMatcher.group(3);
        } else {
            Matcher targetMatcher = TARGET_PERMISSION.matcher(string);
            if (!targetMatcher.matches()) {
                return null;
            }
            typeStr = targetMatcher.group(1);
            targetStr = targetMatcher.group(2);
            actionsStr = "";
        }
        return new CustomPermission(typeStr, targetStr, actionsStr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("permission ");
        sb.append(this.type);
        sb.append(" \"");
        sb.append(this.target);
        sb.append("\"");
        if (!this.actions.equals(PermissionActions.NONE.rawString())) {
            sb.append(", \"");
            sb.append(this.actions);
            sb.append("\"");
        }
        sb.append(";");
        return sb.toString();
    }

    @Override
    public int compareTo(CustomPermission o) {
        if (this == o) {
            return 0;
        }
        int typeComparison = this.type.compareTo(o.type);
        if (typeComparison != 0) {
            return typeComparison;
        }
        int targetComparison = this.target.compareTo(o.target);
        if (targetComparison != 0) {
            return targetComparison;
        }
        int actionsComparison = this.actions.compareTo(o.actions);
        if (actionsComparison != 0) {
            return actionsComparison;
        }
        return 0;
    }
}

