/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.applet.Applet;
import java.awt.Container;
import java.awt.Frame;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.AppletEnvironment;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.util.logging.OutputController;

public class AppletInstance
extends ApplicationInstance {
    private boolean appletStopped = false;
    private Applet applet;
    private AppletEnvironment environment;

    public AppletInstance(JNLPFile file, ThreadGroup group, ClassLoader loader, Applet applet) {
        super(file, group, loader);
        this.applet = applet;
        this.environment = new AppletEnvironment(file, this);
    }

    public void setApplet(Applet applet) {
        if (this.applet != null) {
            OutputController.getLogger().log(new IllegalStateException("Applet can only be set once."));
            return;
        }
        this.applet = applet;
    }

    public AppletInstance(JNLPFile file, ThreadGroup group, ClassLoader loader, Applet applet, Container cont) {
        super(file, group, loader);
        this.applet = applet;
        this.environment = new AppletEnvironment(file, this, cont);
    }

    public void setResizable(boolean resizable) {
        Container c = this.environment.getAppletFrame();
        if (c instanceof Frame) {
            ((Frame)c).setResizable(resizable);
        }
    }

    public boolean isResizable() {
        Container c = this.environment.getAppletFrame();
        if (c instanceof Frame) {
            return ((Frame)c).isResizable();
        }
        return false;
    }

    @Override
    public String getTitle() {
        return this.getJNLPFile().getApplet().getName();
    }

    public AppletEnvironment getAppletEnvironment() {
        return this.environment;
    }

    public Applet getApplet() {
        return this.applet;
    }

    @Override
    public void destroy() {
        if (this.appletStopped) {
            return;
        }
        this.appletStopped = true;
        try {
            this.applet.stop();
            this.applet.destroy();
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
        }
        this.environment.destroy();
        super.destroy();
    }
}

