/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.naming.ConfigurationException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.controlpanel.AboutPanel;
import net.sourceforge.jnlp.controlpanel.DebuggingPanel;
import net.sourceforge.jnlp.controlpanel.DesktopShortcutPanel;
import net.sourceforge.jnlp.controlpanel.JREPanel;
import net.sourceforge.jnlp.controlpanel.JVMPanel;
import net.sourceforge.jnlp.controlpanel.NamedBorderPanel;
import net.sourceforge.jnlp.controlpanel.NetworkSettingsPanel;
import net.sourceforge.jnlp.controlpanel.PolicyPanel;
import net.sourceforge.jnlp.controlpanel.SecuritySettingsPanel;
import net.sourceforge.jnlp.controlpanel.TemporaryInternetFilesPanel;
import net.sourceforge.jnlp.controlpanel.UnsignedAppletsTrustingListPanel;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.security.viewer.CertificatePane;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.logging.OutputController;

public class ControlPanel
extends JFrame {
    private JVMPanel jvmPanel;
    private DeploymentConfiguration config = null;

    public ControlPanel(DeploymentConfiguration config) {
        this.setTitle(Translator.R("CPHead"));
        this.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        this.config = config;
        JPanel topPanel = this.createTopPanel();
        JPanel mainPanel = this.createMainSettingsPanel();
        JPanel buttonPanel = this.createButtonPanel();
        this.add((Component)topPanel, "First");
        this.add((Component)mainPanel, "Center");
        this.add((Component)buttonPanel, "Last");
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    private JPanel createTopPanel() {
        JLabel about = new JLabel(Translator.R("CPMainDescriptionShort"));
        Font currentFont = about.getFont();
        about.setFont(currentFont.deriveFont(currentFont.getSize2D() + 2.0f));
        currentFont = about.getFont();
        about.setFont(currentFont.deriveFont(1));
        JLabel description = new JLabel(Translator.R("CPMainDescriptionLong"));
        description.setBorder(new EmptyBorder(2, 0, 2, 0));
        JPanel descriptionPanel = new JPanel(new GridLayout(0, 1));
        descriptionPanel.setBackground(UIManager.getColor("TextPane.background"));
        descriptionPanel.add(about);
        descriptionPanel.add(description);
        JLabel image = new JLabel();
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            URL imgUrl = cl.getResource("net/sourceforge/jnlp/resources/netx-icon.png");
            image.setIcon(new ImageIcon(ImageIO.read(imgUrl)));
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(UIManager.getColor("TextPane.background"));
        topPanel.add((Component)descriptionPanel, "Before");
        topPanel.add((Component)image, "After");
        topPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        return topPanel;
    }

    private int validateJdk() {
        String s = this.config.getProperty("deployment.jre.dir");
        JVMPanel.JvmValidationResult validationResult = JVMPanel.validateJvm(s);
        if (validationResult.id == JVMPanel.JvmValidationResult.STATE.NOT_DIR || validationResult.id == JVMPanel.JvmValidationResult.STATE.NOT_VALID_DIR || validationResult.id == JVMPanel.JvmValidationResult.STATE.NOT_VALID_JDK) {
            return JOptionPane.showConfirmDialog(this, "<html>" + Translator.R("CPJVMNotokMessage1", s) + "<br/>" + validationResult.formattedText + "<br/>" + Translator.R("CPJVMNotokMessage2", "deployment.jre.dir", DeploymentConfiguration.USER_DEPLOYMENT_PROPERTIES_FILE) + "</html>", Translator.R("CPJVMconfirmInvalidJdkTitle"), 2);
        }
        return 0;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        JButton okButton = new JButton(Translator.R("ButOk"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.saveConfiguration();
                int validationResult = ControlPanel.this.validateJdk();
                if (validationResult != 0) {
                    return;
                }
                ControlPanel.this.dispose();
            }
        });
        buttons.add(okButton);
        JButton applyButton = new JButton(Translator.R("ButApply"));
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                ControlPanel.this.saveConfiguration();
                int validationResult = ControlPanel.this.validateJdk();
                if (validationResult != 0 && (i = JOptionPane.showConfirmDialog(ControlPanel.this, Translator.R("CPJVMconfirmReset"), Translator.R("CPJVMconfirmReset"), 2)) == 0) {
                    ControlPanel.this.jvmPanel.resetTestFieldArgumentsExec();
                }
            }
        });
        buttons.add(applyButton);
        JButton cancelButton = new JButton(Translator.R("ButCancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.dispose();
            }
        });
        buttons.add(cancelButton);
        int maxWidth = 0;
        int maxHeight = 0;
        for (JButton button : buttons) {
            maxWidth = Math.max(button.getMinimumSize().width, maxWidth);
            maxHeight = Math.max(button.getMinimumSize().height, maxHeight);
        }
        int wantedWidth = maxWidth + 10;
        int wantedHeight = maxHeight + 2;
        for (JButton button : buttons) {
            button.setPreferredSize(new Dimension(wantedWidth, wantedHeight));
            buttonPanel.add(button);
        }
        return buttonPanel;
    }

    private JPanel createMainSettingsPanel() {
        this.jvmPanel = (JVMPanel)this.createJVMSettingsPanel();
        SettingsPanel[] panels = new SettingsPanel[]{new SettingsPanel(Translator.R("CPTabAbout"), this.createAboutPanel()), new SettingsPanel(Translator.R("CPTabCache"), this.createCacheSettingsPanel()), new SettingsPanel(Translator.R("CPTabCertificate"), this.createCertificatesSettingsPanel()), new SettingsPanel(Translator.R("CPTabDebugging"), this.createDebugSettingsPanel()), new SettingsPanel(Translator.R("CPTabDesktopIntegration"), this.createDesktopSettingsPanel()), new SettingsPanel(Translator.R("CPTabJVMSettings"), this.jvmPanel), new SettingsPanel(Translator.R("CPTabNetwork"), this.createNetworkSettingsPanel()), new SettingsPanel(Translator.R("CPTabSecurity"), this.createSecuritySettingsPanel()), new SettingsPanel(Translator.R("CPTabPolicy"), this.createPolicySettingsPanel()), new SettingsPanel(Translator.R("APPEXTSECControlPanelExtendedAppletSecurityTitle"), new UnsignedAppletsTrustingListPanel(DeploymentConfiguration.getAppletTrustGlobalSettingsPath(), DeploymentConfiguration.getAppletTrustUserSettingsPath(), this.config))};
        final JPanel settingsPanel = new JPanel(new CardLayout());
        int height = 0;
        int width = 0;
        for (SettingsPanel panel : panels) {
            JPanel p = panel.getPanel();
            Dimension d = p.getMinimumSize();
            if (d.height > height) {
                height = d.height;
            }
            if (d.width <= width) continue;
            width = d.width;
        }
        Dimension dim = new Dimension(width, height);
        for (SettingsPanel panel : panels) {
            JPanel p = panel.getPanel();
            p.setPreferredSize(dim);
            settingsPanel.add((Component)p, panel.toString());
        }
        JList<SettingsPanel> settingsList = new JList<SettingsPanel>(panels);
        settingsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList list = (JList)e.getSource();
                SettingsPanel panel = (SettingsPanel)list.getSelectedValue();
                CardLayout cl = (CardLayout)settingsPanel.getLayout();
                cl.show(settingsPanel, panel.toString());
            }
        });
        JScrollPane settingsListScrollPane = new JScrollPane(settingsList);
        settingsListScrollPane.setHorizontalScrollBarPolicy(30);
        JPanel settingsDetailPanel = new JPanel();
        settingsDetailPanel.setLayout(new BorderLayout());
        settingsDetailPanel.add((Component)settingsPanel, "Center");
        settingsDetailPanel.setBorder(new EmptyBorder(0, 5, -3, 0));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)settingsListScrollPane, "Before");
        mainPanel.add((Component)settingsDetailPanel, "Center");
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        settingsList.setSelectedIndex(0);
        return mainPanel;
    }

    private JPanel createAboutPanel() {
        return new AboutPanel();
    }

    private JPanel createCacheSettingsPanel() {
        return new TemporaryInternetFilesPanel(this.config);
    }

    private JPanel createCertificatesSettingsPanel() {
        NamedBorderPanel p = new NamedBorderPanel(Translator.R("CPHeadCertificates"), new BorderLayout());
        p.add((Component)new CertificatePane(null), "Center");
        return p;
    }

    private JPanel createClassLoaderSettingsPanel() {
        return this.createNotImplementedPanel();
    }

    private JPanel createDebugSettingsPanel() {
        return new DebuggingPanel(this.config);
    }

    private JPanel createDesktopSettingsPanel() {
        return new DesktopShortcutPanel(this.config);
    }

    private JPanel createNetworkSettingsPanel() {
        return new NetworkSettingsPanel(this.config);
    }

    private JPanel createRuntimesSettingsPanel() {
        return new JREPanel();
    }

    private JPanel createSecuritySettingsPanel() {
        return new SecuritySettingsPanel(this.config);
    }

    private JPanel createPolicySettingsPanel() {
        return new PolicyPanel(this, this.config);
    }

    private JPanel createJVMSettingsPanel() {
        return new JVMPanel(this.config);
    }

    private JPanel createNotImplementedPanel() {
        NamedBorderPanel notImplementedPanel = new NamedBorderPanel("Unimplemented");
        notImplementedPanel.setLayout(new BorderLayout());
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        URL imgUrl = cl.getResource("net/sourceforge/jnlp/resources/warning.png");
        try {
            BufferedImage img = ImageIO.read(imgUrl);
            ImageIcon icon = new ImageIcon(img);
            JLabel label = new JLabel("Not Implemented", icon, 0);
            notImplementedPanel.add(label);
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
        return notImplementedPanel;
    }

    private void saveConfiguration() {
        try {
            this.config.save();
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            JOptionPane.showMessageDialog(this, e);
        }
    }

    public static void main(String[] args) throws Exception {
        DeploymentConfiguration.move14AndOlderFilesTo15StructureCatched();
        final DeploymentConfiguration config = new DeploymentConfiguration();
        try {
            config.load();
        }
        catch (ConfigurationException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        KeyStores.setConfiguration(config);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ControlPanel editor = new ControlPanel(config);
                editor.setVisible(true);
            }
        });
    }

    private static class SettingsPanel {
        final String value;
        final JPanel panel;

        public SettingsPanel(String value, JPanel panel) {
            this.value = value;
            this.panel = panel;
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public String toString() {
            return this.value;
        }
    }
}

