#!/bin/sh
export PATH='/usr/obj/ports/hs-scientific-0.3.3.8/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: scientific
version: 0.3.3.8
id: scientific-0.3.3.8-7258086196cb2d7d02a1d9a27d06516c
key: scien_41jKKjOL3MC1wNr2vTak8T
license: BSD3
maintainer: Bas van Dijk <v.dijk.bas@gmail.com>
homepage: https://github.com/basvandijk/scientific
synopsis: Numbers represented using scientific notation
description:
    @Data.Scientific@ provides a space efficient and arbitrary precision
    scientific number type.
    .
    '\''Scientific'\'' numbers are represented using
    <http://en.wikipedia.org/wiki/Scientific_notation scientific notation>. It
    uses a coefficient @c :: '\''Integer'\''@ and a base-10 exponent @e :: '\''Int'\''@ (do
    note that since we'\''re using an '\''Int'\'' to represent the exponent these numbers
    aren'\''t truly arbitrary precision). A scientific number corresponds to the
    '\''Fractional'\'' number: @'\''fromInteger'\'' c * 10 '\''^^'\'' e@.
    .
    The main application of '\''Scientific'\'' is to be used as the target of parsing
    arbitrary precision numbers coming from an untrusted source. The advantages
    over using '\''Rational'\'' for this are that:
    .
    * A '\''Scientific'\'' is more efficient to construct. Rational numbers need to be
    constructed using '\''%'\'' which has to compute the '\''gcd'\'' of the '\''numerator'\'' and
    '\''denominator'\''.
    .
    * '\''Scientific'\'' is safe against numbers with huge exponents. For example:
    @1e1000000000 :: '\''Rational'\''@ will fill up all space and crash your
    program. Scientific works as expected:
    .
    > > read "1e1000000000" :: Scientific
    > 1.0e1000000000
    .
    * Also, the space usage of converting scientific numbers with huge exponents to
    @'\''Integral'\''s@ (like: '\''Int'\'') or @'\''RealFloat'\''s@ (like: '\''Double'\'' or '\''Float'\'')
    will always be bounded by the target type.
category: Data
author: Bas van Dijk
exposed: True
exposed-modules:
    Data.Scientific Data.Text.Lazy.Builder.Scientific
    Data.ByteString.Builder.Scientific
hidden-modules: Math.NumberTheory.Logarithms
trusted: False
import-dirs: /usr/local/lib/ghc/scientific-0.3.3.8
library-dirs: /usr/local/lib/ghc/scientific-0.3.3.8
data-dir: /usr/local/share/hs-scientific-0.3.3.8
hs-libraries: HSscientific-0.3.3.8-41jKKjOL3MC1wNr2vTak8T
depends:
    array-0.5.1.0-98220802c10d9d803be36e35c603d572
    base-4.8.2.0-6d41353bf1900ecbb9b02a306c286c36
    bytestring-0.10.6.0-0aa78e663f1d7b0d4f434cabb130075c
    deepseq-1.4.1.1-7c4279727854e7903ef5ae9e7eb525a5
    ghc-prim-0.4.0.0-bf246eb9fdda7435f0c147a313ce59fb
    hashable-1.2.3.3-85e20e136829dbcbfc9542842144965b
    integer-gmp-1.0.0.0-4ff98693d6e5d6065e60052264067c09
    text-1.2.1.3-b81318aa9c5f332f4a693000ebc8a335
haddock-interfaces: /usr/local/share/doc/hs-scientific-0.3.3.8/html/scientific.haddock
haddock-html: /usr/local/share/doc/hs-scientific-0.3.3.8/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
