#!/bin/sh
export PATH='/usr/obj/ports/hs-crypto-4.2.5.1/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: Crypto
version: 4.2.5.1
id: Crypto-4.2.5.1-00986bc165b3f44ccaa2154ee52ff535
key: Crypt_4LjED9guv4s3B9kPK56bwj
license: OtherLicense
copyright: Dominic Steinitz 2003 - 2007
maintainer: Caylee Hogg <caylee.hogg@gmail.com>
stability: Alpha
synopsis: Collects together existing Haskell cryptographic functions into a package
description:
    DES, Blowfish, AES, TEA, SHA1, MD5, RSA, BubbleBabble,
    Hexdump, Support for Word128, Word192 and Word256 and Beyond, PKCS5
    Padding, Various Encryption Modes e.g. Cipher Block Chaining all in one package,
    with HUnit and QuickCheck tests, and examples.
category: Cryptography, Codec
author: Dominic Steinitz
exposed: True
exposed-modules:
    Codec.Binary.BubbleBabble Codec.Encryption.RSA
    Codec.Encryption.RSA.EMEOAEP Codec.Encryption.RSA.MGF
    Codec.Encryption.RSA.NumberTheory Codec.Encryption.DES
    Codec.Encryption.AES Codec.Encryption.TEA Codec.Encryption.Blowfish
    Codec.Encryption.Modes Codec.Encryption.Padding Codec.Text.Raw
    Codec.Utils Data.Digest.MD5 Data.Digest.SHA1 Data.Digest.SHA2
    Data.Digest.SHA224 Data.Digest.SHA256 Data.Digest.SHA384
    Data.Digest.SHA512 Data.LargeWord Data.HMAC
hidden-modules: Codec.Encryption.BlowfishAux
                Codec.Encryption.DESAux Codec.Encryption.AESAux Data.Digest.MD5Aux
trusted: False
import-dirs: /usr/local/lib/ghc/Crypto-4.2.5.1
library-dirs: /usr/local/lib/ghc/Crypto-4.2.5.1
data-dir: /usr/local/share/hs-Crypto-4.2.5.1
hs-libraries: HSCrypto-4.2.5.1-4LjED9guv4s3B9kPK56bwj
depends:
    HUnit-1.3.0.0-6012ee2b89750105f02de44e83d1dd25
    QuickCheck-2.8.1-29714879ccc984e6035816d9bdbd9e5d
    array-0.5.1.0-98220802c10d9d803be36e35c603d572
    base-4.8.2.0-6d41353bf1900ecbb9b02a306c286c36
    pretty-1.1.2.0-2960df989ad300dcdaaa572687693212
    random-1.1-29ff1dff757b7db4e436b4cdcc22a979
haddock-interfaces: /usr/local/share/doc/hs-Crypto-4.2.5.1/html/Crypto.haddock
haddock-html: /usr/local/share/doc/hs-Crypto-4.2.5.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
