#!/bin/sh
export PATH='/usr/obj/ports/hs-async-2.0.2/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: async
version: 2.0.2
id: async-2.0.2-aa1f75cf9a60a86c98e055e6e83c7bb0
key: async_DTdw00O3YMaL0S98EkJDXS
license: BSD3
copyright: (c) Simon Marlow 2012
maintainer: Simon Marlow <marlowsd@gmail.com>
homepage: https://github.com/simonmar/async
synopsis: Run IO operations asynchronously and wait for their results
description:
    This package provides a higher-level interface over
    threads, in which an @Async a@ is a concurrent
    thread that will eventually deliver a value of
    type @a@.  The package provides ways to create
    @Async@ computations, wait for their results, and
    cancel them.
    .
    Using @Async@ is safer than using threads in two
    ways:
    .
    * When waiting for a thread to return a result,
    if the thread dies with an exception then the
    caller must either re-throw the exception
    ('\''wait'\'') or handle it ('\''waitCatch'\''); the
    exception cannot be ignored.
    .
    * The API makes it possible to build a tree of
    threads that are automatically killed when
    their parent dies (see '\''withAsync'\'').
    .
    Changes in 2.0.2:
    .
    * Add a Monad instance for Concurrently
    * Bump base dependency to allow 4.9
    .
    Changes in 2.0.1.6:
    .
    * Add workaround to waitCatch for #14
    .
    Changes in 2.0.1.5:
    .
    * Bump @base@ dependencies for GHC 7.8
    .
    Changes in 2.0.1.4:
    .
    * Bump @base@ dependency of test suite
    .
    Changes in 2.0.1.3:
    .
    * Bump @base@ dependency to allow 4.6
    .
    Changes in 2.0.1.2:
    .
    * Bump @stm@ dependency to 2.4
    .
    Changes in 2.0.1.1:
    .
    * Safe Haskell support: @Control.Concurrent.Async@ is now @Trustworthy@
    .
    Changes in 2.0.1.0:
    .
    * Added a @Functor@ instance for @Async@
    .
    * Added @asyncBound@, @asyncOn@, @asyncWithUnmask@, @asyncOnWithUnmask@, @withAsyncBound@, @withAsyncOn@, @withAsyncWithUnmask@, @withAsyncOnWithUnmask@.
    .
    * Added @mapConcurrently@
    .
    * Added @Concurrently@ (with @Applicative@ and @Alternative@ instances)
category: Concurrency
author: Simon Marlow
exposed: True
exposed-modules:
    Control.Concurrent.Async
trusted: False
import-dirs: /usr/local/lib/ghc/async-2.0.2
library-dirs: /usr/local/lib/ghc/async-2.0.2
data-dir: /usr/local/share/hs-async-2.0.2
hs-libraries: HSasync-2.0.2-DTdw00O3YMaL0S98EkJDXS
depends:
    base-4.8.2.0-6d41353bf1900ecbb9b02a306c286c36
    stm-2.4.4-6daf3e3a9d54ebee7d9ac7589c1eeb30
haddock-interfaces: /usr/local/share/doc/hs-async-2.0.2/html/async.haddock
haddock-html: /usr/local/share/doc/hs-async-2.0.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
