#!/bin/sh
export PATH='/usr/obj/ports/hs-HTTP-4000.2.20/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: HTTP
version: 4000.2.20
id: HTTP-4000.2.20-09ba2be523390a7d2d5e985e7139696e
key: HTTP_ALmDkzntV1f2dHTcPW5ASO
license: BSD3
maintainer: Ganesh Sittampalam <ganesh@earth.li>
homepage: https://github.com/haskell/HTTP
synopsis: A library for client-side HTTP
description:
    The HTTP package supports client-side web programming in Haskell. It lets you set up
    HTTP connections, transmitting requests and processing the responses coming back, all
    from within the comforts of Haskell. It'\''s dependent on the network package to operate,
    but other than that, the implementation is all written in Haskell.
    .
    A basic API for issuing single HTTP requests + receiving responses is provided. On top
    of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
    it taking care of handling the management of persistent connections, proxies,
    state (cookies) and authentication credentials required to handle multi-step
    interactions with a web server.
    .
    The representation of the bytes flowing across is extensible via the use of a type class,
    letting you pick the representation of requests and responses that best fits your use.
    Some pre-packaged, common instances are provided for you (@ByteString@, @String@).
    .
    Here'\''s an example use:
    .
    >
    >    do
    >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
    >              -- fetch document and return it (as a '\''String'\''.)
    >      fmap (take 100) (getResponseBody rsp)
    >
    >    do
    >      (_, rsp)
    >         <- Network.Browser.browse $ do
    >               setAllowRedirects True -- handle HTTP redirects
    >               request $ getRequest "http://www.haskell.org/"
    >      return (take 100 (rspBody rsp))
category: Network
author: Warrick Gray <warrick.gray@hotmail.com>
exposed: True
exposed-modules:
    Network.BufferType Network.Stream Network.StreamDebugger
    Network.StreamSocket Network.TCP Network.HTTP Network.HTTP.Headers
    Network.HTTP.Base Network.HTTP.Stream Network.HTTP.Auth
    Network.HTTP.Cookie Network.HTTP.Proxy Network.HTTP.HandleStream
    Network.Browser
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5Aux
                Network.HTTP.Utils Paths_HTTP
trusted: False
import-dirs: /usr/local/lib/ghc/HTTP-4000.2.20
library-dirs: /usr/local/lib/ghc/HTTP-4000.2.20
data-dir: /usr/local/share/hs-HTTP-4000.2.20
hs-libraries: HSHTTP-4000.2.20-ALmDkzntV1f2dHTcPW5ASO
depends:
    array-0.5.1.0-98220802c10d9d803be36e35c603d572
    base-4.8.2.0-6d41353bf1900ecbb9b02a306c286c36
    bytestring-0.10.6.0-0aa78e663f1d7b0d4f434cabb130075c
    mtl-2.2.1-05005bb32df8fbad260aa2bc8c4b64aa
    network-2.6.2.1-3b665743d23d24bea9ea15fe12214a85
    network-uri-2.6.0.3-b61dd8ba7d6a362acb4829b92affafa8
    old-time-1.1.0.3-a0e6e92dce13da7aec91a5f4840d0169
    parsec-3.1.9-0bc62b5601d05cd60af5b5aa86497840
haddock-interfaces: /usr/local/share/doc/hs-HTTP-4000.2.20/html/HTTP.haddock
haddock-html: /usr/local/share/doc/hs-HTTP-4000.2.20/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
