/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class LineBorder
extends AbstractBorder {
    static final long serialVersionUID = -787563427772288970L;
    private static LineBorder blackLineBorder;
    private static LineBorder grayLineBorder;
    protected int thickness;
    protected Color lineColor;
    protected boolean roundedCorners;

    public LineBorder(Color color) {
        this(color, 1, false);
    }

    public LineBorder(Color color, int thickness) {
        this(color, thickness, false);
    }

    public LineBorder(Color color, int thickness, boolean roundedCorners) {
        if (color == null || thickness < 0) {
            throw new IllegalArgumentException();
        }
        this.lineColor = color;
        this.thickness = thickness;
        this.roundedCorners = roundedCorners;
    }

    public static Border createBlackLineBorder() {
        if (blackLineBorder == null) {
            blackLineBorder = new LineBorder(Color.black);
        }
        return blackLineBorder;
    }

    public static Border createGrayLineBorder() {
        if (grayLineBorder == null) {
            grayLineBorder = new LineBorder(Color.gray);
        }
        return grayLineBorder;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        try {
            g.setColor(this.lineColor);
            --width;
            --height;
            int i = 0;
            while (i < this.thickness) {
                if (this.roundedCorners) {
                    g.drawRoundRect(x, y, width, height, this.thickness, this.thickness);
                } else {
                    g.drawRect(x, y, width, height);
                }
                ++x;
                ++y;
                width -= 2;
                height -= 2;
                ++i;
            }
        }
        finally {
            g.setColor(oldColor);
        }
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = insets.bottom = this.thickness;
        insets.right = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public boolean getRoundedCorners() {
        return this.roundedCorners;
    }

    public boolean isBorderOpaque() {
        return !this.roundedCorners && this.lineColor.getAlpha() == 255;
    }
}

