/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.text.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingUtilities
implements SwingConstants {
    private static OwnerFrame ownerFrame;

    private SwingUtilities() {
    }

    public static Rectangle calculateInnerArea(JComponent c, Rectangle r) {
        if (c == null) {
            return null;
        }
        r = c.getBounds(r);
        Insets i = c.getInsets();
        r.x = i.left;
        r.width = r.width - i.left - i.right;
        r.y = i.top;
        r.height = r.height - i.top - i.bottom;
        return r;
    }

    public static Component findFocusOwner(Component comp) {
        Component focusOwner;
        Component tmp = focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (tmp != null) {
            if (tmp == comp) {
                return focusOwner;
            }
            tmp = tmp.getParent();
        }
        return null;
    }

    public static Accessible getAccessibleAt(Component c, Point p) {
        return c.getAccessibleContext().getAccessibleComponent().getAccessibleAt(p);
    }

    public static Accessible getAccessibleChild(Component c, int i) {
        return c.getAccessibleContext().getAccessibleChild(i);
    }

    public static int getAccessibleChildrenCount(Component c) {
        return c.getAccessibleContext().getAccessibleChildrenCount();
    }

    public static int getAccessibleIndexInParent(Component c) {
        return c.getAccessibleContext().getAccessibleIndexInParent();
    }

    public static AccessibleStateSet getAccessibleStateSet(Component c) {
        return c.getAccessibleContext().getAccessibleStateSet();
    }

    public static Rectangle getLocalBounds(Component aComponent) {
        Rectangle bounds = aComponent.getBounds();
        return new Rectangle(0, 0, bounds.width, bounds.height);
    }

    public static JRootPane getRootPane(Component comp) {
        if (comp instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)comp)).getRootPane();
        }
        return (JRootPane)SwingUtilities.getAncestorOfClass(JRootPane.class, comp);
    }

    public static Container getAncestorNamed(String name, Component comp) {
        while (comp != null && comp.getName() != name) {
            comp = comp.getParent();
        }
        return (Container)comp;
    }

    public static Container getAncestorOfClass(Class<?> c, Component comp) {
        while (comp != null && !c.isInstance(comp)) {
            comp = comp.getParent();
        }
        return (Container)comp;
    }

    public static Window getWindowAncestor(Component comp) {
        return (Window)SwingUtilities.getAncestorOfClass(Window.class, comp);
    }

    public static Window windowForComponent(Component comp) {
        return (Window)SwingUtilities.getAncestorOfClass(Window.class, comp);
    }

    public static Component getRoot(Component comp) {
        Applet app = null;
        Window win = null;
        while (comp != null) {
            if (win == null && comp instanceof Window) {
                win = (Window)comp;
            } else if (comp instanceof Applet) {
                app = (Applet)comp;
            }
            comp = comp.getParent();
        }
        if (win != null) {
            return win;
        }
        return app;
    }

    public static boolean isDescendingFrom(Component a, Component b) {
        while (a != null && b != null) {
            if (a == b) {
                return true;
            }
            a = a.getParent();
        }
        return false;
    }

    public static Component getDeepestComponentAt(Component parent, int x, int y) {
        if (parent == null || !parent.contains(x, y)) {
            return null;
        }
        if (!(parent instanceof Container)) {
            return parent;
        }
        Container c = (Container)parent;
        return c.findComponentAt(x, y);
    }

    public static void convertPointToScreen(Point p, Component c) {
        Point c0 = c.getLocationOnScreen();
        p.translate(c0.x, c0.y);
    }

    public static void convertPointFromScreen(Point p, Component c) {
        Point c0 = c.getLocationOnScreen();
        p.translate(-c0.x, -c0.y);
    }

    public static Point convertPoint(Component source, int x, int y, Component destination) {
        Point pt = new Point(x, y);
        if (source == null && destination == null) {
            return pt;
        }
        if (source == null) {
            source = SwingUtilities.getRoot(destination);
        }
        if (destination == null) {
            destination = SwingUtilities.getRoot(source);
        }
        if (source.isShowing() && destination.isShowing()) {
            SwingUtilities.convertPointToScreen(pt, source);
            SwingUtilities.convertPointFromScreen(pt, destination);
        }
        return pt;
    }

    public static Point convertPoint(Component source, Point aPoint, Component destination) {
        return SwingUtilities.convertPoint(source, aPoint.x, aPoint.y, destination);
    }

    public static Rectangle convertRectangle(Component source, Rectangle rect, Component destination) {
        Point pt = SwingUtilities.convertPoint(source, rect.x, rect.y, destination);
        return new Rectangle(pt.x, pt.y, rect.width, rect.height);
    }

    public static MouseEvent convertMouseEvent(Component source, MouseEvent sourceEvent, Component destination) {
        Point newpt = SwingUtilities.convertPoint(source, sourceEvent.getX(), sourceEvent.getY(), destination);
        return new MouseEvent(destination, sourceEvent.getID(), sourceEvent.getWhen(), sourceEvent.getModifiersEx(), newpt.x, newpt.y, sourceEvent.getClickCount(), sourceEvent.isPopupTrigger(), sourceEvent.getButton());
    }

    public static void updateComponentTreeUI(Component comp) {
        SwingUtilities.updateComponentTreeUIImpl(comp);
        if (comp instanceof JComponent) {
            JComponent jc = (JComponent)comp;
            jc.revalidate();
        } else {
            comp.invalidate();
            comp.validate();
        }
        comp.repaint();
    }

    private static void updateComponentTreeUIImpl(Component c) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.updateUI();
        }
        Component[] components = null;
        if (c instanceof JMenu) {
            components = ((JMenu)c).getMenuComponents();
        } else if (c instanceof Container) {
            components = ((Container)c).getComponents();
        }
        if (components != null) {
            int i = 0;
            while (i < components.length) {
                SwingUtilities.updateComponentTreeUIImpl(components[i]);
                ++i;
            }
        }
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        boolean ltr = true;
        if (c != null && !c.getComponentOrientation().isLeftToRight()) {
            ltr = false;
        }
        switch (horizontalTextPosition) {
            case 10: {
                horizontalTextPosition = ltr ? 2 : 4;
                break;
            }
            case 11: {
                horizontalTextPosition = ltr ? 4 : 2;
            }
        }
        switch (horizontalAlignment) {
            case 10: {
                horizontalAlignment = ltr ? 2 : 4;
                break;
            }
            case 11: {
                horizontalAlignment = ltr ? 4 : 2;
            }
        }
        return SwingUtilities.layoutCompoundLabelImpl(c, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
    }

    public static String layoutCompoundLabel(FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        return SwingUtilities.layoutCompoundLabelImpl(null, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
    }

    private static String layoutCompoundLabelImpl(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        if (icon == null) {
            textIconGap = 0;
            iconR.width = 0;
            iconR.height = 0;
        } else {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        }
        if (text == null || text.equals("")) {
            textIconGap = 0;
            textR.width = 0;
            textR.height = 0;
            text = "";
        } else {
            View html;
            int availableWidth = viewR.width;
            if (horizontalTextPosition != 0) {
                availableWidth -= iconR.width + textIconGap;
            }
            View view = html = c == null ? null : (View)c.getClientProperty("html");
            if (html != null) {
                textR.width = (int)html.getPreferredSpan(0);
                textR.width = Math.min(availableWidth, textR.width);
                textR.height = (int)html.getPreferredSpan(1);
            } else {
                textR.width = fm.stringWidth(text);
                textR.height = fm.getHeight();
                if (textR.width > availableWidth) {
                    text = SwingUtilities.clipString(c, fm, text, availableWidth);
                    textR.width = fm.stringWidth(text);
                }
            }
        }
        switch (verticalTextPosition) {
            case 1: {
                textR.y = horizontalTextPosition == 0 ? -textR.height - textIconGap : 0;
                break;
            }
            case 3: {
                textR.y = horizontalTextPosition == 0 ? iconR.height + textIconGap : iconR.height - textR.height;
                break;
            }
            case 0: {
                textR.y = iconR.height / 2 - textR.height / 2;
            }
        }
        switch (horizontalTextPosition) {
            case 2: {
                textR.x = -(textR.width + textIconGap);
                break;
            }
            case 4: {
                textR.x = iconR.width + textIconGap;
                break;
            }
            case 0: {
                textR.x = iconR.width / 2 - textR.width / 2;
            }
        }
        int lx = Math.min(iconR.x, textR.x);
        int lw = Math.max(iconR.x + iconR.width, textR.x + textR.width) - lx;
        int ly = Math.min(iconR.y, textR.y);
        int lh = Math.max(iconR.y + iconR.height, textR.y + textR.height) - ly;
        int horizontalAdjustment = 0;
        int verticalAdjustment = 0;
        switch (verticalAlignment) {
            case 1: {
                verticalAdjustment = viewR.y - ly;
                break;
            }
            case 3: {
                verticalAdjustment = viewR.y + viewR.height - ly - lh;
                break;
            }
            case 0: {
                verticalAdjustment = viewR.y + viewR.height / 2 - ly - lh / 2;
            }
        }
        switch (horizontalAlignment) {
            case 2: {
                horizontalAdjustment = viewR.x - lx;
                break;
            }
            case 4: {
                horizontalAdjustment = viewR.x + viewR.width - lx - lw;
                break;
            }
            case 0: {
                horizontalAdjustment = viewR.x + viewR.width / 2 - (lx + lw / 2);
            }
        }
        iconR.x += horizontalAdjustment;
        iconR.y += verticalAdjustment;
        textR.x += horizontalAdjustment;
        textR.y += verticalAdjustment;
        return text;
    }

    private static String clipString(JComponent c, FontMetrics fm, String text, int availableWidth) {
        String clipped;
        String dots = "...";
        int dotsWidth = fm.stringWidth(dots);
        char[] string = text.toCharArray();
        int endIndex = string.length;
        while (fm.charsWidth(string, 0, endIndex) + dotsWidth > availableWidth && endIndex > 0) {
            --endIndex;
        }
        if (string.length >= endIndex + 3) {
            string[endIndex] = 46;
            string[endIndex + 1] = 46;
            string[endIndex + 2] = 46;
            clipped = new String(string, 0, endIndex + 3);
        } else {
            char[] clippedChars = new char[string.length + 3];
            System.arraycopy(string, 0, clippedChars, 0, string.length);
            clippedChars[endIndex] = 46;
            clippedChars[endIndex + 1] = 46;
            clippedChars[endIndex + 2] = 46;
            clipped = new String(clippedChars, 0, endIndex + 3);
        }
        return clipped;
    }

    public static void invokeLater(Runnable doRun) {
        EventQueue.invokeLater(doRun);
    }

    public static void invokeAndWait(Runnable doRun) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(doRun);
    }

    public static boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public static void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h) {
        Container parent = c.getParent();
        if (parent != null) {
            parent.remove(c);
        }
        if (p != null) {
            p.add(c);
        }
        Shape savedClip = g.getClip();
        g.setClip(x, y, w, h);
        g.translate(x, y);
        c.paint(g);
        g.translate(-x, -y);
        g.setClip(savedClip);
    }

    public static void paintComponent(Graphics g, Component c, Container p, Rectangle r) {
        SwingUtilities.paintComponent(g, c, p, r.x, r.y, r.width, r.height);
    }

    static Window getOwnerFrame(Window owner) {
        Window result = owner;
        if (result == null) {
            if (ownerFrame == null) {
                ownerFrame = new OwnerFrame();
            }
            result = ownerFrame;
        }
        return result;
    }

    public static boolean isLeftMouseButton(MouseEvent event) {
        return (event.getModifiers() & 0x10) != 0;
    }

    public static boolean isMiddleMouseButton(MouseEvent event) {
        return (event.getModifiersEx() & 0x800) == 2048;
    }

    public static boolean isRightMouseButton(MouseEvent event) {
        return (event.getModifiersEx() & 0x1000) == 4096;
    }

    public static boolean notifyAction(Action action, KeyStroke ks, KeyEvent event, Object sender, int modifiers) {
        if (action != null && action.isEnabled()) {
            String name = (String)action.getValue("ActionCommandKey");
            if (name == null && event.getKeyChar() != '\uffff') {
                name = new String(new char[]{event.getKeyChar()});
            }
            action.actionPerformed(new ActionEvent(sender, 1001, name, modifiers));
            return true;
        }
        return false;
    }

    public static void replaceUIActionMap(JComponent component, ActionMap uiActionMap) {
        ActionMap child = component.getActionMap();
        if (child == null) {
            component.setActionMap(uiActionMap);
        } else {
            ActionMap parent = child.getParent();
            while (parent != null && !(parent instanceof ActionMapUIResource)) {
                child = parent;
                parent = child.getParent();
            }
            if (child != uiActionMap) {
                child.setParent(uiActionMap);
            }
        }
    }

    public static void replaceUIInputMap(JComponent component, int condition, InputMap uiInputMap) {
        InputMap child = component.getInputMap(condition);
        if (child == null) {
            component.setInputMap(condition, uiInputMap);
        } else {
            InputMap parent = child.getParent();
            while (parent != null && !(parent instanceof InputMapUIResource)) {
                child = parent;
                parent = parent.getParent();
            }
            if (child != uiInputMap) {
                child.setParent(uiInputMap);
            }
        }
    }

    public static Rectangle[] computeDifference(Rectangle rectA, Rectangle rectB) {
        if (rectA == null || rectB == null) {
            return new Rectangle[0];
        }
        Rectangle[] r = new Rectangle[4];
        int x1 = rectA.x;
        int y1 = rectA.y;
        int w1 = rectA.width;
        int h1 = rectA.height;
        int x2 = rectB.x;
        int y2 = rectB.y;
        int w2 = rectB.width;
        int h2 = rectB.height;
        int H0 = y2 > y1 ? y2 - y1 : 0;
        int H3 = y2 + h2 < y1 + h1 ? y1 + h1 - y2 - h2 : 0;
        int W1 = x2 > x1 ? x2 - x1 : 0;
        int W2 = x1 + w1 > x2 + w2 ? x1 + w1 - x2 - w2 : 0;
        int H12 = H0 + H3 < h1 ? h1 - H0 - H3 : 0;
        r[0] = H0 > 0 ? new Rectangle(x1, y1, w1, H0) : null;
        r[1] = W1 > 0 && H12 > 0 ? new Rectangle(x1, y1 + H0, W1, H12) : null;
        r[2] = W2 > 0 && H12 > 0 ? new Rectangle(x2 + w2, y1 + H0, W2, H12) : null;
        r[3] = H3 > 0 ? new Rectangle(x1, y1 + H0 + H12, w1, H3) : null;
        int n = 0;
        int i = 0;
        while (i < 4) {
            if (r[i] != null) {
                ++n;
            }
            ++i;
        }
        Rectangle[] out = new Rectangle[n];
        int i2 = 3;
        while (i2 >= 0) {
            if (r[i2] != null) {
                out[--n] = r[i2];
            }
            --i2;
        }
        return out;
    }

    public static Rectangle computeIntersection(int x, int y, int w, int h, Rectangle rect) {
        int dh;
        int x2 = rect.x;
        int y2 = rect.y;
        int w2 = rect.width;
        int h2 = rect.height;
        int dx = x > x2 ? x : x2;
        int dy = y > y2 ? y : y2;
        int dw = x + w < x2 + w2 ? x + w - dx : x2 + w2 - dx;
        int n = dh = y + h < y2 + h2 ? y + h - dy : y2 + h2 - dy;
        if (dw >= 0 && dh >= 0) {
            rect.setBounds(dx, dy, dw, dh);
        } else {
            rect.setBounds(0, 0, 0, 0);
        }
        return rect;
    }

    public static int computeStringWidth(FontMetrics fm, String str) {
        return fm.stringWidth(str);
    }

    public static Rectangle computeUnion(int x, int y, int w, int h, Rectangle rect) {
        int dh;
        int x2 = rect.x;
        int y2 = rect.y;
        int w2 = rect.width;
        int h2 = rect.height;
        int dx = x < x2 ? x : x2;
        int dy = y < y2 ? y : y2;
        int dw = x + w > x2 + w2 ? x + w - dx : x2 + w2 - dx;
        int n = dh = y + h > y2 + h2 ? y + h - dy : y2 + h2 - dy;
        if (dw >= 0 && dh >= 0) {
            rect.setBounds(dx, dy, dw, dh);
        } else {
            rect.setBounds(0, 0, 0, 0);
        }
        return rect;
    }

    public static boolean isRectangleContainingRectangle(Rectangle a, Rectangle b) {
        return b.width >= 0 && b.height >= 0 && b.width >= 0 && b.height >= 0 && b.x >= a.x && b.x + b.width <= a.x + a.width && b.y >= a.y && b.y + b.height <= a.y + a.height;
    }

    public static InputMap getUIInputMap(JComponent component, int cond) {
        if (UIManager.getUI(component) != null) {
            return component.getInputMap(cond).getParent();
        }
        return null;
    }

    public static ActionMap getUIActionMap(JComponent component) {
        if (UIManager.getUI(component) != null) {
            return component.getActionMap().getParent();
        }
        return null;
    }

    public static boolean processKeyBindings(KeyEvent ev) {
        Component c = ev.getComponent();
        KeyStroke s = KeyStroke.getKeyStrokeForEvent(ev);
        KeyboardManager km = KeyboardManager.getManager();
        return km.processKeyStroke(c, s, ev);
    }

    static String convertHorizontalAlignmentCodeToString(int code) {
        switch (code) {
            case 0: {
                return "CENTER";
            }
            case 2: {
                return "LEFT";
            }
            case 4: {
                return "RIGHT";
            }
            case 10: {
                return "LEADING";
            }
            case 11: {
                return "TRAILING";
            }
        }
        throw new IllegalArgumentException("Unrecognised code: " + code);
    }

    static String convertVerticalAlignmentCodeToString(int code) {
        switch (code) {
            case 0: {
                return "CENTER";
            }
            case 1: {
                return "TOP";
            }
            case 3: {
                return "BOTTOM";
            }
        }
        throw new IllegalArgumentException("Unrecognised code: " + code);
    }

    static String convertWindowConstantToString(int code) {
        switch (code) {
            case 0: {
                return "DO_NOTHING_ON_CLOSE";
            }
            case 1: {
                return "HIDE_ON_CLOSE";
            }
            case 2: {
                return "DISPOSE_ON_CLOSE";
            }
            case 3: {
                return "EXIT_ON_CLOSE";
            }
        }
        throw new IllegalArgumentException("Unrecognised code: " + code);
    }

    static void convertRectangleToAncestor(Component comp, Rectangle r, Component ancestor) {
        if (comp == ancestor) {
            return;
        }
        r.x += comp.getX();
        r.y += comp.getY();
        Container parent = comp.getParent();
        if (parent != null && parent != ancestor) {
            SwingUtilities.convertRectangleToAncestor(parent, r, ancestor);
        }
    }

    private static class OwnerFrame
    extends Frame {
        private OwnerFrame() {
        }

        public void setVisible(boolean b) {
        }

        public boolean isShowing() {
            return true;
        }
    }
}

