/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import gnu.javax.management.Translator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanServerInvocationHandler
implements InvocationHandler {
    private MBeanServerConnection conn;
    private ObjectName name;
    private boolean mxBean;
    private Class<?> iface;

    public MBeanServerInvocationHandler(MBeanServerConnection conn, ObjectName name) {
        this(conn, name, false);
    }

    public MBeanServerInvocationHandler(MBeanServerConnection conn, ObjectName name, boolean mxBean) {
        this.conn = conn;
        this.name = name;
        this.mxBean = mxBean;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.conn;
    }

    public ObjectName getObjectName() {
        return this.name;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String[] sigs;
        String mName = method.getName();
        Class<? extends Object> proxyClass = proxy.getClass();
        if (mName.equals("toString")) {
            if (this.inInterface(mName, proxyClass, new Class[0])) {
                return this.conn.invoke(this.name, mName, null, null);
            }
            return String.valueOf(proxyClass.getName()) + "[name=" + this.name + ", conn=" + this.conn + "]";
        }
        if (mName.equals("hashCode")) {
            if (this.inInterface(mName, proxyClass, new Class[0])) {
                return this.conn.invoke(this.name, mName, null, null);
            }
            return this.conn.hashCode() + this.name.hashCode() + (this.iface == null ? 0 : this.iface.hashCode());
        }
        if (mName.equals("equals")) {
            if (this.inInterface(mName, proxyClass, Object.class)) {
                return this.conn.invoke(this.name, mName, new Object[]{args[0]}, new String[]{"java.lang.Object"});
            }
            if (args[0].getClass() != proxy.getClass()) {
                return false;
            }
            InvocationHandler ih = Proxy.getInvocationHandler(args[0]);
            if (ih instanceof MBeanServerInvocationHandler) {
                MBeanServerInvocationHandler h = (MBeanServerInvocationHandler)ih;
                if (this.conn.equals(h.getMBeanServerConnection()) && this.name.equals(h.getObjectName()) && (this.iface == null ? h.iface == null : this.iface.equals(h.iface))) {
                    return true;
                }
                return false;
            }
            return false;
        }
        if (NotificationEmitter.class.isAssignableFrom(proxyClass)) {
            if (mName.equals("addNotificationListener")) {
                this.conn.addNotificationListener(this.name, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
                return null;
            }
            if (mName.equals("getNotificationInfo")) {
                return this.conn.getMBeanInfo(this.name).getNotifications();
            }
            if (mName.equals("removeNotificationListener")) {
                if (args.length == 1) {
                    this.conn.removeNotificationListener(this.name, (NotificationListener)args[0]);
                } else {
                    this.conn.removeNotificationListener(this.name, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
                }
                return null;
            }
        }
        if (args == null) {
            sigs = null;
        } else {
            sigs = new String[args.length];
            int a = 0;
            while (a < args.length) {
                sigs[a] = args[a].getClass().getName();
                ++a;
            }
        }
        String attrib = null;
        if (mName.startsWith("get")) {
            attrib = mName.substring(3);
        } else if (mName.startsWith("is")) {
            attrib = mName.substring(2);
        }
        if (attrib != null) {
            Object val = this.conn.getAttribute(this.name, attrib);
            if (this.mxBean) {
                return Translator.toJava(val, method);
            }
            return val;
        }
        if (mName.startsWith("set")) {
            Object arg = this.mxBean ? Translator.fromJava(args, method)[0] : args[0];
            this.conn.setAttribute(this.name, new Attribute(mName.substring(3), arg));
            return null;
        }
        if (this.mxBean) {
            return Translator.toJava(this.conn.invoke(this.name, mName, Translator.fromJava(args, method), sigs), method);
        }
        return this.conn.invoke(this.name, mName, args, sigs);
    }

    public boolean isMXBean() {
        return this.mxBean;
    }

    public static <T> T newProxyInstance(MBeanServerConnection conn, ObjectName name, Class<T> iface, boolean broadcaster) {
        if (broadcaster) {
            return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface, NotificationEmitter.class}, new MBeanServerInvocationHandler(conn, name));
        }
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, new MBeanServerInvocationHandler(conn, name));
    }

    private boolean inInterface(String name, Class<?> proxyClass, Class<?> ... args) {
        Class<?>[] classArray = proxyClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            try {
                iface.getMethod(name, args);
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ++n2;
            }
        }
        return false;
    }
}

