/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.classpath.Configuration;
import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;

public class CipherInputStream
extends FilterInputStream {
    private static final Logger logger = SystemLogger.SYSTEM;
    private final Cipher cipher;
    private byte[] outBuffer;
    private int outOffset;
    private final boolean isStream;
    private boolean eof;

    public CipherInputStream(InputStream in, Cipher cipher) {
        super(in);
        this.cipher = cipher;
        this.isStream = cipher.getBlockSize() == 1;
        this.eof = false;
        if (Configuration.DEBUG) {
            logger.log((Level)Component.CRYPTO, "I am born; cipher: {0}, stream? {1}", new Object[]{cipher.getAlgorithm(), this.isStream});
        }
    }

    protected CipherInputStream(InputStream in) {
        this(in, new NullCipher());
    }

    public int available() throws IOException {
        if (this.isStream) {
            return super.available();
        }
        if (this.outBuffer == null || this.outOffset >= this.outBuffer.length) {
            this.nextBlock();
        }
        return this.outBuffer.length - this.outOffset;
    }

    public synchronized void close() throws IOException {
        super.close();
    }

    public synchronized int read() throws IOException {
        if (this.isStream) {
            byte[] buf = new byte[1];
            int in = super.read();
            if (in == -1) {
                return -1;
            }
            buf[0] = (byte)in;
            try {
                this.cipher.update(buf, 0, 1, buf, 0);
            }
            catch (ShortBufferException shouldNotHappen) {
                throw new IOException(shouldNotHappen.getMessage());
            }
            return buf[0] & 0xFF;
        }
        if (this.outBuffer == null || this.outOffset == this.outBuffer.length) {
            if (this.eof) {
                return -1;
            }
            this.nextBlock();
        }
        return this.outBuffer[this.outOffset++] & 0xFF;
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            return (int)this.skip(len);
        }
        if (this.isStream) {
            if ((len = super.read(buf, off, len)) > 0) {
                try {
                    this.cipher.update(buf, off, len, buf, off);
                }
                catch (ShortBufferException shouldNotHappen) {
                    IOException ioe = new IOException("Short buffer for stream cipher -- this should not happen");
                    ioe.initCause(shouldNotHappen);
                    throw ioe;
                }
            }
            return len;
        }
        int count = 0;
        while (count < len) {
            if (this.outBuffer == null || this.outOffset >= this.outBuffer.length) {
                if (this.eof) {
                    if (count != 0) break;
                    count = -1;
                    break;
                }
                this.nextBlock();
            }
            int l = Math.min(this.outBuffer.length - this.outOffset, len - count);
            System.arraycopy(this.outBuffer, this.outOffset, buf, count + off, l);
            count += l;
            this.outOffset += l;
        }
        return count;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public long skip(long bytes) throws IOException {
        if (this.isStream) {
            return super.skip(bytes);
        }
        long ret = 0L;
        if (bytes > 0L && this.outBuffer != null && this.outOffset >= this.outBuffer.length) {
            ret = this.outBuffer.length - this.outOffset;
            this.outOffset = this.outBuffer.length;
        }
        return ret;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int mark) {
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    private void nextBlock() throws IOException {
        byte[] buf = new byte[this.cipher.getBlockSize()];
        if (Configuration.DEBUG) {
            logger.log(Component.CRYPTO, "getting a new data block");
        }
        try {
            this.outBuffer = null;
            this.outOffset = 0;
            while (this.outBuffer == null) {
                int l = this.in.read(buf);
                if (Configuration.DEBUG) {
                    logger.log((Level)Component.CRYPTO, "we read {0} bytes", l);
                }
                if (l == -1) {
                    this.outBuffer = this.cipher.doFinal();
                    this.eof = true;
                    return;
                }
                try {
                    this.outOffset = 0;
                    this.outBuffer = this.cipher.update(buf, 0, l);
                }
                catch (BadPaddingException bpe) {
                    IOException ioe = new IOException("bad padding");
                    ioe.initCause(bpe);
                    throw ioe;
                }
                catch (IllegalBlockSizeException ibse) {
                    IOException ioe = new IOException("illegal block size");
                    ioe.initCause(ibse);
                    throw ioe;
                }
            }
        }
        finally {
            if (Configuration.DEBUG) {
                logger.log((Level)Component.CRYPTO, "decrypted {0} bytes for reading", this.outBuffer.length);
            }
        }
    }
}

