/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.locale.LocaleHelper;
import java.io.IOException;
import java.io.Serializable;
import java.text.spi.DateFormatSymbolsProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.spi.TimeZoneNameProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateFormatSymbols
implements Serializable,
Cloneable {
    private static final transient Properties properties = new Properties();
    private static final Pattern ZONE_SEP;
    private static final Pattern FIELD_SEP;
    private static final ConcurrentMap<Locale, DFSData> dataCache;
    String[] ampms;
    String[] eras;
    private String localPatternChars;
    String[] months;
    String[] shortMonths;
    String[] shortWeekdays;
    String[] weekdays;
    private String[][] runtimeZoneStrings;
    private String[][] zoneStrings;
    private static final long serialVersionUID = -5987973545549424702L;
    private static final String[] formatPrefixes;
    transient String[] dateFormats;
    transient String[] timeFormats;

    static {
        try {
            properties.load(DateFormatSymbols.class.getResourceAsStream("metazones.properties"));
        }
        catch (IOException exception) {
            System.out.println("Failed to load weeks resource: " + exception);
        }
        ZONE_SEP = Pattern.compile("\u00a9");
        FIELD_SEP = Pattern.compile("\u00ae");
        dataCache = new ConcurrentHashMap<Locale, DFSData>();
        formatPrefixes = new String[]{"full", "long", "medium", "short"};
    }

    private static String[] getStringArray(List<ResourceBundle> bundles, String name, int size) {
        return DateFormatSymbols.getStringArray(bundles, name, size, null);
    }

    private static String[] getStringArray(List<ResourceBundle> bundles, String name, int size, String[] fallback) {
        Object[] data = new String[size];
        Arrays.fill(data, "");
        int a = 0;
        while (a < bundles.size()) {
            String localeData = bundles.get(a).getString(name);
            String[] array = FIELD_SEP.split(localeData, size);
            int b = 0;
            while (b < data.length) {
                if (array.length > b && array[b] != null && ((String)data[b]).isEmpty() && !array[b].isEmpty()) {
                    data[b] = array[b];
                }
                ++b;
            }
            ++a;
        }
        if (fallback != null && fallback.length == size) {
            a = 0;
            while (a < data.length) {
                if (((String)data[a]).isEmpty() && fallback[a] != null && !fallback[a].isEmpty()) {
                    data[a] = fallback[a];
                }
                ++a;
            }
        }
        return data;
    }

    private static String[][] getZoneStrings(List<ResourceBundle> bundles, Locale locale) {
        ArrayList<Object> allZones = new ArrayList<Object>();
        try {
            String type;
            HashMap<String, String[]> systemZones = new HashMap<String, String[]>();
            for (ResourceBundle bundle : bundles) {
                String country = locale.getCountry();
                String data = bundle.getString("zoneStrings");
                String[] zones = ZONE_SEP.split(data);
                int a = 0;
                while (a < zones.length) {
                    String[] existing;
                    int b;
                    String[] strings = FIELD_SEP.split(zones[a]);
                    type = properties.getProperty(String.valueOf(strings[0]) + "." + country);
                    if (type == null) {
                        type = properties.getProperty(String.valueOf(strings[0]) + ".DEFAULT");
                    }
                    if (type != null) {
                        strings[0] = type;
                    }
                    if (strings.length < 5) {
                        String[] newStrings = new String[5];
                        System.arraycopy(strings, 0, newStrings, 0, strings.length);
                        b = strings.length;
                        while (b < newStrings.length) {
                            newStrings[b] = "";
                            ++b;
                        }
                        strings = newStrings;
                    }
                    if ((existing = (String[])systemZones.get(strings[0])) != null && existing.length > 1) {
                        b = 1;
                        while (b < existing.length) {
                            if (!existing[b].equals("")) {
                                strings[b] = existing[b];
                            }
                            ++b;
                        }
                    }
                    systemZones.put(strings[0], strings);
                    ++a;
                }
            }
            for (String[] zstrings : systemZones.values()) {
                if (!zstrings[1].equals("") || !zstrings[2].equals("")) continue;
                for (Map.Entry entry : properties.entrySet()) {
                    String val = (String)entry.getValue();
                    if (!val.equals(zstrings[0])) continue;
                    String key = (String)entry.getKey();
                    String metazone = key.substring(0, key.indexOf("."));
                    type = properties.getProperty(String.valueOf(metazone) + "." + locale.getCountry());
                    if (type == null) {
                        type = properties.getProperty(String.valueOf(metazone) + ".DEFAULT");
                    }
                    if (type == null) continue;
                    String[] ostrings = (String[])systemZones.get(type);
                    zstrings[1] = ostrings[1];
                    zstrings[2] = ostrings[2];
                }
            }
            allZones.addAll(systemZones.values());
        }
        catch (MissingResourceException missingResourceException) {}
        block8: for (TimeZoneNameProvider p : ServiceLoader.load(TimeZoneNameProvider.class)) {
            Locale[] localeArray = p.getAvailableLocales();
            int n = localeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Locale loc = localeArray[n2];
                if (loc.equals(locale)) {
                    String[] stringArray = TimeZone.getAvailableIDs();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String id = stringArray[n4];
                        String[] z = new String[]{id, p.getDisplayName(id, false, 1, locale), p.getDisplayName(id, false, 0, locale), p.getDisplayName(id, true, 1, locale), p.getDisplayName(id, true, 0, locale)};
                        allZones.add(z);
                        ++n4;
                    }
                    continue block8;
                }
                ++n2;
            }
        }
        return (String[][])allZones.toArray((T[])new String[allZones.size()][]);
    }

    private static String[] formatsForKey(List<ResourceBundle> bundles, String key) {
        String[] values = new String[formatPrefixes.length];
        int i = 0;
        while (i < formatPrefixes.length) {
            values[i] = DateFormatSymbols.getString(bundles, String.valueOf(formatPrefixes[i]) + key);
            ++i;
        }
        return values;
    }

    private static String getString(List<ResourceBundle> bundles, String key) {
        String val = null;
        for (ResourceBundle bundle : bundles) {
            val = bundle.getString(key);
            if (val == null || val.isEmpty()) continue;
            return val;
        }
        return val;
    }

    private static DFSData retrieveData(Locale locale) throws MissingResourceException {
        DFSData data = (DFSData)dataCache.get(locale);
        if (data == null) {
            ClassLoader ldr = ClassLoader.getSystemClassLoader();
            ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
            ResourceBundle res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale, ldr);
            bundles.add(res);
            Locale resLocale = res.getLocale();
            while (resLocale != Locale.ROOT) {
                res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", LocaleHelper.getFallbackLocale(resLocale), ldr);
                bundles.add(res);
                resLocale = res.getLocale();
            }
            String[] lMonths = DateFormatSymbols.getStringArray(bundles, "months", 13);
            String[] lWeekdays = DateFormatSymbols.getStringArray(bundles, "weekdays", 8);
            data = new DFSData(DateFormatSymbols.getStringArray(bundles, "ampms", 2), DateFormatSymbols.getStringArray(bundles, "eras", 2), DateFormatSymbols.getString(bundles, "localPatternChars"), lMonths, DateFormatSymbols.getStringArray(bundles, "shortMonths", 13, lMonths), lWeekdays, DateFormatSymbols.getStringArray(bundles, "shortWeekdays", 8, lWeekdays), DateFormatSymbols.formatsForKey(bundles, "DateFormat"), DateFormatSymbols.formatsForKey(bundles, "TimeFormat"), DateFormatSymbols.getZoneStrings(bundles, locale));
            DFSData cachedData = dataCache.putIfAbsent(locale, data);
            if (cachedData != null) {
                data = cachedData;
            }
        }
        return data;
    }

    public DateFormatSymbols(Locale locale) throws MissingResourceException {
        DFSData data = DateFormatSymbols.retrieveData(locale);
        this.ampms = data.getAMPMs();
        this.eras = data.getEras();
        this.localPatternChars = data.getLocalPatternChars();
        this.months = data.getMonths();
        this.shortMonths = data.getShortMonths();
        this.weekdays = data.getWeekdays();
        this.shortWeekdays = data.getShortWeekdays();
        this.dateFormats = data.getDateFormats();
        this.timeFormats = data.getTimeFormats();
        this.runtimeZoneStrings = data.getZoneStrings();
    }

    public DateFormatSymbols() throws MissingResourceException {
        this(Locale.getDefault());
    }

    public String[] getAmPmStrings() {
        return this.ampms;
    }

    public String[] getEras() {
        return this.eras;
    }

    public String getLocalPatternChars() {
        return this.localPatternChars;
    }

    public String[] getMonths() {
        return this.months;
    }

    public String[] getShortMonths() {
        return this.shortMonths;
    }

    public String[] getShortWeekdays() {
        return this.shortWeekdays;
    }

    public String[] getWeekdays() {
        return this.weekdays;
    }

    public String[][] getZoneStrings() {
        if (this.zoneStrings != null) {
            return this.zoneStrings;
        }
        return this.runtimeZoneStrings;
    }

    public void setAmPmStrings(String[] value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.ampms = value;
    }

    public void setEras(String[] labels) {
        if (labels == null) {
            throw new NullPointerException();
        }
        this.eras = labels;
    }

    public void setLocalPatternChars(String chars) {
        if (chars == null) {
            throw new NullPointerException();
        }
        this.localPatternChars = chars;
    }

    public void setMonths(String[] labels) {
        if (labels == null) {
            throw new NullPointerException();
        }
        this.months = labels;
    }

    public void setShortMonths(String[] labels) {
        if (labels == null) {
            throw new NullPointerException();
        }
        this.shortMonths = labels;
    }

    public void setShortWeekdays(String[] labels) {
        if (labels == null) {
            throw new NullPointerException();
        }
        this.shortWeekdays = labels;
    }

    public void setWeekdays(String[] labels) {
        if (labels == null) {
            throw new NullPointerException();
        }
        this.weekdays = labels;
    }

    public void setZoneStrings(String[][] zones) {
        if (zones == null) {
            throw new NullPointerException();
        }
        this.zoneStrings = zones;
    }

    private static boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (!(x instanceof Object[]) || !(y instanceof Object[])) {
            return x.equals(y);
        }
        Object[] xa = (Object[])x;
        Object[] ya = (Object[])y;
        if (xa.length != ya.length) {
            return false;
        }
        int i = xa.length;
        while (--i >= 0) {
            if (DateFormatSymbols.equals(xa[i], ya[i])) continue;
            return false;
        }
        return true;
    }

    private static int hashCode(Object x) {
        if (x == null) {
            return 0;
        }
        if (!(x instanceof Object[])) {
            return x.hashCode();
        }
        Object[] xa = (Object[])x;
        int hash = 0;
        int i = 0;
        while (i < xa.length) {
            hash = 37 * DateFormatSymbols.hashCode(xa[i]);
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DateFormatSymbols)) {
            return false;
        }
        DateFormatSymbols other = (DateFormatSymbols)obj;
        return DateFormatSymbols.equals(this.ampms, other.ampms) && DateFormatSymbols.equals(this.eras, other.eras) && DateFormatSymbols.equals(this.localPatternChars, other.localPatternChars) && DateFormatSymbols.equals(this.months, other.months) && DateFormatSymbols.equals(this.shortMonths, other.shortMonths) && DateFormatSymbols.equals(this.shortWeekdays, other.shortWeekdays) && DateFormatSymbols.equals(this.weekdays, other.weekdays) && DateFormatSymbols.equals(this.zoneStrings, other.zoneStrings);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int hashCode() {
        return DateFormatSymbols.hashCode(this.ampms) ^ DateFormatSymbols.hashCode(this.eras) ^ DateFormatSymbols.hashCode(this.localPatternChars) ^ DateFormatSymbols.hashCode(this.months) ^ DateFormatSymbols.hashCode(this.shortMonths) ^ DateFormatSymbols.hashCode(this.shortWeekdays) ^ DateFormatSymbols.hashCode(this.weekdays) ^ DateFormatSymbols.hashCode(this.zoneStrings);
    }

    public static final DateFormatSymbols getInstance() {
        return DateFormatSymbols.getInstance(Locale.getDefault());
    }

    /*
     * Unable to fully structure code
     */
    public static final DateFormatSymbols getInstance(Locale locale) {
        try {
            syms = new DateFormatSymbols(locale);
            return syms;
        }
        catch (MissingResourceException v0) {
            ** for (p : ServiceLoader.load(DateFormatSymbolsProvider.class))
        }
lbl-1000:
        // 1 sources

        {
            var6_7 = p.getAvailableLocales();
            var5_6 = var6_7.length;
            var4_5 = 0;
            while (var4_5 < var5_6) {
                loc = var6_7[var4_5];
                if (loc.equals(locale)) {
                    syms = p.getInstance(locale);
                    if (syms == null) continue block2;
                    return syms;
                }
                ++var4_5;
            }
            continue;
        }
lbl18:
        // 1 sources

        return DateFormatSymbols.getInstance(LocaleHelper.getFallbackLocale(locale));
    }

    private static class DFSData {
        private String[] ampms;
        private String[] eras;
        private String localPatternChars;
        private String[] months;
        private String[] shortMonths;
        private String[] weekdays;
        private String[] shortWeekdays;
        private String[] dateFormats;
        private String[] timeFormats;
        private String[][] runtimeZoneStrings;

        public DFSData(String[] ampms, String[] eras, String localPatternChars, String[] months, String[] shortMonths, String[] weekdays, String[] shortWeekdays, String[] dateFormats, String[] timeFormats, String[][] runtimeZoneStrings) {
            this.ampms = ampms;
            this.eras = eras;
            this.localPatternChars = localPatternChars;
            this.months = months;
            this.shortMonths = shortMonths;
            this.weekdays = weekdays;
            this.shortWeekdays = shortWeekdays;
            this.dateFormats = dateFormats;
            this.timeFormats = timeFormats;
            this.runtimeZoneStrings = runtimeZoneStrings;
        }

        public String[] getAMPMs() {
            return (String[])this.ampms.clone();
        }

        public String[] getEras() {
            return (String[])this.eras.clone();
        }

        public String getLocalPatternChars() {
            return this.localPatternChars;
        }

        public String[] getMonths() {
            return (String[])this.months.clone();
        }

        public String[] getShortMonths() {
            return (String[])this.shortMonths.clone();
        }

        public String[] getWeekdays() {
            return (String[])this.weekdays.clone();
        }

        public String[] getShortWeekdays() {
            return (String[])this.shortWeekdays.clone();
        }

        public String[] getDateFormats() {
            return (String[])this.dateFormats.clone();
        }

        public String[] getTimeFormats() {
            return (String[])this.timeFormats.clone();
        }

        public String[][] getZoneStrings() {
            String[][] clone = (String[][])this.runtimeZoneStrings.clone();
            int a = 0;
            while (a < clone.length) {
                clone[a] = (String[])this.runtimeZoneStrings[a].clone();
                ++a;
            }
            return clone;
        }
    }
}

