/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import gnu.java.nio.ChannelReader;
import gnu.java.nio.ChannelWriter;
import gnu.java.nio.InputStreamChannel;
import gnu.java.nio.OutputStreamChannel;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.VMChannels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public final class Channels {
    private Channels() {
    }

    public static InputStream newInputStream(ReadableByteChannel ch) {
        return VMChannels.newInputStream(ch);
    }

    public static OutputStream newOutputStream(WritableByteChannel ch) {
        return VMChannels.newOutputStream(ch);
    }

    public static ReadableByteChannel newChannel(InputStream in) {
        return new InputStreamChannel(in);
    }

    public static WritableByteChannel newChannel(OutputStream out) {
        return new OutputStreamChannel(out);
    }

    public static Reader newReader(ReadableByteChannel ch, CharsetDecoder dec, int minBufferCap) {
        return new ChannelReader(ch, dec, minBufferCap);
    }

    public static Reader newReader(ReadableByteChannel ch, String csName) {
        return Channels.newReader(ch, Charset.forName(csName).newDecoder(), -1);
    }

    public static Writer newWriter(WritableByteChannel ch, CharsetEncoder enc, int minBufferCap) {
        return new ChannelWriter(ch, enc, minBufferCap);
    }

    public static Writer newWriter(WritableByteChannel ch, String csName) {
        return Channels.newWriter(ch, Charset.forName(csName).newEncoder(), -1);
    }
}

