/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.gcj.RawData;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.CharBufferImpl;
import java.nio.CharSequenceBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CharBuffer
extends Buffer
implements Comparable<CharBuffer>,
CharSequence,
Readable,
Appendable {
    final int array_offset;
    final char[] backing_buffer;

    CharBuffer(int capacity, int limit, int position, int mark, RawData address, char[] backing_buffer, int array_offset) {
        super(capacity, limit, position, mark, address);
        this.backing_buffer = backing_buffer;
        this.array_offset = array_offset;
    }

    public static CharBuffer allocate(int capacity) {
        return new CharBufferImpl(capacity);
    }

    public static final CharBuffer wrap(char[] array, int offset, int length) {
        return new CharBufferImpl(array, 0, array.length, offset + length, offset, -1, false);
    }

    public static final CharBuffer wrap(CharSequence seq) {
        return CharBuffer.wrap(seq, 0, seq.length());
    }

    public static final CharBuffer wrap(CharSequence seq, int start, int end) {
        return new CharSequenceBuffer(seq, start, end);
    }

    public static final CharBuffer wrap(char[] array) {
        return CharBuffer.wrap(array, 0, array.length);
    }

    public CharBuffer get(char[] dst, int offset, int length) {
        CharBuffer.checkArraySize(dst.length, offset, length);
        this.checkForUnderflow(length);
        int i = offset;
        while (i < offset + length) {
            dst[i] = this.get();
            ++i;
        }
        return this;
    }

    @Override
    public int read(CharBuffer buffer) throws IOException {
        int rem = Math.min(buffer.remaining(), this.remaining());
        char[] buf = new char[rem];
        this.get(buf);
        buffer.put(buf);
        return rem;
    }

    public CharBuffer get(char[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public CharBuffer put(CharBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(src.remaining());
        if (src.remaining() > 0) {
            char[] toPut = new char[src.remaining()];
            src.get(toPut);
            this.put(toPut);
        }
        return this;
    }

    public CharBuffer put(char[] src, int offset, int length) {
        CharBuffer.checkArraySize(src.length, offset, length);
        this.checkForOverflow(length);
        int i = offset;
        while (i < offset + length) {
            this.put(src[i]);
            ++i;
        }
        return this;
    }

    public final CharBuffer put(char[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final char[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        int hashCode = this.get(this.position()) + 31;
        int multiplier = 1;
        int i = this.position() + 1;
        while (i < this.limit()) {
            hashCode += (this.get(i) + 30) * (multiplier *= 31);
            ++i;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CharBuffer) {
            return this.compareTo((CharBuffer)obj) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(CharBuffer other) {
        int num = Math.min(this.remaining(), other.remaining());
        int pos_this = this.position();
        int pos_other = other.position();
        int count = 0;
        while (count < num) {
            char b;
            char a;
            if ((a = this.get(pos_this++)) != (b = other.get(pos_other++))) {
                if (a < b) {
                    return -1;
                }
                return 1;
            }
            ++count;
        }
        return this.remaining() - other.remaining();
    }

    public abstract ByteOrder order();

    public abstract char get();

    public abstract CharBuffer put(char var1);

    public abstract char get(int var1);

    public abstract CharBuffer put(int var1, char var2);

    public abstract CharBuffer compact();

    public abstract boolean isDirect();

    public abstract CharBuffer slice();

    public abstract CharBuffer duplicate();

    public abstract CharBuffer asReadOnlyBuffer();

    @Override
    public String toString() {
        if (this.hasArray()) {
            return new String(this.array(), this.position(), this.length());
        }
        char[] buf = new char[this.length()];
        int pos = this.position();
        this.get(buf, 0, buf.length);
        this.position(pos);
        return new String(buf);
    }

    @Override
    public final int length() {
        return this.remaining();
    }

    @Override
    public abstract CharSequence subSequence(int var1, int var2);

    public CharBuffer put(String str, int start, int length) {
        return this.put(str.toCharArray(), start, length);
    }

    public final CharBuffer put(String str) {
        return this.put(str.toCharArray(), 0, str.length());
    }

    @Override
    public final char charAt(int index) {
        if (index < 0 || index >= this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        return this.get(this.position() + index);
    }

    @Override
    public CharBuffer append(char c) {
        this.put(c);
        return this;
    }

    @Override
    public CharBuffer append(CharSequence cs) {
        this.put(cs == null ? "null" : cs.toString());
        return this;
    }

    @Override
    public CharBuffer append(CharSequence cs, int start, int end) {
        this.put(cs == null ? "null" : cs.subSequence(start, end).toString());
        return this;
    }
}

