/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.InputStream;

public class StringBufferInputStream
extends InputStream {
    protected String buffer;
    protected int pos = 0;
    protected int count;

    public StringBufferInputStream(String s) {
        this.buffer = s;
        this.count = s.length();
    }

    public int available() {
        return this.count - this.pos;
    }

    public int read() {
        if (this.pos >= this.count) {
            return -1;
        }
        return this.buffer.charAt(this.pos++) & 0xFF;
    }

    public int read(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        int numRead = Math.min(len, this.count - this.pos);
        if (numRead < 0) {
            return 0;
        }
        this.buffer.getBytes(this.pos, this.pos + numRead, b, off);
        this.pos += numRead;
        return numRead;
    }

    public void reset() {
        this.pos = 0;
    }

    public long skip(long n) {
        if (n < 0L) {
            return 0L;
        }
        long actualSkip = Math.min(n, (long)(this.count - this.pos));
        this.pos = (int)((long)this.pos + actualSkip);
        return actualSkip;
    }
}

