/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.NullOutputStream;
import gnu.java.lang.reflect.TypeSignature;
import gnu.java.security.action.SetAccessibleAction;
import gnu.java.security.provider.Gnu;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.VMObjectStreamClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStreamClass
implements Serializable {
    static final ObjectStreamField[] INVALID_FIELDS = new ObjectStreamField[0];
    private ObjectStreamClass[] hierarchy = null;
    static final Class[] noArgs = new Class[0];
    static Hashtable methodCache = new Hashtable();
    static final Class[] readObjectSignature = new Class[]{ObjectInputStream.class};
    static final Class[] writeObjectSignature = new Class[]{ObjectOutputStream.class};
    static Hashtable uidCache = new Hashtable();
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static Hashtable<Class, ObjectStreamClass> classLookupTable = new Hashtable();
    private static final NullOutputStream nullOutputStream = new NullOutputStream();
    private static final Comparator interfaceComparator = new InterfaceComparator();
    private static final Comparator memberComparator = new MemberComparator();
    private static final Class[] writeMethodArgTypes = new Class[]{ObjectOutputStream.class};
    private ObjectStreamClass superClass;
    private Class<?> clazz;
    private String name;
    private long uid;
    private byte flags;
    ObjectStreamField[] fields;
    int primFieldSize = -1;
    int objectFieldCount;
    Method readObjectMethod;
    Method readResolveMethod;
    Method writeReplaceMethod;
    Method writeObjectMethod;
    boolean realClassIsSerializable;
    boolean realClassIsExternalizable;
    ObjectStreamField[] fieldMapping;
    Constructor firstNonSerializableParentConstructor;
    private Constructor constructor;
    boolean isProxyClass = false;
    private boolean fieldsSet = false;
    private static final long serialVersionUID = -6120832682080437368L;

    public static ObjectStreamClass lookup(Class<?> cl) {
        if (cl == null) {
            return null;
        }
        if (!Serializable.class.isAssignableFrom(cl)) {
            return null;
        }
        return ObjectStreamClass.lookupForClassObject(cl);
    }

    static ObjectStreamClass lookupForClassObject(Class cl) {
        if (cl == null) {
            return null;
        }
        ObjectStreamClass osc = classLookupTable.get(cl);
        if (osc != null) {
            return osc;
        }
        osc = new ObjectStreamClass(cl);
        classLookupTable.put(cl, osc);
        return osc;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> forClass() {
        return this.clazz;
    }

    public long getSerialVersionUID() {
        return this.uid;
    }

    public ObjectStreamField[] getFields() {
        ObjectStreamField[] copy = new ObjectStreamField[this.fields.length];
        System.arraycopy(this.fields, 0, copy, 0, this.fields.length);
        return copy;
    }

    public ObjectStreamField getField(String name) {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].getName().equals(name)) {
                return this.fields[i];
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return "java.io.ObjectStreamClass< " + this.name + ", " + this.uid + " >";
    }

    boolean hasWriteMethod() {
        return (this.flags & 1) != 0;
    }

    boolean isSerializable() {
        return (this.flags & 2) != 0;
    }

    boolean isExternalizable() {
        return (this.flags & 4) != 0;
    }

    boolean isEnum() {
        return (this.flags & 0x10) != 0;
    }

    ObjectStreamClass getSuper() {
        return this.superClass;
    }

    ObjectStreamClass[] hierarchy() {
        ObjectStreamClass[] result = this.hierarchy;
        if (result == null) {
            int d = 0;
            ObjectStreamClass osc = this;
            while (osc != null) {
                ++d;
                osc = osc.getSuper();
            }
            result = new ObjectStreamClass[d];
            osc = this;
            while (osc != null) {
                result[--d] = osc;
                osc = osc.getSuper();
            }
            this.hierarchy = result;
        }
        return result;
    }

    int getFlags() {
        return this.flags;
    }

    ObjectStreamClass(String name, long uid, byte flags, ObjectStreamField[] fields) {
        this.name = name;
        this.uid = uid;
        this.flags = flags;
        this.fields = fields;
    }

    void setClass(Class cl, ObjectStreamClass superClass) throws InvalidClassException {
        this.hierarchy = null;
        this.clazz = cl;
        this.cacheMethods();
        long class_uid = this.getClassUID(cl);
        if (this.uid == 0L) {
            this.uid = class_uid;
        } else if (!cl.isArray() && this.uid != class_uid) {
            String msg = cl + ": Local class not compatible: stream serialVersionUID=" + this.uid + ", local serialVersionUID=" + class_uid;
            throw new InvalidClassException(msg);
        }
        this.isProxyClass = this.clazz != null && Proxy.isProxyClass(this.clazz);
        this.superClass = superClass;
        this.calculateOffsets();
        try {
            Object[] exportedFields = this.getSerialPersistentFields(this.clazz);
            if (exportedFields == null) {
                return;
            }
            ObjectStreamField[] newFieldList = new ObjectStreamField[exportedFields.length + this.fields.length];
            Arrays.sort(exportedFields);
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < this.fields.length && j < exportedFields.length) {
                int comp = this.fields[i].compareTo(exportedFields[j]);
                if (comp < 0) {
                    newFieldList[k] = this.fields[i];
                    this.fields[i].setPersistent(false);
                    this.fields[i].setToSet(false);
                    ++i;
                } else if (comp > 0) {
                    newFieldList[k] = exportedFields[j];
                    newFieldList[k].setPersistent(true);
                    newFieldList[k].setToSet(false);
                    try {
                        newFieldList[k].lookupField(this.clazz);
                        newFieldList[k].checkFieldType();
                    }
                    catch (NoSuchFieldException noSuchFieldException) {}
                    ++j;
                } else {
                    try {
                        ((ObjectStreamField)exportedFields[j]).lookupField(this.clazz);
                        ((ObjectStreamField)exportedFields[j]).checkFieldType();
                    }
                    catch (NoSuchFieldException noSuchFieldException) {}
                    if (!this.fields[i].getType().equals(((ObjectStreamField)exportedFields[j]).getType())) {
                        throw new InvalidClassException("serialPersistentFields must be compatible with imported fields (about " + this.fields[i].getName() + ")");
                    }
                    newFieldList[k] = this.fields[i];
                    this.fields[i].setPersistent(true);
                    ++i;
                    ++j;
                }
                ++k;
            }
            if (i < this.fields.length) {
                while (i < this.fields.length) {
                    this.fields[i].setPersistent(false);
                    this.fields[i].setToSet(false);
                    newFieldList[k] = this.fields[i];
                    ++i;
                    ++k;
                }
            } else if (j < exportedFields.length) {
                while (j < exportedFields.length) {
                    ((ObjectStreamField)exportedFields[j]).setPersistent(true);
                    ((ObjectStreamField)exportedFields[j]).setToSet(false);
                    newFieldList[k] = exportedFields[j];
                    ++j;
                    ++k;
                }
            }
            this.fields = new ObjectStreamField[k];
            System.arraycopy(newFieldList, 0, this.fields, 0, k);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
    }

    void setSuperclass(ObjectStreamClass osc) {
        this.superClass = osc;
        this.hierarchy = null;
    }

    void calculateOffsets() {
        this.primFieldSize = 0;
        int fcount = this.fields.length;
        int i = 0;
        while (i < fcount) {
            ObjectStreamField field = this.fields[i];
            if (!field.isPrimitive()) break;
            field.setOffset(this.primFieldSize);
            switch (field.getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primFieldSize;
                    break;
                }
                case 'C': 
                case 'S': {
                    this.primFieldSize += 2;
                    break;
                }
                case 'F': 
                case 'I': {
                    this.primFieldSize += 4;
                    break;
                }
                case 'D': 
                case 'J': {
                    this.primFieldSize += 8;
                }
            }
            ++i;
        }
        this.objectFieldCount = 0;
        while (i < fcount) {
            this.fields[i].setOffset(this.objectFieldCount++);
            ++i;
        }
    }

    private Method findMethod(Method[] methods, String name, Class[] params, Class returnType, boolean mustBePrivate) {
        int i = 0;
        while (i < methods.length) {
            block4: {
                Class<?>[] mp;
                Method m = methods[i];
                int mods = m.getModifiers();
                if (!Modifier.isStatic(mods) && (!mustBePrivate || Modifier.isPrivate(mods)) && m.getName().equals(name) && m.getReturnType() == returnType && (mp = m.getParameterTypes()).length == params.length) {
                    int j = 0;
                    while (j < mp.length) {
                        if (mp[j] == params[j]) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    AccessController.doPrivileged(new SetAccessibleAction(m));
                    return m;
                }
            }
            ++i;
        }
        return null;
    }

    private static boolean inSamePackage(Class c1, Class c2) {
        String name1 = c1.getName();
        String name2 = c2.getName();
        int id1 = name1.lastIndexOf(46);
        int id2 = name2.lastIndexOf(46);
        if (id1 == -1 || id2 == -1) {
            return id1 == id2;
        }
        String package1 = name1.substring(0, id1);
        String package2 = name2.substring(0, id2);
        return package1.equals(package2);
    }

    private static Method findAccessibleMethod(String name, Class from) {
        Class c = from;
        while (c != null) {
            try {
                Method res = c.getDeclaredMethod(name, noArgs);
                int mods = res.getModifiers();
                if (c == from || Modifier.isProtected(mods) || Modifier.isPublic(mods) || !Modifier.isPrivate(mods) && ObjectStreamClass.inSamePackage(c, from)) {
                    AccessController.doPrivileged(new SetAccessibleAction(res));
                    return res;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            c = c.getSuperclass();
        }
        return null;
    }

    private static boolean loadedByBootOrApplicationClassLoader(Class cl) {
        ClassLoader l = cl.getClassLoader();
        return l == null || l == ClassLoader.getSystemClassLoader();
    }

    private void cacheMethods() {
        Class<?> cl = this.forClass();
        Method[] cached = (Method[])methodCache.get(cl);
        if (cached == null) {
            cached = new Method[4];
            Method[] methods = cl.getDeclaredMethods();
            cached[0] = this.findMethod(methods, "readObject", readObjectSignature, Void.TYPE, true);
            cached[1] = this.findMethod(methods, "writeObject", writeObjectSignature, Void.TYPE, true);
            cached[2] = ObjectStreamClass.findAccessibleMethod("readResolve", cl);
            cached[3] = ObjectStreamClass.findAccessibleMethod("writeReplace", cl);
            if (ObjectStreamClass.loadedByBootOrApplicationClassLoader(cl)) {
                methodCache.put(cl, cached);
            }
        }
        this.readObjectMethod = cached[0];
        this.writeObjectMethod = cached[1];
        this.readResolveMethod = cached[2];
        this.writeReplaceMethod = cached[3];
    }

    private ObjectStreamClass(Class cl) {
        this.uid = 0L;
        this.flags = 0;
        this.isProxyClass = Proxy.isProxyClass(cl);
        this.clazz = cl;
        this.cacheMethods();
        this.name = cl.getName();
        this.setFlags(cl);
        this.setFields(cl);
        if (Serializable.class.isAssignableFrom(cl) && !this.isProxyClass) {
            this.uid = this.getClassUID(cl);
        }
        this.superClass = ObjectStreamClass.lookup(cl.getSuperclass());
    }

    private void setFlags(Class cl) {
        if (Externalizable.class.isAssignableFrom(cl)) {
            this.flags = (byte)(this.flags | 4);
        } else if (Serializable.class.isAssignableFrom(cl)) {
            this.flags = (byte)(this.flags | 2);
        }
        if (this.writeObjectMethod != null) {
            this.flags = (byte)(this.flags | 1);
        }
        if (cl.isEnum() || cl == Enum.class) {
            this.flags = (byte)(this.flags | 0x10);
        }
    }

    final void ensureFieldsSet(Class cl) {
        if (!this.fieldsSet) {
            this.setFields(cl);
        }
    }

    private void setFields(Class cl) {
        SetAccessibleAction setAccessible;
        block16: {
            this.fieldsSet = true;
            setAccessible = new SetAccessibleAction();
            if (!this.isSerializable() || this.isExternalizable() || this.isEnum()) {
                this.fields = NO_FIELDS;
                return;
            }
            try {
                Field f = cl.getDeclaredField("serialPersistentFields");
                setAccessible.setMember(f);
                AccessController.doPrivileged(setAccessible);
                int modifiers = f.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || !Modifier.isPrivate(modifiers)) break block16;
                this.fields = this.getSerialPersistentFields(cl);
                if (this.fields == null) break block16;
                ObjectStreamField[] fieldsName = new ObjectStreamField[this.fields.length];
                System.arraycopy(this.fields, 0, fieldsName, 0, this.fields.length);
                Arrays.sort(fieldsName, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        ObjectStreamField f1 = (ObjectStreamField)o1;
                        ObjectStreamField f2 = (ObjectStreamField)o2;
                        return f1.getName().compareTo(f2.getName());
                    }
                });
                int i = 1;
                while (i < this.fields.length) {
                    if (fieldsName[i - 1].getName().equals(fieldsName[i].getName())) {
                        this.fields = INVALID_FIELDS;
                        return;
                    }
                    ++i;
                }
                Arrays.sort(this.fields);
                i = 0;
                while (i < this.fields.length) {
                    try {
                        this.fields[i].lookupField(cl);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        this.fields[i].setToSet(false);
                    }
                    ++i;
                }
                this.calculateOffsets();
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        int num_good_fields = 0;
        Field[] all_fields = cl.getDeclaredFields();
        int i = 0;
        while (i < all_fields.length) {
            int modifiers = all_fields[i].getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers)) {
                all_fields[i] = null;
            } else {
                ++num_good_fields;
            }
            ++i;
        }
        this.fields = new ObjectStreamField[num_good_fields];
        int from = 0;
        int to = 0;
        while (from < all_fields.length) {
            if (all_fields[from] != null) {
                Field f = all_fields[from];
                setAccessible.setMember(f);
                AccessController.doPrivileged(setAccessible);
                this.fields[to] = new ObjectStreamField(all_fields[from]);
                ++to;
            }
            ++from;
        }
        Arrays.sort(this.fields);
        i = 1;
        while (i < this.fields.length) {
            if (this.fields[i - 1].getName().equals(this.fields[i].getName())) {
                throw new InternalError("Duplicate field " + this.fields[i].getName() + " in class " + cl.getName());
            }
            ++i;
        }
        this.calculateOffsets();
    }

    private long getClassUID(Class cl) {
        long result = 0L;
        Long cache = (Long)uidCache.get(cl);
        if (cache != null) {
            result = cache;
        } else {
            if (Enum.class.isAssignableFrom(cl) || Proxy.isProxyClass(cl)) {
                return 0L;
            }
            try {
                result = this.getClassUIDFromField(cl);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                try {
                    result = this.calculateClassUID(cl);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("The SHA algorithm was not found to use in computing the Serial Version UID for class " + cl.getName(), e);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            if (ObjectStreamClass.loadedByBootOrApplicationClassLoader(cl)) {
                uidCache.put(cl, result);
            }
        }
        return result;
    }

    long getClassUIDFromField(Class cl) throws NoSuchFieldException {
        long result;
        try {
            Field suid = cl.getDeclaredField("serialVersionUID");
            SetAccessibleAction setAccessible = new SetAccessibleAction(suid);
            AccessController.doPrivileged(setAccessible);
            int modifiers = suid.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || suid.getType() != Long.TYPE) {
                throw new NoSuchFieldException();
            }
            result = suid.getLong(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchFieldException();
        }
        return result;
    }

    long calculateClassUID(Class cl) throws NoSuchAlgorithmException, IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Gnu gnuProvider = new Gnu();
            Security.addProvider(gnuProvider);
            md = MessageDigest.getInstance("SHA");
        }
        DigestOutputStream digest_out = new DigestOutputStream(nullOutputStream, md);
        DataOutputStream data_out = new DataOutputStream(digest_out);
        data_out.writeUTF(cl.getName());
        int modifiers = cl.getModifiers();
        data_out.writeInt(modifiers &= 0x611);
        if (!cl.isArray()) {
            Class<?>[] interfaces = cl.getInterfaces();
            Arrays.sort(interfaces, interfaceComparator);
            int i = 0;
            while (i < interfaces.length) {
                data_out.writeUTF(interfaces[i].getName());
                ++i;
            }
        }
        Field[] fields = cl.getDeclaredFields();
        Arrays.sort(fields, memberComparator);
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            modifiers = field.getModifiers();
            if (!Modifier.isPrivate(modifiers) || !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers)) {
                data_out.writeUTF(field.getName());
                data_out.writeInt(modifiers);
                data_out.writeUTF(TypeSignature.getEncodingOfClass(field.getType()));
            }
            ++i;
        }
        if (VMObjectStreamClass.hasClassInitializer(cl)) {
            data_out.writeUTF("<clinit>");
            data_out.writeInt(8);
            data_out.writeUTF("()V");
        }
        Constructor<?>[] constructors = cl.getDeclaredConstructors();
        Arrays.sort(constructors, memberComparator);
        int i2 = 0;
        while (i2 < constructors.length) {
            Constructor<?> constructor = constructors[i2];
            modifiers = constructor.getModifiers();
            if (!Modifier.isPrivate(modifiers)) {
                data_out.writeUTF("<init>");
                data_out.writeInt(modifiers);
                data_out.writeUTF(TypeSignature.getEncodingOfConstructor(constructor).replace('/', '.'));
            }
            ++i2;
        }
        Method[] methods = cl.getDeclaredMethods();
        Arrays.sort(methods, memberComparator);
        int i3 = 0;
        while (i3 < methods.length) {
            Method method = methods[i3];
            modifiers = method.getModifiers();
            if (!Modifier.isPrivate(modifiers)) {
                data_out.writeUTF(method.getName());
                data_out.writeInt(modifiers);
                data_out.writeUTF(TypeSignature.getEncodingOfMethod(method).replace('/', '.'));
            }
            ++i3;
        }
        data_out.close();
        byte[] sha = md.digest();
        long result = 0L;
        int len = sha.length < 8 ? sha.length : 8;
        int i4 = 0;
        while (i4 < len) {
            result += (long)(sha[i4] & 0xFF) << 8 * i4;
            ++i4;
        }
        return result;
    }

    private ObjectStreamField[] getSerialPersistentFields(Class clazz) throws NoSuchFieldException, IllegalAccessException {
        ObjectStreamField[] fieldsArray = null;
        Field f = clazz.getDeclaredField("serialPersistentFields");
        f.setAccessible(true);
        int modifiers = f.getModifiers();
        if (!(Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && Modifier.isPrivate(modifiers))) {
            return null;
        }
        ObjectStreamField[] o = (ObjectStreamField[])f.get(null);
        if (o == null) {
            return null;
        }
        fieldsArray = new ObjectStreamField[o.length];
        System.arraycopy(o, 0, fieldsArray, 0, o.length);
        return fieldsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Externalizable newInstance() throws InvalidClassException {
        ObjectStreamClass objectStreamClass = this;
        synchronized (objectStreamClass) {
            if (this.constructor == null) {
                try {
                    final Constructor<?> c = this.clazz.getConstructor(new Class[0]);
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            c.setAccessible(true);
                            return null;
                        }
                    });
                    this.constructor = c;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InvalidClassException(this.clazz.getName(), "No public zero-argument constructor");
                }
            }
        }
        try {
            return (Externalizable)this.constructor.newInstance(new Object[0]);
        }
        catch (Exception x) {
            throw (InvalidClassException)new InvalidClassException(this.clazz.getName(), "Unable to instantiate").initCause(x);
        }
    }

    private static final class InterfaceComparator
    implements Comparator {
        private InterfaceComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Class)o1).getName().compareTo(((Class)o2).getName());
        }
    }

    private static final class MemberComparator
    implements Comparator {
        private MemberComparator() {
        }

        public int compare(Object o1, Object o2) {
            Member m1 = (Member)o1;
            Member m2 = (Member)o2;
            int comp = m1.getName().compareTo(m2.getName());
            if (comp == 0) {
                return TypeSignature.getEncodingOfMember(m1).compareTo(TypeSignature.getEncodingOfMember(m2));
            }
            return comp;
        }
    }
}

