/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class DefaultKeyboardFocusManager
extends KeyboardFocusManager {
    private AWTKeyStroke waitForKeyStroke = null;
    private SortedSet delayRequests = new TreeSet();

    public boolean dispatchEvent(AWTEvent e) {
        if (e instanceof WindowEvent) {
            Window target = (Window)e.getSource();
            if (e.id == 205) {
                this.setGlobalActiveWindow(target);
            } else if (e.id == 207) {
                this.setGlobalFocusedWindow(target);
                FocusTraversalPolicy p = target.getFocusTraversalPolicy();
                Component toFocus = p.getInitialComponent(target);
                if (toFocus != null) {
                    toFocus.requestFocusInWindow();
                }
            } else if (e.id != 208 && e.id != 206) {
                return false;
            }
            this.redispatchEvent(target, e);
            return true;
        }
        if (e instanceof FocusEvent) {
            FocusEvent fe = (FocusEvent)e;
            fe.getComponent();
            if (e.id == 1004) {
                this.handleFocusGained(fe);
            } else if (e.id == 1005) {
                this.handleFocusLost(fe);
            }
            return true;
        }
        if (e instanceof KeyEvent) {
            for (KeyEventDispatcher dispatcher : this.getKeyEventDispatchers()) {
                if (!dispatcher.dispatchKeyEvent((KeyEvent)e)) continue;
                return true;
            }
            Component focusOwner = this.getGlobalPermanentFocusOwner();
            if (focusOwner != null) {
                this.processKeyEvent(focusOwner, (KeyEvent)e);
            }
            if (e.isConsumed()) {
                return true;
            }
            if (this.enqueueKeyEvent((KeyEvent)e)) {
                return true;
            }
            return this.dispatchKeyEvent((KeyEvent)e);
        }
        return false;
    }

    private boolean handleFocusGained(FocusEvent fe) {
        Component target = fe.getComponent();
        Component oldFocusOwner = this.getGlobalFocusOwner();
        if (oldFocusOwner != null && oldFocusOwner != target) {
            FocusEvent lost = new FocusEvent(oldFocusOwner, 1005, fe.isTemporary(), target);
            oldFocusOwner.dispatchEvent(lost);
        }
        this.setGlobalFocusOwner(target);
        if (target != this.getGlobalFocusOwner()) {
            this.dequeueKeyEvents(-1L, target);
        } else if (!fe.isTemporary()) {
            this.setGlobalPermanentFocusOwner(target);
            if (target != this.getGlobalPermanentFocusOwner()) {
                this.dequeueKeyEvents(-1L, target);
            } else {
                this.redispatchEvent(target, fe);
            }
        }
        return true;
    }

    private boolean handleFocusLost(FocusEvent fe) {
        Component currentFocus = this.getGlobalFocusOwner();
        if (currentFocus != fe.getOppositeComponent()) {
            this.setGlobalFocusOwner(null);
            if (this.getGlobalFocusOwner() == null && !fe.isTemporary()) {
                this.setGlobalPermanentFocusOwner(null);
                if (this.getGlobalPermanentFocusOwner() == null) {
                    fe.setSource(currentFocus);
                    this.redispatchEvent(currentFocus, fe);
                }
            }
        }
        return true;
    }

    private boolean enqueueKeyEvent(KeyEvent e) {
        Iterator i = this.delayRequests.iterator();
        boolean oneEnqueued = false;
        while (i.hasNext()) {
            EventDelayRequest request = (EventDelayRequest)i.next();
            if (e.getWhen() <= request.timestamp) continue;
            request.enqueueEvent(e);
            oneEnqueued = true;
        }
        return oneEnqueued;
    }

    public boolean dispatchKeyEvent(KeyEvent e) {
        Component focusOwner = this.getFocusOwner();
        if (focusOwner == null) {
            focusOwner = this.getFocusedWindow();
        }
        if (focusOwner != null) {
            this.redispatchEvent(focusOwner, e);
        }
        for (KeyEventPostProcessor processor : this.getKeyEventPostProcessors()) {
            if (!processor.postProcessKeyEvent(e)) continue;
            return true;
        }
        if (this.postProcessKeyEvent(e)) {
            return true;
        }
        return true;
    }

    public boolean postProcessKeyEvent(KeyEvent e) {
        MenuBar menubar;
        Window focusedWindow;
        int modifiers = e.getModifiersEx();
        if (e.getID() == 401 && (modifiers & 0x80) != 0 && (focusedWindow = this.getGlobalFocusedWindow()) instanceof Frame && (menubar = ((Frame)focusedWindow).getMenuBar()) != null) {
            int numMenus = menubar.getMenuCount();
            int i = 0;
            while (i < numMenus) {
                Menu menu = menubar.getMenu(i);
                int numItems = menu.getItemCount();
                int j = 0;
                while (j < numItems) {
                    MenuItem item = menu.getItem(j);
                    MenuShortcut shortcut = item.getShortcut();
                    if (item.isEnabled() && shortcut != null && shortcut.getKey() == e.getKeyCode() && (shortcut.usesShiftModifier() && (modifiers & 0x40) != 0 || !shortcut.usesShiftModifier() && (modifiers & 0x40) == 0)) {
                        item.dispatchEvent(new ActionEvent(item, 1001, item.getActionCommand(), modifiers));
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    public void processKeyEvent(Component comp, KeyEvent e) {
        AWTKeyStroke eventKeystroke = AWTKeyStroke.getAWTKeyStrokeForEvent(e);
        AWTKeyStroke oppositeKeystroke = AWTKeyStroke.getAWTKeyStroke(e.getKeyCode(), e.getModifiersEx(), e.id != 402);
        if (this.waitForKeyStroke != null) {
            if (eventKeystroke.equals(this.waitForKeyStroke)) {
                this.waitForKeyStroke = null;
            }
            e.consume();
            return;
        }
        Set<AWTKeyStroke> forwardKeystrokes = comp.getFocusTraversalKeys(0);
        Set<AWTKeyStroke> backwardKeystrokes = comp.getFocusTraversalKeys(1);
        Set<AWTKeyStroke> upKeystrokes = comp.getFocusTraversalKeys(2);
        Set<AWTKeyStroke> downKeystrokes = null;
        if (comp instanceof Container) {
            downKeystrokes = comp.getFocusTraversalKeys(3);
        }
        if (forwardKeystrokes.contains(eventKeystroke)) {
            this.waitForKeyStroke = oppositeKeystroke;
            this.focusNextComponent(comp);
            e.consume();
        } else if (backwardKeystrokes.contains(eventKeystroke)) {
            this.waitForKeyStroke = oppositeKeystroke;
            this.focusPreviousComponent(comp);
            e.consume();
        } else if (upKeystrokes.contains(eventKeystroke)) {
            this.waitForKeyStroke = oppositeKeystroke;
            this.upFocusCycle(comp);
            e.consume();
        } else if (comp instanceof Container && downKeystrokes.contains(eventKeystroke)) {
            this.waitForKeyStroke = oppositeKeystroke;
            this.downFocusCycle((Container)comp);
            e.consume();
        }
    }

    protected void enqueueKeyEvents(long after, Component untilFocused) {
        this.delayRequests.add(new EventDelayRequest(after, untilFocused));
    }

    protected void dequeueKeyEvents(long after, Component untilFocused) {
        if (after < 0L) {
            int size = this.delayRequests.size();
            if (size > 0) {
                this.delayRequests.remove(this.delayRequests.first());
            }
        } else {
            EventDelayRequest template = new EventDelayRequest(after, untilFocused);
            if (this.delayRequests.contains(template)) {
                EventDelayRequest actual = this.delayRequests.tailSet(template).first();
                this.delayRequests.remove(actual);
                actual.dispatchEvents();
            }
        }
    }

    protected void discardKeyEvents(Component comp) {
        for (EventDelayRequest request : this.delayRequests) {
            if (request.focusedComp != comp && (!(comp instanceof Container) || !((Container)comp).isAncestorOf(request.focusedComp))) continue;
            request.discardEvents();
        }
    }

    public void focusPreviousComponent(Component comp) {
        if (comp != null) {
            comp.transferFocusBackward();
        }
    }

    public void focusNextComponent(Component comp) {
        if (comp != null) {
            comp.transferFocus();
        }
    }

    public void upFocusCycle(Component comp) {
        if (comp != null) {
            comp.transferFocusUpCycle();
        }
    }

    public void downFocusCycle(Container cont) {
        if (cont != null) {
            cont.transferFocusDownCycle();
        }
    }

    private class EventDelayRequest
    implements Comparable {
        private LinkedList enqueuedKeyEvents = new LinkedList();
        public long timestamp;
        public Component focusedComp;

        public EventDelayRequest(long timestamp, Component focusedComp) {
            this.timestamp = timestamp;
            this.focusedComp = focusedComp;
        }

        public int compareTo(Object o) {
            if (!(o instanceof EventDelayRequest)) {
                throw new ClassCastException();
            }
            EventDelayRequest request = (EventDelayRequest)o;
            if (request.timestamp < this.timestamp) {
                return -1;
            }
            if (request.timestamp == this.timestamp) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (!(o instanceof EventDelayRequest) || o == null) {
                return false;
            }
            EventDelayRequest request = (EventDelayRequest)o;
            return request.timestamp == this.timestamp && request.focusedComp == this.focusedComp;
        }

        public void enqueueEvent(KeyEvent e) {
            KeyEvent last = (KeyEvent)this.enqueuedKeyEvents.getLast();
            if (last != null && e.getWhen() < last.getWhen()) {
                throw new RuntimeException("KeyEvents enqueued out-of-order");
            }
            if (e.getWhen() <= this.timestamp) {
                throw new RuntimeException("KeyEvents enqueued before starting timestamp");
            }
            this.enqueuedKeyEvents.add(e);
        }

        public void dispatchEvents() {
            int size = this.enqueuedKeyEvents.size();
            int i = 0;
            while (i < size) {
                KeyEvent e = (KeyEvent)this.enqueuedKeyEvents.remove(0);
                DefaultKeyboardFocusManager.this.dispatchKeyEvent(e);
                ++i;
            }
        }

        public void discardEvents() {
            this.enqueuedKeyEvents.clear();
        }
    }
}

