/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class GYearType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    GYearType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "gYear"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        int state = 0;
        int start = 0;
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c == '-' && i == 0) {
                ++start;
            } else if (c < '0' || c > '9') {
                throw new DatatypeException(i, "invalid GYear value");
            }
            ++i;
        }
        switch (state) {
            case 0: {
                String year = value.substring(start, len);
                if (year.length() >= 4 && Integer.parseInt(year) != 0) break;
                throw new DatatypeException("invalid GYear value");
            }
            default: {
                throw new DatatypeException("invalid GYear value");
            }
        }
    }

    public Object createValue(String literal, ValidationContext context) {
        try {
            GYear ret = new GYear();
            ret.year = Integer.parseInt(literal);
            return ret;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static class GYear
    implements Comparable {
        int year;

        GYear() {
        }

        public int hashCode() {
            return this.year;
        }

        public boolean equals(Object other) {
            if (other instanceof GYear) {
                return ((GYear)other).year == this.year;
            }
            return false;
        }

        public int compareTo(Object other) {
            if (other instanceof GYear) {
                GYear gy = (GYear)other;
                if (gy.year == this.year) {
                    return 0;
                }
                return this.year < gy.year ? -1 : 1;
            }
            return 0;
        }
    }
}

