/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import gnu.xml.util.Resolver;
import gnu.xml.util.XMLWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class CallFilter
implements EventConsumer {
    private Requestor req;
    private EventConsumer next;
    private URL target;
    private URLConnection conn;
    private ErrorHandler errHandler;

    public CallFilter(String uri, EventConsumer next) throws IOException {
        this.next = next;
        this.req = new Requestor();
        this.setCallTarget(uri);
    }

    public final void setCallTarget(String uri) throws IOException {
        this.target = new URL(uri);
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.req.setErrorHandler(handler);
    }

    public final String getCallTarget() {
        return this.target.toString();
    }

    public final ContentHandler getContentHandler() {
        return this.req;
    }

    public final DTDHandler getDTDHandler() {
        return this.req;
    }

    public final Object getProperty(String id) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(id)) {
            return this.req;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(id)) {
            return this.req;
        }
        throw new SAXNotRecognizedException(id);
    }

    ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    final class Requestor
    extends XMLWriter {
        Requestor() {
            super((Writer)null);
        }

        public synchronized void startDocument() throws SAXException {
            try {
                if (CallFilter.this.conn != null) {
                    throw new IllegalStateException("call is being made");
                }
                CallFilter.this.conn = CallFilter.this.target.openConnection();
                CallFilter.this.conn.setDoOutput(true);
                CallFilter.this.conn.setRequestProperty("Content-Type", "application/xml;charset=UTF-8");
                this.setWriter(new OutputStreamWriter(CallFilter.this.conn.getOutputStream(), "UTF8"), "UTF-8");
            }
            catch (IOException e) {
                this.fatal("can't write (POST) to URI: " + CallFilter.this.target, e);
            }
            super.startDocument();
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            try {
                InputSource source = new InputSource(CallFilter.this.conn.getInputStream());
                String encoding = Resolver.getEncoding(CallFilter.this.conn.getContentType());
                if (encoding != null) {
                    source.setEncoding(encoding);
                }
                XMLReader producer = XMLReaderFactory.createXMLReader();
                producer.setErrorHandler(CallFilter.this.getErrorHandler());
                EventFilter.bind(producer, CallFilter.this.next);
                producer.parse(source);
                CallFilter.this.conn = null;
            }
            catch (IOException e) {
                this.fatal("I/O Exception reading response, " + e.getMessage(), e);
            }
        }
    }
}

