/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser.support;

import gnu.java.lang.CPStringBuilder;
import gnu.javax.swing.text.html.parser.HTML_401F;
import gnu.javax.swing.text.html.parser.htmlAttributeSet;
import gnu.javax.swing.text.html.parser.htmlValidator;
import gnu.javax.swing.text.html.parser.support.low.ParseException;
import gnu.javax.swing.text.html.parser.support.low.ReaderTokenizer;
import gnu.javax.swing.text.html.parser.support.low.Token;
import gnu.javax.swing.text.html.parser.support.low.node;
import gnu.javax.swing.text.html.parser.support.low.pattern;
import gnu.javax.swing.text.html.parser.support.parameterDefaulter;
import gnu.javax.swing.text.html.parser.support.textPreProcessor;
import java.io.IOException;
import java.io.Reader;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.parser.AttributeList;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.DTDConstants;
import javax.swing.text.html.parser.Element;
import javax.swing.text.html.parser.Entity;
import javax.swing.text.html.parser.TagElement;

public class Parser
extends ReaderTokenizer
implements DTDConstants {
    public Token hTag = new Token();
    protected DTD dtd;
    protected boolean strict;
    protected int preformatted = 0;
    private Set documentTags = new TreeSet(new Comparator(){

        public int compare(Object a, Object b) {
            return ((String)a).compareToIgnoreCase((String)b);
        }
    });
    private final StringBuffer buffer = new StringBuffer();
    private final StringBuffer title = new StringBuffer();
    private Token t;
    private boolean titleHandled;
    private boolean titleOpen;
    htmlAttributeSet attributes = htmlAttributeSet.EMPTY_HTML_ATTRIBUTE_SET;
    private htmlValidator validator;
    private parameterDefaulter defaulter;
    private textPreProcessor textProcessor = new textPreProcessor();

    public Parser(DTD a_dtd) {
        this.dtd = a_dtd == null ? HTML_401F.getInstance() : a_dtd;
        this.defaulter = new parameterDefaulter(this.dtd);
        this.validator = new htmlValidator(this.dtd){

            protected void s_error(String msg) {
                Parser.this.error(msg);
            }

            protected void handleSupposedEndTag(Element tElement) {
                TagElement tag = Parser.this.makeTag(tElement, true);
                Parser.this._handleEndTag_remaining(tag);
            }

            protected void handleSupposedStartTag(Element tElement) {
                TagElement tag = Parser.this.makeTag(tElement, true);
                htmlAttributeSet were = Parser.this.attributes;
                Parser.this.attributes = htmlAttributeSet.EMPTY_HTML_ATTRIBUTE_SET;
                Parser.this._handleStartTag(tag);
                Parser.this.attributes = were;
            }
        };
    }

    public SimpleAttributeSet getAttributes() {
        return new SimpleAttributeSet(this.attributes);
    }

    public void error(String msg) {
        this.error(msg, this.getTokenAhead());
    }

    public void error(String msg, Token atToken) {
        if (atToken != null) {
            this.handleError(atToken.where.beginLine, String.valueOf(msg) + ": line " + atToken.where.beginLine + ", absolute pos " + atToken.where.startPosition);
        } else {
            this.handleError(0, msg);
        }
    }

    public void error(String msg, String invalid) {
        this.error(String.valueOf(msg) + ": '" + invalid + "'");
    }

    public void error(String parm1, String parm2, String parm3) {
        this.error(String.valueOf(parm1) + " " + parm2 + " " + parm3);
    }

    public void error(String parm1, String parm2, String parm3, String parm4) {
        this.error(String.valueOf(parm1) + " " + parm2 + " " + parm3 + " " + parm4);
    }

    public void flushAttributes() {
    }

    public synchronized void parse(Reader reader) throws IOException {
        block2: {
            this.reset(reader);
            this.restart();
            try {
                this.parseDocument();
                this.validator.closeAll();
            }
            catch (ParseException ex) {
                if (ex == null) break block2;
                this.error("Unable to continue parsing the document", ex.getMessage());
                Throwable cause = ex.getCause();
                if (!(cause instanceof IOException)) break block2;
                throw (IOException)cause;
            }
        }
    }

    public String parseDTDMarkup() throws IOException {
        return null;
    }

    public boolean parseMarkupDeclarations(StringBuffer strBuff) throws IOException {
        return false;
    }

    protected int getCurrentLine() {
        return this.hTag.where.beginLine;
    }

    protected void CDATA(boolean clearBuffer) throws ParseException {
        Token start = this.hTag = this.getTokenAhead();
        if (clearBuffer) {
            this.buffer.setLength(0);
        }
        if (start.kind == 3) {
            return;
        }
        while (true) {
            this.t = this.getTokenAhead();
            if (this.t.kind == 3) {
                this.error("unexpected eof", this.t);
                break;
            }
            if (this.t.kind == 60) break;
            if (this.t.kind == 1004) {
                this.resolveAndAppendEntity(this.t);
                this.getNextToken();
                continue;
            }
            this.append(this.t);
            this.getNextToken();
        }
        this.hTag = new Token(start, this.getTokenAhead(0));
        if (this.buffer.length() != 0) {
            this._handleText();
        }
    }

    protected void Comment() throws ParseException {
        Token last;
        this.buffer.setLength(0);
        Token start = this.hTag = this.mustBe(60);
        this.optional(1003);
        this.mustBe(33);
        this.optional(1003);
        this.mustBe(1000);
        while (true) {
            Token t = this.getTokenAhead();
            if (t.kind == 3) {
                this.handleEOFInComment();
                last = t;
                break;
            }
            if (COMMENT_END.matches(this)) {
                this.mustBe(1000);
                this.optional(1003);
                last = this.mustBe(62);
                break;
            }
            if (COMMENT_TRIPLEDASH_END.matches(this)) {
                this.mustBe(1000);
                t = this.mustBe(1005);
                if (t.getImage().equals("-")) {
                    this.append(t);
                    last = this.mustBe(62);
                    break;
                }
                this.buffer.append("--");
                this.append(t);
                t = this.getTokenAhead();
            } else {
                if (t.getImage().endsWith("--") && (this.getTokenAhead((int)1).kind == 62 || this.getTokenAhead((int)1).kind == 1003 && this.getTokenAhead((int)2).kind == 62)) {
                    this.buffer.append(t.getImage().substring(0, t.getImage().length() - 2));
                    last = this.mustBe(t.kind);
                    break;
                }
                this.append(t);
            }
            this.mustBe(t.kind);
        }
        this.hTag = new Token(start, last);
        this.optional(1003);
        this.handleComment();
    }

    protected void Script() throws ParseException {
        Token start = this.hTag = this.mustBe(60);
        this.optional(1003);
        Token name = this.mustBe(1002);
        this.optional(1003);
        this.restOfTag(false, name, start);
        this.buffer.setLength(0);
        while (!SCRIPT_CLOSE.matches(this)) {
            this.append(this.getNextToken());
        }
        this.consume(SCRIPT_CLOSE);
        this._handleText();
        this.endTag(false);
        this._handleEndTag(this.makeTagElement(name.getImage(), false));
    }

    protected void Sgml() throws ParseException {
        if (COMMENT_OPEN.matches(this)) {
            this.Comment();
        } else {
            Token start = this.hTag = this.mustBe(60);
            this.optional(1003);
            this.mustBe(33);
            this.buffer.setLength(0);
            while (true) {
                this.t = this.getNextToken();
                if (this.t.kind == 1004) {
                    this.resolveAndAppendEntity(this.t);
                    continue;
                }
                if (this.t.kind == 3) {
                    this.error("unexpected eof", this.t);
                    break;
                }
                if (this.t.kind == 62) break;
                this.append(this.t);
            }
            try {
                this.parseMarkupDeclarations(this.buffer);
            }
            catch (IOException iOException) {
                this.error("Unable to parse SGML insertion: '" + this.buffer + "'", new Token(start, this.t));
            }
        }
        this.optional(1003);
    }

    protected void Style() throws ParseException {
        Token start = this.hTag = this.mustBe(60);
        this.optional(1003);
        Token name = this.mustBe(1001);
        this.optional(1003);
        this.restOfTag(false, name, start);
        this.buffer.setLength(0);
        while (!STYLE_CLOSE.matches(this)) {
            this.append(this.getNextToken());
        }
        this.consume(STYLE_CLOSE);
        this._handleText();
        this.endTag(false);
        this._handleEndTag(this.makeTagElement(name.getImage(), false));
    }

    protected void Tag() throws ParseException {
        this.mark(true);
        boolean closing = false;
        Token start = this.hTag = this.mustBe(60);
        this.optional(1003);
        Token name = this.getNextToken();
        this.optional(1003);
        if (name.kind == 47) {
            closing = true;
            name = this.getNextToken();
        }
        this.restOfTag(closing, name, start);
    }

    protected void _handleText() {
        char[] text = this.preformatted > 0 ? this.textProcessor.preprocessPreformatted(this.buffer) : this.textProcessor.preprocess(this.buffer);
        if (!(text == null || text.length <= 0 || text.length <= 1 && text[0] == ' ' && TAG_CLOSE.matches(this))) {
            TagElement pcdata = new TagElement(this.dtd.getElement("#pcdata"));
            this.attributes = htmlAttributeSet.EMPTY_HTML_ATTRIBUTE_SET;
            this._handleEmptyTag(pcdata);
            this.handleText(text);
            if (this.titleOpen) {
                this.title.append(text);
            }
        }
    }

    protected final void append(Token t) {
        if (t.kind != 3) {
            t.appendTo(this.buffer);
        }
    }

    protected final void consume(pattern p) {
        int i = 0;
        while (i < p.nodes.length) {
            node n = p.nodes[i];
            if (n.optional) {
                this.optional(n.kind);
            } else {
                this.mustBe(n.kind);
            }
            ++i;
        }
    }

    protected void endTag(boolean omitted) {
    }

    protected void handleComment(char[] comment) {
    }

    protected void handleEOFInComment() {
        this.error("Unclosed comment");
    }

    protected void handleEmptyTag(TagElement tag) throws ChangedCharSetException {
    }

    protected void handleEndTag(TagElement tag) {
    }

    protected void handleError(int line, String message) {
    }

    protected void handleStartTag(TagElement tag) {
    }

    protected void handleText(char[] text) {
    }

    protected void handleTitle(char[] title) {
    }

    protected TagElement makeTag(Element element) {
        return this.makeTag(element, false);
    }

    protected TagElement makeTag(Element element, boolean isSupposed) {
        return new TagElement(element, isSupposed);
    }

    protected void markFirstTime(Element element) {
    }

    protected Token mustBe(int kind) {
        if (this.getTokenAhead().kind == kind) {
            return this.getNextToken();
        }
        String ei = "";
        if (kind < 1000) {
            ei = " ('" + (char)kind + "') ";
        }
        throw new AssertionError((Object)("The token of kind " + kind + ei + " MUST be here,"));
    }

    protected void noValueAttribute(String element, String attribute) {
        Vector<?> values;
        AttributeList attr;
        String value = "#DEFAULT";
        Element e = this.dtd.elementHash.get(element.toLowerCase());
        if (e != null && (attr = e.getAttribute(attribute)) != null && (values = attr.values) != null && values.size() == 1) {
            value = values.get(0);
        }
        this.attributes.addAttribute(attribute, value);
    }

    protected Token optional(int kind) {
        if (this.getTokenAhead().kind == kind) {
            return this.getNextToken();
        }
        return null;
    }

    protected void parseDocument() throws ParseException {
        this.optional(1003);
        while (this.getTokenAhead().kind != 3) {
            this.advanced = false;
            if (TAG.matches(this)) {
                this.Tag();
            } else if (COMMENT_OPEN.matches(this)) {
                this.Comment();
            } else if (STYLE_OPEN.matches(this)) {
                this.Style();
            } else if (SCRIPT_OPEN.matches(this)) {
                this.Script();
            } else if (SGML.matches(this)) {
                this.Sgml();
            } else {
                this.CDATA(true);
            }
            if (this.advanced) continue;
            Token wrong = this.getNextToken();
            this.error("unexpected '" + wrong.getImage() + "'", wrong);
            this.buffer.setLength(0);
            this.buffer.append(wrong.getImage());
            this._handleText();
        }
    }

    protected void readAttributes(String element) {
        this.attributes = new htmlAttributeSet();
        this.optional(1003);
        block6: while (this.getTokenAhead().kind == 1005) {
            Token name = this.getNextToken();
            this.optional(1003);
            Token next = this.getTokenAhead();
            if (next.kind == 61) {
                String attrValue;
                this.mustBe(61);
                this.optional(1003);
                next = this.getNextToken();
                switch (next.kind) {
                    case 34: {
                        this.buffer.setLength(0);
                        this.readTillTokenE(34);
                        attrValue = this.buffer.toString();
                        break;
                    }
                    case 39: {
                        this.buffer.setLength(0);
                        this.readTillTokenE(39);
                        attrValue = this.buffer.toString();
                        break;
                    }
                    case 1005: {
                        CPStringBuilder image;
                        Token value = next;
                        this.optional(1003);
                        next = this.getTokenAhead();
                        if (bQUOTING.get(next.kind)) {
                            this.hTag = next;
                            this.error("The value without opening quote is closed with '" + next.getImage() + "'");
                            attrValue = value.getImage();
                            break;
                        }
                        if (next.kind == 47 || next.kind == 1999) {
                            image = new CPStringBuilder(value.getImage());
                            while (next.kind == 1005 || next.kind == 47 || next.kind == 1999) {
                                image.append(this.getNextToken().getImage());
                                next = this.getTokenAhead();
                            }
                            attrValue = image.toString();
                            break;
                        }
                        attrValue = value.getImage();
                        break;
                    }
                    case 47: {
                        CPStringBuilder image;
                        Token value = next;
                        this.optional(1003);
                        next = this.getTokenAhead();
                        if (bQUOTING.get(next.kind)) {
                            this.hTag = next;
                            this.error("The value without opening quote is closed with '" + next.getImage() + "'");
                            attrValue = value.getImage();
                            break;
                        }
                        if (next.kind == 1005 || next.kind == 47) {
                            image = new CPStringBuilder(value.getImage());
                            while (next.kind == 1005 || next.kind == 47) {
                                image.append(this.getNextToken().getImage());
                                next = this.getTokenAhead();
                            }
                            attrValue = image.toString();
                            break;
                        }
                        attrValue = value.getImage();
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                this.attributes.addAttribute(name.getImage(), attrValue);
                this.optional(1003);
                continue;
            }
            this.noValueAttribute(element, name.getImage());
        }
    }

    protected String resolveNamedEntity(String a_tag) {
        if (!a_tag.startsWith("&")) {
            throw new AssertionError((Object)("Named entity " + a_tag + " must start witn '&'."));
        }
        String tag = a_tag.substring(1);
        try {
            Entity entity = this.dtd.getEntity(tag);
            if (entity != null) {
                return entity.getString();
            }
            entity = this.dtd.getEntity(tag.toLowerCase());
            if (entity != null) {
                this.error("The name of this entity should be in lowercase", a_tag);
                return entity.getString();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        this.error("Unknown named entity", a_tag);
        return a_tag;
    }

    protected char resolveNumericEntity(String a_tag) {
        if (!a_tag.startsWith("&#")) {
            throw new AssertionError((Object)("Numeric entity " + a_tag + " must start witn '&#'."));
        }
        String tag = a_tag.substring(2);
        try {
            char cx = tag.charAt(0);
            if (cx == 'x' || cx == 'X') {
                return (char)Integer.parseInt(tag.substring(1), 16);
            }
            return (char)Integer.parseInt(tag);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        this.error("Invalid numeric entity", a_tag);
        return '?';
    }

    protected void restart() {
        this.documentTags.clear();
        this.titleHandled = false;
        this.titleOpen = false;
        this.buffer.setLength(0);
        this.title.setLength(0);
        this.validator.restart();
    }

    protected void startTag(TagElement tag) throws ChangedCharSetException {
    }

    private void _handleCompleteElement(TagElement tag) {
        this._handleStartTag(tag);
        HTML.Tag h = tag.getHTMLTag();
        if (h == HTML.Tag.SCRIPT || h == HTML.Tag.STYLE) {
            boolean tmp = this.titleOpen;
            this.titleOpen = false;
            this._handleText();
            this.titleOpen = tmp;
        } else {
            this._handleText();
        }
        this._handleEndTag(tag);
    }

    private void _handleEmptyTag(TagElement tag) {
        try {
            this.validator.validateTag(tag, this.attributes);
            this.handleEmptyTag(tag);
            HTML.Tag h = tag.getHTMLTag();
            if (this.isBlock(h)) {
                this.optional(1003);
            }
        }
        catch (ChangedCharSetException ex) {
            this.error("Changed charset exception:", ex.getMessage());
        }
    }

    private void _handleEndTag(TagElement tag) {
        if (this.validator.closeTag(tag)) {
            this._handleEndTag_remaining(tag);
        }
    }

    void _handleEndTag_remaining(TagElement tag) {
        HTML.Tag h = tag.getHTMLTag();
        this.handleEndTag(tag);
        this.endTag(tag.fictional());
        if (h.isPreformatted()) {
            --this.preformatted;
        }
        if (this.preformatted < 0) {
            this.preformatted = 0;
        }
        if (this.isBlock(h)) {
            this.optional(1003);
        }
        if (h == HTML.Tag.TITLE) {
            this.titleOpen = false;
            this.titleHandled = true;
            char[] a = new char[this.title.length()];
            this.title.getChars(0, a.length, a, 0);
            this.handleTitle(a);
        }
    }

    void _handleStartTag(TagElement tag) {
        this.validator.openTag(tag, this.attributes);
        this.startingTag(tag);
        this.handleStartTag(tag);
        HTML.Tag h = tag.getHTMLTag();
        if (this.isBlock(h)) {
            this.optional(1003);
        }
        if (h.isPreformatted()) {
            ++this.preformatted;
        }
        if (h == HTML.Tag.TITLE) {
            if (this.titleHandled) {
                this.error("Repetetive <TITLE> tag");
            }
            this.titleOpen = true;
            this.titleHandled = false;
        }
    }

    private void forciblyCloseTheTag() throws ParseException {
        int closeAt = 0;
        this.buffer.setLength(0);
        int i = 1;
        while (i < 100) {
            this.t = this.getTokenAhead(i - 1);
            if (this.t.kind == 3 || this.t.kind == 60) break;
            if (this.t.kind == 62) {
                closeAt = i;
                break;
            }
            ++i;
        }
        if (closeAt > 0) {
            this.buffer.append("Ignoring '");
            i = 1;
            while (i <= closeAt) {
                this.t = this.getNextToken();
                this.append(this.t);
                ++i;
            }
            this.buffer.append('\'');
            this.error(this.buffer.toString());
        }
    }

    private void handleComment() {
        char[] a = new char[this.buffer.length()];
        this.buffer.getChars(0, a.length, a, 0);
        this.handleComment(a);
    }

    private TagElement makeTagElement(String name, boolean isSupposed) {
        Element e = this.dtd.elementHash.get(name.toLowerCase());
        if (e == null) {
            this.error("Unknown tag <" + name + ">");
            e = this.dtd.getElement(name);
            e.name = name.toUpperCase();
            e.index = -1;
        }
        if (!this.documentTags.contains(e.name)) {
            this.markFirstTime(e);
            this.documentTags.add(e.name);
        }
        return this.makeTag(e, isSupposed);
    }

    private void readTillTokenE(int till) throws ParseException {
        this.buffer.setLength(0);
        block0: while (true) {
            this.t = this.getNextToken();
            if (this.t.kind == 1004) {
                this.resolveAndAppendEntity(this.t);
                continue;
            }
            if (this.t.kind == 3) {
                this.error("unexpected eof", this.t);
                break;
            }
            if (this.t.kind == till) break;
            if (this.t.kind == 1003) {
                String s = this.t.getImage();
                int i = 0;
                while (true) {
                    if (i >= s.length()) continue block0;
                    char c = s.charAt(i);
                    if (c == '\r') {
                        this.buffer.append(' ');
                    } else if (c != '\n') {
                        if (c == '\t') {
                            this.buffer.append(' ');
                        } else {
                            this.buffer.append(c);
                        }
                    }
                    ++i;
                }
            }
            this.append(this.t);
        }
    }

    private void resolveAndAppendEntity(Token entity) {
        switch (entity.category) {
            case 1: {
                this.buffer.append(this.resolveNamedEntity(entity.getImage()));
                break;
            }
            case 2: {
                this.buffer.append(this.resolveNumericEntity(entity.getImage()));
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid entity category " + entity.category));
            }
        }
    }

    private void restOfTag(boolean closing, Token name, Token start) throws ParseException {
        boolean end = false;
        this.optional(1003);
        this.readAttributes(name.getImage());
        this.optional(1003);
        Token next = this.getTokenAhead();
        if (next.kind == 62) {
            this.mustBe(62);
            end = true;
        }
        this.hTag = new Token(start, next);
        if (!end) {
            if (this.dtd.elementHash.get(name.getImage().toLowerCase()) == null && this.backupMode) {
                this.error("Errors in tag body and unknown tag name. Treating the tag as a text.");
                this.reset();
                this.hTag = this.mustBe(60);
                this.buffer.setLength(0);
                this.buffer.append(this.hTag.getImage());
                this.CDATA(false);
                return;
            }
            this.error("Forcibly closing invalid parameter list");
            this.forciblyCloseTheTag();
        }
        if (closing) {
            this.endTag(false);
            this._handleEndTag(this.makeTagElement(name.getImage(), false));
        } else {
            TagElement te = this.makeTagElement(name.getImage(), false);
            if (te.getElement().type == 17) {
                this._handleEmptyTag(te);
            } else {
                this.optional(1003);
                this._handleStartTag(te);
            }
        }
    }

    private void startingTag(TagElement tag) {
        try {
            this.startTag(tag);
        }
        catch (ChangedCharSetException changedCharSetException) {
            this.error("Invalid change of charset");
        }
    }

    private void ws_error() {
        this.error("Whitespace here is not permitted");
    }

    private boolean isBlock(HTML.Tag tag) {
        return tag.isBlock() || tag == HTML.Tag.STYLE || tag == HTML.Tag.FRAME;
    }
}

