/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.sampled.WAV;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public class WAVReader
extends AudioFileReader {
    private static long readUnsignedIntLE(DataInputStream is) throws IOException {
        byte[] buf = new byte[4];
        is.readFully(buf);
        return buf[0] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[2] & 0xFF) << 16 | (buf[3] & 0xFF) << 24;
    }

    private static short readUnsignedShortLE(DataInputStream is) throws IOException {
        byte[] buf = new byte[2];
        is.readFully(buf);
        return (short)(buf[0] & 0xFF | (buf[1] & 0xFF) << 8);
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(is);
            return audioFileFormat;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public AudioFileFormat getAudioFileFormat(InputStream in) throws UnsupportedAudioFileException, IOException {
        AudioFormat.Encoding encoding;
        DataInputStream din = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        if (din.readInt() != 1380533830) {
            throw new UnsupportedAudioFileException("Invalid WAV chunk header.");
        }
        WAVReader.readUnsignedIntLE(din);
        if (din.readInt() != 1463899717) {
            throw new UnsupportedAudioFileException("Invalid WAV chunk header.");
        }
        boolean foundFmt = false;
        boolean foundData = false;
        int compressionCode = 0;
        short numberChannels = 0;
        int bitsPerSample = 0;
        long sampleRate = 0L;
        long bytesPerSecond = 0L;
        long chunkLength = 0L;
        while (!foundData) {
            int chunkId = din.readInt();
            chunkLength = WAVReader.readUnsignedIntLE(din);
            switch (chunkId) {
                case 1718449184: {
                    foundFmt = true;
                    compressionCode = WAVReader.readUnsignedShortLE(din);
                    numberChannels = WAVReader.readUnsignedShortLE(din);
                    sampleRate = WAVReader.readUnsignedIntLE(din);
                    bytesPerSecond = WAVReader.readUnsignedIntLE(din);
                    WAVReader.readUnsignedShortLE(din);
                    bitsPerSample = WAVReader.readUnsignedShortLE(din);
                    din.skip(chunkLength - 16L);
                    break;
                }
                case 1717658484: {
                    din.skip(chunkLength);
                    break;
                }
                case 1684108385: {
                    if (!foundFmt) {
                        throw new UnsupportedAudioFileException("This implementation requires WAV fmt chunks precede data chunks.");
                    }
                    foundData = true;
                    break;
                }
                default: {
                    din.skip(chunkLength);
                }
            }
        }
        switch (compressionCode) {
            case 1: {
                if (bitsPerSample <= 8) {
                    encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                    break;
                }
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                break;
            }
            default: {
                throw new UnsupportedAudioFileException("Unrecognized WAV compression code: 0x" + Integer.toHexString(compressionCode));
            }
        }
        return new AudioFileFormat(AudioFileFormat.Type.WAVE, new AudioFormat(encoding, sampleRate, bitsPerSample, numberChannels, (bitsPerSample + 7) / 8 * numberChannels, bytesPerSecond, false), (int)chunkLength);
    }

    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream is = url.openStream();
        try {
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(is);
            return audioFileFormat;
        }
        finally {
            is.close();
        }
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(new FileInputStream(file));
    }

    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat aff = this.getAudioFileFormat(stream);
        return new AudioInputStream(stream, aff.getFormat(), aff.getFrameLength());
    }

    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(url.openStream());
    }
}

