/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.sampled.AU;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public class AUReader
extends AudioFileReader {
    public AudioFileFormat getAudioFileFormat(File file) throws IOException, UnsupportedAudioFileException {
        return this.getAudioFileFormat(new FileInputStream(file));
    }

    public AudioFileFormat getAudioFileFormat(InputStream stream) throws IOException, UnsupportedAudioFileException {
        if (!stream.markSupported()) {
            throw new IOException("Stream must support marking.");
        }
        stream.mark(25);
        AUHeader header = new AUHeader(stream);
        stream.reset();
        return header.getAudioFileFormat();
    }

    public AudioFileFormat getAudioFileFormat(URL url) throws IOException, UnsupportedAudioFileException {
        return this.getAudioFileFormat(new BufferedInputStream(url.openStream()));
    }

    public AudioInputStream getAudioInputStream(File file) throws IOException, UnsupportedAudioFileException {
        FileInputStream stream = new FileInputStream(file);
        long length = file.length();
        AUHeader header = new AUHeader(stream);
        if (header.headerSize > 24) {
            ((InputStream)stream).skip(header.headerSize - 24);
        }
        return new AudioInputStream(stream, header.getAudioFormat(), length -= (long)header.headerSize);
    }

    public AudioInputStream getAudioInputStream(InputStream stream) throws IOException, UnsupportedAudioFileException {
        AUHeader header = new AUHeader(stream);
        if (header.headerSize > 24) {
            stream.skip(header.headerSize - 24);
        }
        return new AudioInputStream(stream, header.getAudioFormat(), -1L);
    }

    public AudioInputStream getAudioInputStream(URL url) throws IOException, UnsupportedAudioFileException {
        return this.getAudioInputStream(new BufferedInputStream(url.openStream()));
    }

    public static class AUFormatType
    extends AudioFileFormat.Type {
        public AUFormatType() {
            super("AU", ".au");
        }
    }

    private static class AUHeader {
        private static final int MAGIC = 779316836;
        public static final int SIZE = 24;
        public static final int ULAW = 1;
        public static final int PCM8 = 2;
        public static final int PCM16 = 3;
        public static final int PCM24 = 4;
        public static final int PCM32 = 5;
        public static final int IEEE32 = 6;
        public static final int IEEE64 = 7;
        public static final int G721 = 23;
        public static final int G722 = 24;
        public static final int G723 = 25;
        public static final int G723_5BIT = 26;
        public static final int ALAW = 27;
        public int headerSize;
        public int fileSize;
        public int encoding;
        public int sampleRate;
        public int channels;
        public int sampleSizeInBits;

        public AUHeader(InputStream stream) throws IOException, UnsupportedAudioFileException {
            byte[] hdr = new byte[24];
            stream.read(hdr);
            ByteBuffer buf = ByteBuffer.wrap(hdr);
            if (buf.getInt() != 779316836) {
                throw new UnsupportedAudioFileException("Not an AU format audio file.");
            }
            this.headerSize = buf.getInt();
            this.fileSize = buf.getInt();
            this.encoding = buf.getInt();
            this.sampleRate = buf.getInt();
            this.channels = buf.getInt();
            switch (this.encoding) {
                case 1: 
                case 2: 
                case 27: {
                    this.sampleSizeInBits = 8;
                    break;
                }
                case 3: {
                    this.sampleSizeInBits = 16;
                    break;
                }
                case 4: {
                    this.sampleSizeInBits = 24;
                    break;
                }
                case 5: {
                    this.sampleSizeInBits = 32;
                    break;
                }
                default: {
                    throw new UnsupportedAudioFileException("Unsupported encoding.");
                }
            }
        }

        public AudioFormat getAudioFormat() {
            AudioFormat.Encoding encType = AudioFormat.Encoding.PCM_SIGNED;
            if (this.encoding == 1) {
                encType = AudioFormat.Encoding.ULAW;
            }
            if (this.encoding == 27) {
                encType = AudioFormat.Encoding.ALAW;
            }
            return new AudioFormat(encType, this.sampleRate, this.sampleSizeInBits, this.channels, (this.sampleSizeInBits >> 3) * this.channels, this.sampleRate, true);
        }

        public AudioFileFormat getAudioFileFormat() {
            return new AudioFileFormat(new AUFormatType(), this.getAudioFormat(), -1);
        }
    }
}

