/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.midi.alsa;

import gnu.javax.sound.midi.alsa.AlsaInputPortDevice;
import gnu.javax.sound.midi.alsa.AlsaMidiSequencerDevice;
import gnu.javax.sound.midi.alsa.AlsaOutputPortDevice;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.spi.MidiDeviceProvider;

public class AlsaMidiDeviceProvider
extends MidiDeviceProvider {
    private static AlsaInfo[] infos;

    static {
        AlsaMidiDeviceProvider.init_();
        AlsaInfo[] inputs = AlsaMidiDeviceProvider.getInputDeviceInfo_();
        AlsaInfo[] outputs = AlsaMidiDeviceProvider.getOutputDeviceInfo_();
        infos = new AlsaInfo[inputs.length + outputs.length + 1];
        AlsaMidiDeviceProvider.infos[0] = new AlsaSequencerInfo("/dev/snd/seq", "ALSA Sequencer");
        System.arraycopy(inputs, 0, infos, 1, inputs.length);
        System.arraycopy(outputs, 0, infos, 1 + inputs.length, outputs.length);
    }

    private static native AlsaInfo[] getInputDeviceInfo_();

    private static native AlsaInfo[] getOutputDeviceInfo_();

    private static native void init_();

    public MidiDevice.Info[] getDeviceInfo() {
        return infos;
    }

    public MidiDevice getDevice(MidiDevice.Info info) {
        int i = 0;
        while (i < infos.length) {
            if (info.equals(infos[i])) {
                return infos[i].getDevice();
            }
            ++i;
        }
        throw new IllegalArgumentException("Don't recognize MIDI device " + info);
    }

    private static abstract class AlsaInfo
    extends MidiDevice.Info {
        public AlsaInfo(String name, String description) {
            super(name, "Alsa", description, "0.0");
        }

        abstract MidiDevice getDevice();
    }

    private static class AlsaInputPortInfo
    extends AlsaPortInfo {
        public AlsaInputPortInfo(String name, String description, long client, long port) {
            super(name, description, client, port);
        }

        MidiDevice getDevice() {
            return new AlsaInputPortDevice(this);
        }
    }

    private static class AlsaOutputPortInfo
    extends AlsaPortInfo {
        public AlsaOutputPortInfo(String name, String description, long client, long port) {
            super(name, description, client, port);
        }

        MidiDevice getDevice() {
            return new AlsaOutputPortDevice(this);
        }
    }

    public static abstract class AlsaPortInfo
    extends AlsaInfo {
        long client;
        long port;

        public AlsaPortInfo(String name, String description, long client, long port) {
            super(name, description);
            this.client = client;
            this.port = port;
        }
    }

    private static class AlsaSequencerInfo
    extends AlsaInfo {
        public AlsaSequencerInfo(String name, String description) {
            super(name, description);
        }

        MidiDevice getDevice() {
            return AlsaMidiSequencerDevice.getInstance();
        }
    }
}

