/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.Extension;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerNameList
extends Extension.Value
implements Iterable<ServerName> {
    private ByteBuffer buffer;

    public ServerNameList(ByteBuffer buffer) {
        this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public ServerNameList(List<ServerName> names) {
        int length = 2;
        for (ServerName name : names) {
            length += name.length();
        }
        this.buffer = ByteBuffer.allocate(length);
        this.buffer.putShort((short)(length - 2));
        for (ServerName name : names) {
            this.buffer.put(name.buffer());
        }
        this.buffer.rewind();
    }

    @Override
    public int length() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    @Override
    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().limit(this.length());
    }

    public int size() {
        int n = 0;
        int len = this.length();
        int i = 2;
        while (i < len) {
            short l = this.buffer.getShort(i + 1);
            i += l + 3;
            ++n;
        }
        return n;
    }

    public ServerName get(int index) {
        int len = this.length();
        if (len == 0) {
            throw new IndexOutOfBoundsException("0; " + index);
        }
        int n = 0;
        short l = this.buffer.getShort(3);
        int i = 2;
        while (i < len && n < index) {
            l = this.buffer.getShort(i + 1);
            i += l + 3;
            ++n;
        }
        if (n < index) {
            throw new IndexOutOfBoundsException(String.valueOf(n) + "; " + index);
        }
        ByteBuffer buf = ((ByteBuffer)this.buffer.duplicate().position(i).limit(i + l + 3)).slice();
        return new ServerName(buf);
    }

    public void setLength(int newLength) {
        if (newLength < 0 || newLength > 65535) {
            throw new IllegalArgumentException("length must be between 0 and 65535");
        }
        this.buffer.putShort(0, (short)newLength);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("ServerNameList {");
        String subprefix = "  ";
        if (prefix != null) {
            subprefix = String.valueOf(prefix) + subprefix;
        }
        for (ServerName name : this) {
            out.println(name.toString(subprefix));
        }
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("};");
        return str.toString();
    }

    @Override
    public java.util.Iterator<ServerName> iterator() {
        return new Iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    implements java.util.Iterator<ServerName> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < ServerNameList.this.size();
        }

        @Override
        public ServerName next() throws NoSuchElementException {
            try {
                return ServerNameList.this.get(this.index++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NameType {
        HOST_NAME(0);

        private final int value;

        private NameType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class ServerName
    implements Constructed {
        private ByteBuffer buffer;

        public ServerName(ByteBuffer buffer) {
            this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        }

        public ServerName(NameType type, String name) {
            CharsetEncoder utf8 = Charset.forName("UTF-8").newEncoder();
            ByteBuffer nameBuf = null;
            try {
                nameBuf = utf8.encode(CharBuffer.wrap(name));
            }
            catch (CharacterCodingException cce) {
                throw new IllegalArgumentException(cce);
            }
            int length = 3 + nameBuf.remaining();
            this.buffer = ByteBuffer.allocate(length);
            this.buffer.put((byte)type.getValue());
            this.buffer.putShort((short)(length - 3));
            this.buffer.put(nameBuf);
            this.buffer.rewind();
        }

        public int length() {
            return (this.buffer.getShort(1) & 0xFFFF) + 3;
        }

        public ByteBuffer buffer() {
            return (ByteBuffer)this.buffer.duplicate().limit(this.length());
        }

        public NameType type() {
            int v = this.buffer.get(0) & 0xFF;
            if (v == 0) {
                return NameType.HOST_NAME;
            }
            throw new IllegalArgumentException("illegal name type: " + v);
        }

        public String name() {
            int len = this.length();
            Charset cs = Charset.forName("UTF-8");
            return cs.decode((ByteBuffer)this.buffer.duplicate().position(3).limit(len)).toString();
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(String prefix) {
            StringWriter str = new StringWriter();
            PrintWriter out = new PrintWriter(str);
            if (prefix != null) {
                out.print(prefix);
            }
            out.println("struct {");
            if (prefix != null) {
                out.print(prefix);
            }
            out.print("  name_type = ");
            out.print((Object)this.type());
            out.println(";");
            if (prefix != null) {
                out.print(prefix);
            }
            out.print("  server_name = ");
            out.print(this.name());
            out.println(";");
            if (prefix != null) {
                out.print(prefix);
            }
            out.print("} ServerName;");
            return str.toString();
        }
    }
}

