/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.key;

import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;

public abstract class SecretKeyFactoryImpl
extends SecretKeyFactorySpi {
    protected SecretKeyFactoryImpl() {
    }

    protected SecretKey engineGenerateSecret(KeySpec spec) throws InvalidKeySpecException {
        if (spec instanceof SecretKeySpec) {
            return (SecretKey)((Object)spec);
        }
        throw new InvalidKeySpecException("unknown key spec: " + spec.getClass().getName());
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class spec) throws InvalidKeySpecException {
        if (spec.equals(SecretKeySpec.class)) {
            if (key instanceof SecretKeySpec) {
                return (KeySpec)((Object)key);
            }
            return new SecretKeySpec(key.getEncoded(), key.getAlgorithm());
        }
        throw new InvalidKeySpecException("unsupported key spec: " + spec.getName());
    }

    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (!"RAW".equals(key.getFormat())) {
            throw new InvalidKeyException("only raw keys are supported");
        }
        return new SecretKeySpec(key.getEncoded(), key.getAlgorithm());
    }
}

