/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.key.dss.DSSPrivateKey;
import gnu.java.security.key.dss.DSSPublicKey;
import gnu.java.security.key.rsa.GnuRSAPrivateKey;
import gnu.java.security.key.rsa.GnuRSAPublicKey;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.logging.Logger;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public class EncodedKeyFactory
extends KeyFactorySpi {
    private static final Logger log = null;

    private static Object invokeConstructor(String className, Object[] params) throws InvalidKeySpecException {
        Class clazz = EncodedKeyFactory.getConcreteClass(className);
        try {
            Constructor ctor = EncodedKeyFactory.getConcreteCtor(clazz);
            Object result = ctor.newInstance(params);
            return result;
        }
        catch (InstantiationException x) {
            throw new InvalidKeySpecException(x.getMessage(), x);
        }
        catch (IllegalAccessException x) {
            throw new InvalidKeySpecException(x.getMessage(), x);
        }
        catch (InvocationTargetException x) {
            throw new InvalidKeySpecException(x.getMessage(), x);
        }
    }

    private static Class getConcreteClass(String className) throws InvalidKeySpecException {
        try {
            Class<?> result = Class.forName(className);
            return result;
        }
        catch (ClassNotFoundException x) {
            throw new InvalidKeySpecException(x.getMessage(), x);
        }
    }

    private static Constructor getConcreteCtor(Class clazz) throws InvalidKeySpecException {
        try {
            Constructor result = clazz.getConstructor(Integer.TYPE, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class);
            return result;
        }
        catch (NoSuchMethodException x) {
            throw new InvalidKeySpecException(x.getMessage(), x);
        }
    }

    private static Object invokeValueOf(String className, byte[] encoded) throws InvalidKeySpecException {
        Class clazz = EncodedKeyFactory.getConcreteClass(className);
        try {
            Method valueOf = EncodedKeyFactory.getValueOfMethod(clazz);
            Object result = valueOf.invoke(null, new Object[]{encoded});
            return result;
        }
        catch (IllegalAccessException x) {
            throw new InvalidKeySpecException(x.getMessage(), x);
        }
        catch (InvocationTargetException x) {
            throw new InvalidKeySpecException(x.getMessage(), x);
        }
    }

    private static Method getValueOfMethod(Class clazz) throws InvalidKeySpecException {
        try {
            Method result = clazz.getMethod("valueOf", byte[].class);
            return result;
        }
        catch (NoSuchMethodException x) {
            throw new InvalidKeySpecException(x.getMessage(), x);
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        PublicKey result = null;
        if (keySpec instanceof DSAPublicKeySpec) {
            result = this.decodeDSSPublicKey((DSAPublicKeySpec)keySpec);
        } else if (keySpec instanceof RSAPublicKeySpec) {
            result = this.decodeRSAPublicKey((RSAPublicKeySpec)keySpec);
        } else if (keySpec instanceof DHPublicKeySpec) {
            result = this.decodeDHPublicKey((DHPublicKeySpec)keySpec);
        } else {
            if (!(keySpec instanceof X509EncodedKeySpec)) {
                throw new InvalidKeySpecException("Unsupported key specification");
            }
            byte[] input = ((X509EncodedKeySpec)keySpec).getEncoded();
            boolean ok = false;
            try {
                result = DSSPublicKey.valueOf(input);
                ok = true;
            }
            catch (InvalidParameterException invalidParameterException) {}
            if (!ok) {
                try {
                    result = GnuRSAPublicKey.valueOf(input);
                    ok = true;
                }
                catch (InvalidParameterException invalidParameterException) {}
            }
            if (!ok) {
                result = this.decodeDHPublicKey(input);
            }
        }
        return result;
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        PrivateKey result = null;
        if (keySpec instanceof DSAPrivateKeySpec) {
            result = this.decodeDSSPrivateKey((DSAPrivateKeySpec)keySpec);
        } else if (keySpec instanceof RSAPrivateCrtKeySpec) {
            result = this.decodeRSAPrivateKey((RSAPrivateCrtKeySpec)keySpec);
        } else if (keySpec instanceof DHPrivateKeySpec) {
            result = this.decodeDHPrivateKey((DHPrivateKeySpec)keySpec);
        } else {
            if (!(keySpec instanceof PKCS8EncodedKeySpec)) {
                throw new InvalidKeySpecException("Unsupported key specification");
            }
            byte[] input = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            boolean ok = false;
            try {
                result = DSSPrivateKey.valueOf(input);
                ok = true;
            }
            catch (InvalidParameterException invalidParameterException) {}
            if (!ok) {
                try {
                    result = GnuRSAPrivateKey.valueOf(input);
                    ok = true;
                }
                catch (InvalidParameterException invalidParameterException) {}
            }
            if (!ok) {
                result = this.decodeDHPrivateKey(input);
            }
        }
        return result;
    }

    protected KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof PublicKey && "X.509".equalsIgnoreCase(key.getFormat()) && keySpec.isAssignableFrom(X509EncodedKeySpec.class)) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        if (key instanceof PrivateKey && "PKCS#8".equalsIgnoreCase(key.getFormat()) && keySpec.isAssignableFrom(PKCS8EncodedKeySpec.class)) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        throw new InvalidKeySpecException("Unsupported format or invalid key spec class");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("Key translation not supported");
    }

    private DSSPublicKey decodeDSSPublicKey(DSAPublicKeySpec spec) {
        BigInteger p = spec.getP();
        BigInteger q = spec.getQ();
        BigInteger g = spec.getG();
        BigInteger y = spec.getY();
        return new DSSPublicKey(2, p, q, g, y);
    }

    private GnuRSAPublicKey decodeRSAPublicKey(RSAPublicKeySpec spec) {
        BigInteger n = spec.getModulus();
        BigInteger e = spec.getPublicExponent();
        return new GnuRSAPublicKey(2, n, e);
    }

    private DHPublicKey decodeDHPublicKey(DHPublicKeySpec spec) throws InvalidKeySpecException {
        BigInteger p = spec.getP();
        BigInteger g = spec.getG();
        BigInteger y = spec.getY();
        Object[] objectArray = new Object[5];
        objectArray[0] = 2;
        objectArray[2] = p;
        objectArray[3] = g;
        objectArray[4] = y;
        Object[] params = objectArray;
        Object obj = EncodedKeyFactory.invokeConstructor("gnu.javax.crypto.key.dh.GnuDHPublicKey", params);
        return (DHPublicKey)obj;
    }

    private DHPublicKey decodeDHPublicKey(byte[] encoded) throws InvalidKeySpecException {
        Object obj = EncodedKeyFactory.invokeValueOf("gnu.javax.crypto.key.dh.GnuDHPublicKey", encoded);
        return (DHPublicKey)obj;
    }

    private PrivateKey decodeDSSPrivateKey(DSAPrivateKeySpec spec) {
        BigInteger p = spec.getP();
        BigInteger q = spec.getQ();
        BigInteger g = spec.getG();
        BigInteger x = spec.getX();
        return new DSSPrivateKey(3, p, q, g, x);
    }

    private PrivateKey decodeRSAPrivateKey(RSAPrivateCrtKeySpec spec) {
        BigInteger n = spec.getModulus();
        BigInteger e = spec.getPublicExponent();
        BigInteger d = spec.getPrivateExponent();
        BigInteger p = spec.getPrimeP();
        BigInteger q = spec.getPrimeQ();
        BigInteger dP = spec.getPrimeExponentP();
        BigInteger dQ = spec.getPrimeExponentQ();
        BigInteger qInv = spec.getCrtCoefficient();
        return new GnuRSAPrivateKey(3, n, e, d, p, q, dP, dQ, qInv);
    }

    private DHPrivateKey decodeDHPrivateKey(DHPrivateKeySpec spec) throws InvalidKeySpecException {
        BigInteger p = spec.getP();
        BigInteger g = spec.getG();
        BigInteger x = spec.getX();
        Object[] objectArray = new Object[5];
        objectArray[0] = 3;
        objectArray[2] = p;
        objectArray[3] = g;
        objectArray[4] = x;
        Object[] params = objectArray;
        Object obj = EncodedKeyFactory.invokeConstructor("gnu.javax.crypto.key.dh.GnuDHPrivateKey", params);
        return (DHPrivateKey)obj;
    }

    private DHPrivateKey decodeDHPrivateKey(byte[] encoded) throws InvalidKeySpecException {
        Object obj = EncodedKeyFactory.invokeValueOf("gnu.javax.crypto.key.dh.GnuDHPrivateKey", encoded);
        return (DHPrivateKey)obj;
    }
}

