/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.prng;

import gnu.classpath.SystemProperties;
import gnu.java.security.action.GetSecurityPropertyAction;
import gnu.java.security.jce.prng.VMSecureRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.prng.MDGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SecureRandomAdapter
extends SecureRandomSpi {
    private boolean isSeeded = false;
    private MDGenerator adaptee = new MDGenerator();
    private String mdName;
    private static final Logger logger = Logger.getLogger(SecureRandom.class.getName());
    private static final String SECURERANDOM_SOURCE = "securerandom.source";
    private static final String JAVA_SECURITY_EGD = "java.security.egd";

    protected SecureRandomAdapter(String mdName) {
        this.mdName = mdName;
        this.adaptee.init(Collections.singletonMap("gnu.crypto.prng.md.hash.name", mdName));
    }

    public static final byte[] getSeed(int numBytes) {
        URL sourceUrl = null;
        String urlStr = null;
        byte[] buffer = new byte[numBytes];
        GetSecurityPropertyAction action = new GetSecurityPropertyAction(SECURERANDOM_SOURCE);
        try {
            urlStr = AccessController.doPrivileged(action);
            if (urlStr != null) {
                sourceUrl = new URL(urlStr);
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.log(Level.WARNING, "securerandom.source property is malformed: {0}", urlStr);
        }
        if (sourceUrl == null) {
            try {
                urlStr = SystemProperties.getProperty(JAVA_SECURITY_EGD);
                if (urlStr != null) {
                    sourceUrl = new URL(urlStr);
                }
            }
            catch (MalformedURLException malformedURLException) {
                logger.log(Level.WARNING, "java.security.egd property is malformed: {0}", urlStr);
            }
        }
        if (sourceUrl != null) {
            try {
                InputStream in = sourceUrl.openStream();
                in.read(buffer);
                return buffer;
            }
            catch (IOException ioe) {
                logger.log(Level.FINE, "error reading random bytes", ioe);
            }
        }
        VMSecureRandom.generateSeed(buffer, 0, buffer.length);
        return buffer;
    }

    public byte[] engineGenerateSeed(int numBytes) {
        return SecureRandomAdapter.getSeed(numBytes);
    }

    public void engineNextBytes(byte[] bytes) {
        if (!this.isSeeded) {
            this.engineSetSeed(this.engineGenerateSeed(32));
        }
        try {
            this.adaptee.nextBytes(bytes, 0, bytes.length);
        }
        catch (LimitReachedException limitReachedException) {}
    }

    public void engineSetSeed(byte[] seed) {
        this.adaptee.addRandomBytes(seed);
        this.isSeeded = true;
    }
}

