/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.ISO_8859_1;
import gnu.java.nio.charset.US_ASCII;
import gnu.java.nio.charset.UTF_16;
import gnu.java.nio.charset.UTF_16BE;
import gnu.java.nio.charset.UTF_16LE;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class UTF_8
extends Charset {
    UTF_8() {
        super("UTF-8", new String[]{"ibm-1208", "ibm-1209", "ibm-5304", "ibm-5305", "windows-65001", "cp1208", "UTF8"});
    }

    public boolean contains(Charset cs) {
        return cs instanceof US_ASCII || cs instanceof ISO_8859_1 || cs instanceof UTF_8 || cs instanceof UTF_16BE || cs instanceof UTF_16LE || cs instanceof UTF_16;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final class Decoder
    extends CharsetDecoder {
        Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            int inPos = in.position();
            try {
                while (in.hasRemaining()) {
                    byte b1 = in.get();
                    int highNibble = (b1 & 0xFF) >> 4 & 0xF;
                    switch (highNibble) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            if (out.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            out.put((char)b1);
                            ++inPos;
                            break;
                        }
                        case 12: 
                        case 13: {
                            if (in.remaining() < 1) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            if (out.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byte b2 = in.get();
                            if (!Decoder.isContinuation(b2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            char c = (char)((b1 & 0x1F) << 6 | b2 & 0x3F);
                            if (c <= '\u007f') {
                                CoderResult coderResult = CoderResult.malformedForLength(2);
                                return coderResult;
                            }
                            out.put(c);
                            inPos += 2;
                            break;
                        }
                        case 14: {
                            if (in.remaining() < 2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            if (out.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byte b2 = in.get();
                            if (!Decoder.isContinuation(b2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            byte b3 = in.get();
                            if (!Decoder.isContinuation(b3)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            char c = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                            if (c <= '\u07ff') {
                                CoderResult coderResult = CoderResult.malformedForLength(3);
                                return coderResult;
                            }
                            out.put(c);
                            inPos += 3;
                            break;
                        }
                        case 15: {
                            if (in.remaining() < 3) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            if ((b1 & 0xF) > 4) {
                                CoderResult coderResult = CoderResult.malformedForLength(4);
                                return coderResult;
                            }
                            if (out.remaining() < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byte b2 = in.get();
                            if (!Decoder.isContinuation(b2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(3);
                                return coderResult;
                            }
                            byte b3 = in.get();
                            if (!Decoder.isContinuation(b3)) {
                                CoderResult coderResult = CoderResult.malformedForLength(2);
                                return coderResult;
                            }
                            byte b4 = in.get();
                            if (!Decoder.isContinuation(b4)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            int n = ((b1 & 3) << 18 | (b2 & 0x3F) << 12 | (b3 & 0x3F) << 6 | b4 & 0x3F) - 65536;
                            char c1 = (char)(0xD800 | (n & 0xFFC00) >> 10);
                            char c2 = (char)(0xDC00 | n & 0x3FF);
                            out.put(c1);
                            out.put(c2);
                            inPos += 4;
                            break;
                        }
                        default: {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                    }
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                in.position(inPos);
            }
        }

        private static boolean isContinuation(byte b) {
            return (b & 0xC0) == 128;
        }
    }

    private static final class Encoder
    extends CharsetEncoder {
        Encoder(Charset cs) {
            super(cs, 1.1f, 4.0f);
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            int inPos = in.position();
            try {
                while (in.hasRemaining()) {
                    int remaining = out.remaining();
                    char c = in.get();
                    if (c <= '\u007f') {
                        if (remaining < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        out.put((byte)c);
                        ++inPos;
                        continue;
                    }
                    if (c <= '\u07ff') {
                        if (remaining < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        out.put((byte)(0xC0 | c >> 6));
                        out.put((byte)(0x80 | c & 0x3F));
                        ++inPos;
                        continue;
                    }
                    if ('\ud800' <= c && c <= '\udfff') {
                        if (remaining < 4) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        if (c > '\udbff') {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        if (!in.hasRemaining()) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        char d = in.get();
                        if (d < '\udc00' || d > '\udfff') {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        int value = ((c & 0x3FF) << 10 | d & 0x3FF) + 65536;
                        out.put((byte)(0xF0 | value >> 18 & 7));
                        out.put((byte)(0x80 | value >> 12 & 0x3F));
                        out.put((byte)(0x80 | value >> 6 & 0x3F));
                        out.put((byte)(0x80 | value & 0x3F));
                        inPos += 2;
                        continue;
                    }
                    if (remaining < 3) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    out.put((byte)(0xE0 | c >> 12));
                    out.put((byte)(0x80 | c >> 6 & 0x3F));
                    out.put((byte)(0x80 | c & 0x3F));
                    ++inPos;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                in.position(inPos);
            }
        }
    }
}

