/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;

public final class ChannelInputStream
extends InputStream {
    private ReadableByteChannel ch;

    public ChannelInputStream(ReadableByteChannel ch) {
        this.ch = ch;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.ch instanceof SelectableChannel && !((SelectableChannel)((Object)this.ch)).isBlocking()) {
            throw new IllegalBlockingModeException();
        }
        ByteBuffer b = ByteBuffer.wrap(buf, off, len);
        return this.ch.read(b);
    }

    public int read() throws IOException {
        if (this.ch instanceof SelectableChannel && !((SelectableChannel)((Object)this.ch)).isBlocking()) {
            throw new IllegalBlockingModeException();
        }
        ByteBuffer buffer = ByteBuffer.allocate(1);
        int result = this.ch.read(buffer);
        if (result == -1) {
            return -1;
        }
        if (result == 0) {
            throw new IOException("Could not read from channel");
        }
        return buffer.get(0) & 0xFF;
    }
}

