/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.classpath.SystemProperties;
import gnu.java.net.protocol.http.Authenticator;
import gnu.java.net.protocol.http.ByteArrayRequestBodyWriter;
import gnu.java.net.protocol.http.Credentials;
import gnu.java.net.protocol.http.HTTPConnection;
import gnu.java.net.protocol.http.Headers;
import gnu.java.net.protocol.http.Request;
import gnu.java.net.protocol.http.Response;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPURLConnection
extends HttpsURLConnection
implements HandshakeCompletedListener {
    private HTTPConnection connection;
    String proxyHostname;
    int proxyPort = -1;
    String agent;
    boolean keepAlive;
    private Request request;
    private Headers requestHeaders = new Headers();
    private ByteArrayOutputStream requestSink;
    private boolean requestMethodSetExplicitly;
    private Response response;
    private InputStream responseSink;
    private InputStream errorSink;
    private HandshakeCompletedEvent handshakeEvent;

    public HTTPURLConnection(URL url) throws IOException {
        super(url);
        String port;
        String proxy = SystemProperties.getProperty("http.proxyHost");
        if (proxy != null && proxy.length() > 0 && (port = SystemProperties.getProperty("http.proxyPort")) != null && port.length() > 0) {
            try {
                this.proxyPort = Integer.parseInt(port);
                this.proxyHostname = proxy;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.agent = SystemProperties.getProperty("http.agent");
        String ka = SystemProperties.getProperty("http.keepAlive");
        this.keepAlive = ka == null || !"false".equals(ka);
    }

    @Override
    public void connect() throws IOException {
        boolean retry;
        String contentType;
        Credentials creds;
        int ci;
        if (this.connected) {
            return;
        }
        String protocol = this.url.getProtocol();
        boolean secure = "https".equals(protocol);
        String host = this.url.getHost();
        int port = this.url.getPort();
        if (port < 0) {
            port = secure ? 443 : 80;
        }
        String file = this.url.getFile();
        String username = this.url.getUserInfo();
        String password = null;
        if (username != null && (ci = username.indexOf(58)) != -1) {
            password = username.substring(ci + 1);
            username = username.substring(0, ci);
        }
        Credentials credentials = creds = username == null ? null : new Credentials(username, password);
        if ("POST".equals(this.method) && (contentType = this.requestHeaders.getValue("Content-Type")) == null) {
            this.requestHeaders.addValue("Content-Type", "application/x-www-form-urlencoded");
        }
        do {
            retry = false;
            if (this.connection == null) {
                this.connection = this.getConnection(host, port, secure);
                if (secure) {
                    SSLSocketFactory factory = this.getSSLSocketFactory();
                    if (factory != null) {
                        this.connection.setSSLSocketFactory(factory);
                    }
                    this.connection.addHandshakeCompletedListener(this);
                }
            }
            if (this.proxyHostname != null) {
                if (this.proxyPort < 0) {
                    this.proxyPort = secure ? 443 : 80;
                }
                this.connection.setProxy(this.proxyHostname, this.proxyPort);
            }
            try {
                this.request = this.connection.newRequest(this.method, file);
                if (!this.keepAlive) {
                    this.request.setHeader("Connection", "close");
                }
                if (this.agent != null) {
                    this.request.setHeader("User-Agent", this.agent);
                }
                this.request.getHeaders().putAll(this.requestHeaders);
                if (this.requestSink != null) {
                    byte[] content = this.requestSink.toByteArray();
                    ByteArrayRequestBodyWriter writer = new ByteArrayRequestBodyWriter(content);
                    this.request.setRequestBodyWriter(writer);
                }
                if (creds != null) {
                    this.request.setAuthenticator(new Authenticator(){

                        public Credentials getCredentials(String realm, int attempts) {
                            return attempts < 2 ? creds : null;
                        }
                    });
                }
                this.response = this.request.dispatch();
            }
            catch (IOException ioe) {
                if (this.connection.useCount > 0) {
                    try {
                        this.connection.close();
                    }
                    catch (IOException iOException) {}
                    this.connection = null;
                    retry = true;
                    continue;
                }
                throw ioe;
            }
            if (this.response.isRedirect() && this.getInstanceFollowRedirects()) {
                int ci2;
                int end;
                String location;
                InputStream body = this.response.getBody();
                if (body != null) {
                    int n;
                    byte[] ignore = new byte[1024];
                    while ((n = body.read(ignore, 0, ignore.length)) != -1) {
                    }
                }
                if ((location = this.response.getHeader("Location")) == null) continue;
                String connectionUri = this.connection.getURI();
                int start = connectionUri.length();
                if (location.startsWith(connectionUri) && location.charAt(start) == '/') {
                    file = location.substring(start);
                    retry = true;
                    continue;
                }
                if (location.startsWith("http:")) {
                    this.connection.close();
                    this.connection = null;
                    secure = false;
                    start = 7;
                    end = location.indexOf(47, start);
                    if (end == -1) {
                        end = location.length();
                    }
                    if ((ci2 = (host = location.substring(start, end)).lastIndexOf(58)) != -1) {
                        port = Integer.parseInt(host.substring(ci2 + 1));
                        host = host.substring(0, ci2);
                    } else {
                        port = 80;
                    }
                    file = location.substring(end);
                    retry = true;
                    continue;
                }
                if (location.startsWith("https:")) {
                    this.connection.close();
                    this.connection = null;
                    secure = true;
                    start = 8;
                    end = location.indexOf(47, start);
                    if (end == -1) {
                        end = location.length();
                    }
                    if ((ci2 = (host = location.substring(start, end)).lastIndexOf(58)) != -1) {
                        port = Integer.parseInt(host.substring(ci2 + 1));
                        host = host.substring(0, ci2);
                    } else {
                        port = 443;
                    }
                    file = location.substring(end);
                    retry = true;
                    continue;
                }
                if (location.length() <= 0) continue;
                if (location.charAt(0) == '/') {
                    file = location;
                } else {
                    int lsi = file.lastIndexOf(47);
                    file = lsi == -1 ? "/" : file.substring(0, lsi + 1);
                    file = String.valueOf(file) + location;
                }
                retry = true;
                continue;
            }
            this.responseSink = this.response.getBody();
            if (!this.response.isError()) continue;
            this.errorSink = this.responseSink;
        } while (retry);
        this.connected = true;
    }

    HTTPConnection getConnection(String host, int port, boolean secure) throws IOException {
        HTTPConnection connection = this.keepAlive ? HTTPConnection.Pool.instance.get(host, port, secure, this.getConnectTimeout(), this.getReadTimeout()) : new HTTPConnection(host, port, secure, this.getConnectTimeout(), this.getReadTimeout());
        return connection;
    }

    @Override
    public void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public boolean usingProxy() {
        return this.proxyHostname != null;
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Already connected");
        }
        int len = (method = method.toUpperCase()).length();
        if (len == 0) {
            throw new ProtocolException("Empty method name");
        }
        int i = 0;
        while (i < len) {
            char c = method.charAt(i);
            if (c < 'A' || c > 'Z') {
                throw new ProtocolException("Illegal character '" + c + "' at index " + i);
            }
            ++i;
        }
        this.method = method;
        this.requestMethodSetExplicitly = true;
    }

    @Override
    public String getRequestProperty(String key) {
        return this.requestHeaders.getValue(key);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        Map<String, List<String>> m = this.requestHeaders.getAsMap();
        return Collections.unmodifiableMap(m);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        super.setRequestProperty(key, value);
        this.requestHeaders.put(key, value);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        super.addRequestProperty(key, value);
        this.requestHeaders.addValue(key, value);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.connected) {
            throw new ProtocolException("Already connected");
        }
        if (!this.doOutput) {
            throw new ProtocolException("doOutput is false");
        }
        if (!this.requestMethodSetExplicitly) {
            this.method = "POST";
        }
        if (this.requestSink == null) {
            this.requestSink = new ByteArrayOutputStream();
        }
        return this.requestSink;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("doInput is false");
        }
        if (this.response.isError()) {
            int code = this.response.getCode();
            if (code == 404 || code == 410) {
                throw new FileNotFoundException(this.url.toString());
            }
            throw new IOException("Server returned HTTP response code " + code + " for URL " + this.url.toString());
        }
        return this.responseSink;
    }

    @Override
    public InputStream getErrorStream() {
        return this.errorSink;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        Map<String, List<String>> m = this.response.getHeaders().getAsMap();
        m.put(null, Collections.singletonList(this.getStatusLine(this.response)));
        return Collections.unmodifiableMap(m);
    }

    String getStatusLine(Response response) {
        return "HTTP/" + response.getMajorVersion() + "." + response.getMinorVersion() + " " + response.getCode() + " " + response.getMessage();
    }

    @Override
    public String getHeaderField(int index) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (index == 0) {
            return this.getStatusLine(this.response);
        }
        return this.response.getHeaders().getHeaderValue(index - 1);
    }

    @Override
    public String getHeaderFieldKey(int index) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return this.response.getHeaders().getHeaderName(index - 1);
    }

    @Override
    public String getHeaderField(String name) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return this.response.getHeader(name);
    }

    @Override
    public long getHeaderFieldDate(String name, long def) {
        Date date;
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return def;
            }
        }
        return (date = this.response.getDateHeader(name)) == null ? def : date.getTime();
    }

    @Override
    public String getContentType() {
        return this.getHeaderField("Content-Type");
    }

    @Override
    public int getResponseCode() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.response.getCode();
    }

    @Override
    public String getResponseMessage() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.response.getMessage();
    }

    @Override
    public String getCipherSuite() {
        if (!this.connected) {
            throw new IllegalStateException("not connected");
        }
        return this.handshakeEvent.getCipherSuite();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        if (!this.connected) {
            throw new IllegalStateException("not connected");
        }
        return this.handshakeEvent.getLocalCertificates();
    }

    @Override
    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        if (!this.connected) {
            throw new IllegalStateException("not connected");
        }
        return this.handshakeEvent.getPeerCertificates();
    }

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent event) {
        this.handshakeEvent = event;
    }

    @Override
    public void setReadTimeout(int timeout) throws IllegalArgumentException {
        super.setReadTimeout(timeout);
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.getSocket().setSoTimeout(timeout);
        }
        catch (IOException iOException) {}
    }
}

