/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkComponentPeer;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.peer.CheckboxPeer;
import java.util.WeakHashMap;

public class GtkCheckboxPeer
extends GtkComponentPeer
implements CheckboxPeer {
    public CheckboxGroup current_group;
    private boolean currentState;
    private static WeakHashMap<CheckboxGroup, Long> groupMap = new WeakHashMap();

    public native void createCheckButton();

    public native void createRadioButton(long var1);

    public native void addToGroup(long var1);

    public native void removeFromGroup();

    public native void switchToGroup(long var1);

    public native void connectSignals();

    protected native void gtkWidgetModifyFont(String var1, int var2, int var3);

    native void gtkButtonSetLabel(String var1);

    native void gtkToggleButtonSetActive(boolean var1);

    public GtkCheckboxPeer(Checkbox c) {
        super(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() {
        Checkbox checkbox = (Checkbox)this.awtComponent;
        this.current_group = checkbox.getCheckboxGroup();
        if (this.current_group == null) {
            this.createCheckButton();
        } else {
            Long groupPointer = null;
            WeakHashMap<CheckboxGroup, Long> weakHashMap = groupMap;
            synchronized (weakHashMap) {
                groupPointer = groupMap.get(this.current_group);
            }
            if (groupPointer == null) {
                this.createRadioButton(0L);
            } else {
                this.createRadioButton(groupPointer);
            }
        }
        this.currentState = checkbox.getState();
        this.gtkToggleButtonSetActive(this.currentState);
        String label = checkbox.getLabel();
        if (label != null) {
            this.gtkButtonSetLabel(label);
        }
    }

    public synchronized void setState(boolean state) {
        if (this.currentState != state) {
            this.currentState = state;
            this.gtkToggleButtonSetActive(state);
        }
    }

    public void setLabel(String label) {
        this.gtkButtonSetLabel(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckboxGroup(CheckboxGroup group) {
        if (this.current_group == null && group != null) {
            this.current_group = group;
            Long groupPointer = null;
            WeakHashMap<CheckboxGroup, Long> weakHashMap = groupMap;
            synchronized (weakHashMap) {
                groupPointer = groupMap.get(this.current_group);
            }
            if (groupPointer == null) {
                this.addToGroup(0L);
            } else {
                this.addToGroup(groupPointer);
            }
        } else if (this.current_group != null && group == null) {
            this.removeFromGroup();
            this.current_group = null;
        } else {
            if (this.current_group == null && group == null) {
                return;
            }
            if (this.current_group != group) {
                this.current_group = group;
                Long groupPointer = null;
                WeakHashMap<CheckboxGroup, Long> weakHashMap = groupMap;
                synchronized (weakHashMap) {
                    groupPointer = groupMap.get(this.current_group);
                }
                if (groupPointer == null) {
                    this.switchToGroup(0L);
                } else {
                    this.switchToGroup(groupPointer);
                }
            }
        }
    }

    public synchronized void postItemEvent(Object item, boolean state) {
        if (this.currentState != state) {
            this.currentState = state;
            super.postItemEvent(this.awtComponent, state ? 1 : 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToGroupMap(long groupPointer) {
        WeakHashMap<CheckboxGroup, Long> weakHashMap = groupMap;
        synchronized (weakHashMap) {
            groupMap.put(this.current_group, new Long(groupPointer));
        }
    }

    public void dispose() {
        groupMap.clear();
        this.current_group = null;
        this.currentState = false;
        super.dispose();
    }
}

