/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import java.awt.AWTError;
import java.awt.AlphaComposite;
import java.awt.CompositeContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class AlphaCompositeContext
implements CompositeContext {
    private AlphaComposite composite;
    private ColorModel srcColorModel;
    private ColorModel dstColorModel;
    private float fs;
    private float fd;

    public AlphaCompositeContext(AlphaComposite aComp, ColorModel srcCM, ColorModel dstCM) {
        this.composite = aComp;
        this.srcColorModel = srcCM;
        this.dstColorModel = dstCM;
        switch (this.composite.getRule()) {
            case 1: {
                this.fs = 0.0f;
                this.fd = 0.0f;
                break;
            }
            case 9: {
                this.fs = 0.0f;
                this.fd = 1.0f;
                break;
            }
            case 11: {
                this.fs = 1.0f;
                this.fd = 1.0f;
                break;
            }
            case 6: {
                this.fs = 0.0f;
                this.fd = 0.0f;
                break;
            }
            case 8: {
                this.fs = 0.0f;
                this.fd = 0.0f;
                break;
            }
            case 4: {
                this.fs = 1.0f;
                this.fd = 1.0f;
                break;
            }
            case 2: {
                this.fs = 1.0f;
                this.fd = 0.0f;
                break;
            }
            case 10: {
                this.fs = 1.0f;
                this.fd = 1.0f;
                break;
            }
            case 5: {
                this.fs = 0.0f;
                this.fd = 0.0f;
                break;
            }
            case 7: {
                this.fs = 0.0f;
                this.fd = 0.0f;
                break;
            }
            case 3: {
                this.fs = 1.0f;
                this.fd = 1.0f;
                break;
            }
            case 12: {
                this.fs = 1.0f;
                this.fd = 1.0f;
                break;
            }
            default: {
                throw new AWTError("Illegal AlphaComposite rule");
            }
        }
    }

    public void dispose() {
    }

    public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
        int x0 = src.getMinX();
        int y0 = src.getMinY();
        int width = src.getWidth();
        int height = src.getHeight();
        int x1 = x0 + width;
        int y1 = y0 + height;
        Object srcPixel = null;
        Object dstPixel = null;
        int srcComponentsLength = this.srcColorModel.getNumComponents();
        if (!this.srcColorModel.hasAlpha()) {
            ++srcComponentsLength;
        }
        float[] srcComponents = new float[srcComponentsLength];
        int dstComponentsLength = this.dstColorModel.getNumComponents();
        if (!this.dstColorModel.hasAlpha()) {
            ++dstComponentsLength;
        }
        float[] dstComponents = new float[dstComponentsLength];
        if (srcComponentsLength != dstComponentsLength) {
            throw new AWTError("The color models of the source and destination haveincompatible number of color components");
        }
        this.srcColorModel.getTransferType();
        this.dstColorModel.getTransferType();
        int y = y0;
        while (y < y1) {
            int x = x0;
            while (x < x1) {
                int i;
                srcPixel = src.getDataElements(x, y, (int[])srcPixel);
                dstPixel = dstIn.getDataElements(x, y, dstPixel);
                srcComponents = this.srcColorModel.getNormalizedComponents(srcPixel, srcComponents, 0);
                if (!this.srcColorModel.hasAlpha()) {
                    srcComponents[srcComponentsLength - 1] = 1.0f;
                }
                dstComponents = this.dstColorModel.getNormalizedComponents(dstPixel, dstComponents, 0);
                if (!this.dstColorModel.hasAlpha()) {
                    dstComponents[dstComponentsLength - 1] = 1.0f;
                }
                float compositeAlpha = this.composite.getAlpha();
                int n = srcComponentsLength - 1;
                srcComponents[n] = srcComponents[n] * compositeAlpha;
                if (this.srcColorModel.isAlphaPremultiplied()) {
                    i = srcComponentsLength - 2;
                    while (i >= 0) {
                        int n2 = i--;
                        srcComponents[n2] = srcComponents[n2] * compositeAlpha;
                    }
                } else {
                    i = srcComponentsLength - 2;
                    while (i >= 0) {
                        int n3 = i--;
                        srcComponents[n3] = srcComponents[n3] * srcComponents[srcComponentsLength - 1];
                    }
                }
                if (!this.dstColorModel.isAlphaPremultiplied()) {
                    i = dstComponentsLength - 2;
                    while (i >= 0) {
                        int n4 = i--;
                        dstComponents[n4] = dstComponents[n4] * dstComponents[dstComponents.length - 1];
                    }
                }
                float srcAlpha = srcComponents[srcComponentsLength - 1];
                float dstAlpha = dstComponents[dstComponentsLength - 1];
                switch (this.composite.getRule()) {
                    case 11: {
                        this.fs = 1.0f - dstAlpha;
                        this.fd = srcAlpha;
                        break;
                    }
                    case 6: {
                        this.fd = srcAlpha;
                        break;
                    }
                    case 8: {
                        this.fd = 1.0f - srcAlpha;
                        break;
                    }
                    case 4: {
                        this.fs = 1.0f - dstAlpha;
                        break;
                    }
                    case 10: {
                        this.fs = srcAlpha;
                        this.fd = 1.0f - srcAlpha;
                        break;
                    }
                    case 5: {
                        this.fs = dstAlpha;
                        break;
                    }
                    case 7: {
                        this.fs = 1.0f - dstAlpha;
                        break;
                    }
                    case 3: {
                        this.fd = 1.0f - srcAlpha;
                        break;
                    }
                    case 12: {
                        this.fs = 1.0f - dstAlpha;
                        this.fd = 1.0f - srcAlpha;
                    }
                }
                int i2 = 0;
                while (i2 < srcComponentsLength) {
                    dstComponents[i2] = srcComponents[i2] * this.fs + dstComponents[i2] * this.fd;
                    ++i2;
                }
                dstAlpha = dstComponents[dstComponentsLength - 1];
                if (!this.dstColorModel.isAlphaPremultiplied() && dstAlpha != 0.0f) {
                    i2 = 0;
                    while (i2 < dstComponentsLength - 1) {
                        dstComponents[i2] = dstComponents[i2] / dstAlpha;
                        ++i2;
                    }
                }
                dstPixel = this.dstColorModel.getDataElements(dstComponents, 0, dstPixel);
                dstOut.setDataElements(x, y, dstPixel);
                ++x;
            }
            ++y;
        }
    }
}

