/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.transport;

import gnu.classpath.jdwp.transport.ITransport;
import gnu.classpath.jdwp.transport.SocketTransport;
import gnu.classpath.jdwp.transport.TransportException;
import java.util.HashMap;

public class TransportFactory {
    private static final String _TRANSPORT_PROPERTY = "transport";
    private static TransportMethod[] _transportMethods = new TransportMethod[]{new TransportMethod("dt_socket", SocketTransport.class)};

    public static ITransport newInstance(HashMap properties) throws TransportException {
        String name = null;
        if (properties != null) {
            name = (String)properties.get(_TRANSPORT_PROPERTY);
        }
        if (name == null) {
            throw new TransportException("no transport specified");
        }
        int i = 0;
        while (i < _transportMethods.length) {
            if (TransportFactory._transportMethods[i].name.equals(name)) {
                try {
                    ITransport t = (ITransport)TransportFactory._transportMethods[i].clazz.newInstance();
                    t.configure(properties);
                    return t;
                }
                catch (TransportException te) {
                    throw te;
                }
                catch (Exception e) {
                    throw new TransportException(e);
                }
            }
            ++i;
        }
        throw new TransportException("transport \"" + name + "\" not found");
    }

    private static class TransportMethod {
        String name;
        Class clazz;

        public TransportMethod(String name, Class clazz) {
            this.name = name;
            this.clazz = clazz;
        }
    }
}

