/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMFrame;
import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ThreadId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.value.ObjectValue;
import gnu.classpath.jdwp.value.Value;
import gnu.classpath.jdwp.value.ValueFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class StackFrameCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeGetValues(bb, os);
                    break;
                }
                case 2: {
                    this.executeSetValues(bb, os);
                    break;
                }
                case 3: {
                    this.executeThisObject(bb, os);
                    break;
                }
                case 4: {
                    this.executePopFrames(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in Stack Frame Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    private void executeGetValues(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ThreadId tId = (ThreadId)this.idMan.readObjectId(bb);
        Thread thread = tId.getThread();
        long frameID = bb.getLong();
        VMFrame frame = VMVirtualMachine.getFrame(thread, frameID);
        int slots = bb.getInt();
        os.writeInt(slots);
        int i = 0;
        while (i < slots) {
            int slot = bb.getInt();
            byte sig = bb.get();
            Value val = frame.getValue(slot, sig);
            val.writeTagged(os);
            ++i;
        }
    }

    private void executeSetValues(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ThreadId tId = (ThreadId)this.idMan.readObjectId(bb);
        Thread thread = tId.getThread();
        long frameID = bb.getLong();
        VMFrame frame = VMVirtualMachine.getFrame(thread, frameID);
        int slots = bb.getInt();
        int i = 0;
        while (i < slots) {
            int slot = bb.getInt();
            Value value = ValueFactory.createFromTagged(bb);
            frame.setValue(slot, value);
            ++i;
        }
    }

    private void executeThisObject(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ThreadId tId = (ThreadId)this.idMan.readObjectId(bb);
        Thread thread = tId.getThread();
        long frameID = bb.getLong();
        VMFrame frame = VMVirtualMachine.getFrame(thread, frameID);
        ObjectValue objVal = new ObjectValue(frame.getObject());
        objVal.writeTagged(os);
    }

    private void executePopFrames(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        String msg = "popping frames is unsupported";
        throw new NotImplementedException(msg);
    }
}

