/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.CDR;

import gnu.CORBA.CDR.AbstractDataInput;
import gnu.java.lang.CPStringBuilder;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class LittleEndianInputStream
extends FilterInputStream
implements AbstractDataInput {
    byte[] buf = new byte[8];

    public LittleEndianInputStream(InputStream in) {
        super(in);
    }

    public int read(byte[] b) throws IOException {
        return this.in.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    public boolean readBoolean() throws IOException {
        return this.convertToBoolean(this.in.read());
    }

    public byte readByte() throws IOException {
        return this.convertToByte(this.in.read());
    }

    public char readChar() throws IOException {
        this.readFully(this.buf, 0, 2);
        return this.convertToChar(this.buf);
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    /*
     * Unable to fully structure code
     */
    public void readFully(byte[] buf, int offset, int len) throws IOException {
        if (len >= 0) ** GOTO lbl8
        throw new IndexOutOfBoundsException("Negative length: " + len);
lbl-1000:
        // 1 sources

        {
            numread = this.in.read(buf, offset, len);
            if (numread < 0) {
                throw new EOFException();
            }
            len -= numread;
            offset += numread;
lbl8:
            // 2 sources

            ** while (len > 0)
        }
lbl9:
        // 1 sources

    }

    public int readInt() throws IOException {
        this.readFully(this.buf, 0, 4);
        return this.convertToInt(this.buf);
    }

    public String readLine() throws IOException {
        CPStringBuilder strb = new CPStringBuilder();
        while (true) {
            int c;
            if ((c = this.in.read()) == -1) {
                return strb.length() > 0 ? strb.toString() : null;
            }
            if (c == 13) {
                int next_c = this.in.read();
                if (next_c == 10 || next_c == -1) break;
                if (!(this.in instanceof PushbackInputStream)) {
                    this.in = new PushbackInputStream(this.in);
                }
                ((PushbackInputStream)this.in).unread(next_c);
                break;
            }
            if (c == 10) break;
            strb.append((char)c);
        }
        return strb.length() > 0 ? strb.toString() : "";
    }

    public long readLong() throws IOException {
        this.readFully(this.buf, 0, 8);
        return this.convertToLong(this.buf);
    }

    public short readShort() throws IOException {
        this.readFully(this.buf, 0, 2);
        return this.convertToShort(this.buf);
    }

    public int readUnsignedByte() throws IOException {
        return this.convertToUnsignedByte(this.in.read());
    }

    public int readUnsignedShort() throws IOException {
        this.readFully(this.buf, 0, 2);
        return this.convertToUnsignedShort(this.buf);
    }

    public int skipBytes(int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        try {
            return (int)this.in.skip(n);
        }
        catch (EOFException eOFException) {
            return n;
        }
    }

    protected boolean convertToBoolean(int b) throws EOFException {
        if (b < 0) {
            throw new EOFException();
        }
        return b != 0;
    }

    protected byte convertToByte(int i) throws EOFException {
        if (i < 0) {
            throw new EOFException();
        }
        return (byte)i;
    }

    protected int convertToUnsignedByte(int i) throws EOFException {
        if (i < 0) {
            throw new EOFException();
        }
        return i & 0xFF;
    }

    protected char convertToChar(byte[] buf) {
        return (char)(buf[1] << 8 | buf[0] & 0xFF);
    }

    protected short convertToShort(byte[] buf) {
        return (short)(buf[1] << 8 | buf[0] & 0xFF);
    }

    protected int convertToUnsignedShort(byte[] buf) {
        return (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
    }

    protected int convertToInt(byte[] buf) {
        return (buf[3] & 0xFF) << 24 | (buf[2] & 0xFF) << 16 | (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
    }

    protected long convertToLong(byte[] buf) {
        return (long)(buf[7] & 0xFF) << 56 | (long)(buf[6] & 0xFF) << 48 | (long)(buf[5] & 0xFF) << 40 | (long)(buf[4] & 0xFF) << 32 | (long)(buf[3] & 0xFF) << 24 | (long)(buf[2] & 0xFF) << 16 | (long)(buf[1] & 0xFF) << 8 | (long)(buf[0] & 0xFF);
    }

    public String readUTF() {
        throw new InternalError();
    }
}

