/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.SystemProperties;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

class KeyPasswdCmd
extends Command {
    private static final Logger log = Logger.getLogger(KeyPasswdCmd.class.getName());
    protected String _alias;
    protected String _password;
    protected String _newPassword;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    private char[] newPasswordChars;

    KeyPasswdCmd() {
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public void setKeypass(String password) {
        this._password = password;
    }

    public void setNew(String password) {
        this._newPassword = password;
    }

    public void setStoretype(String type) {
        this._ksType = type;
    }

    public void setKeystore(String url) {
        this._ksURL = url;
    }

    public void setStorepass(String password) {
        this._ksPassword = password;
    }

    public void setProvider(String className) {
        this._providerClassName = className;
    }

    void setup() throws Exception {
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setAliasParam(this._alias);
        this.setKeyPasswordNoPrompt(this._password);
        if (Configuration.DEBUG) {
            log.fine("-keypasswd handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -new=" + this._newPassword);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws KeyStoreException, NoSuchAlgorithmException, IOException, UnsupportedCallbackException, UnrecoverableKeyException, CertificateException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        Key privateKey = this.getAliasPrivateKey();
        Certificate[] chain = this.store.getCertificateChain(this.alias);
        this.setNewKeyPassword(this._newPassword);
        this.store.setKeyEntry(this.alias, privateKey, this.newPasswordChars, chain);
        this.saveKeyStore();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser result = new ClasspathToolParser("keypasswd", true);
        result.setHeader(Messages.getString("KeyPasswdCmd.23"));
        result.setFooter(Messages.getString("KeyPasswdCmd.22"));
        OptionGroup options = new OptionGroup(Messages.getString("KeyPasswdCmd.21"));
        options.add(new Option("alias", Messages.getString("KeyPasswdCmd.20"), Messages.getString("KeyPasswdCmd.19")){

            public void parsed(String argument) throws OptionException {
                KeyPasswdCmd.this._alias = argument;
            }
        });
        options.add(new Option("keypass", Messages.getString("KeyPasswdCmd.18"), Messages.getString("KeyPasswdCmd.9")){

            public void parsed(String argument) throws OptionException {
                KeyPasswdCmd.this._password = argument;
            }
        });
        options.add(new Option("new", Messages.getString("KeyPasswdCmd.16"), Messages.getString("KeyPasswdCmd.9")){

            public void parsed(String argument) throws OptionException {
                KeyPasswdCmd.this._newPassword = argument;
            }
        });
        options.add(new Option("storetype", Messages.getString("KeyPasswdCmd.14"), Messages.getString("KeyPasswdCmd.13")){

            public void parsed(String argument) throws OptionException {
                KeyPasswdCmd.this._ksType = argument;
            }
        });
        options.add(new Option("keystore", Messages.getString("KeyPasswdCmd.12"), Messages.getString("KeyPasswdCmd.11")){

            public void parsed(String argument) throws OptionException {
                KeyPasswdCmd.this._ksURL = argument;
            }
        });
        options.add(new Option("storepass", Messages.getString("KeyPasswdCmd.10"), Messages.getString("KeyPasswdCmd.9")){

            public void parsed(String argument) throws OptionException {
                KeyPasswdCmd.this._ksPassword = argument;
            }
        });
        options.add(new Option("provider", Messages.getString("KeyPasswdCmd.8"), Messages.getString("KeyPasswdCmd.7")){

            public void parsed(String argument) throws OptionException {
                KeyPasswdCmd.this._providerClassName = argument;
            }
        });
        options.add(new Option("v", Messages.getString("KeyPasswdCmd.6")){

            public void parsed(String argument) throws OptionException {
                KeyPasswdCmd.this.verbose = true;
            }
        });
        result.add(options);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", result);
        }
        return result;
    }

    private void setNewKeyPassword(String password) throws IOException, UnsupportedCallbackException {
        if (password != null) {
            this.newPasswordChars = password.toCharArray();
        } else {
            boolean ok = false;
            Callback[] prompts = new Callback[1];
            Callback[] errors = new Callback[1];
            int i = 0;
            while (i < 3) {
                if (this.prompt4NewPassword(this.getCallbackHandler(), prompts, errors)) {
                    ok = true;
                    break;
                }
                ++i;
            }
            if (!ok) {
                throw new SecurityException(Messages.getString("StorePasswdCmd.19"));
            }
        }
    }

    private boolean prompt4NewPassword(CallbackHandler handler, Callback[] prompts, Callback[] errors) throws IOException, UnsupportedCallbackException {
        String p = Messages.getFormattedString("KeyPasswdCmd.24", this.alias);
        PasswordCallback pcb = new PasswordCallback(p, false);
        prompts[0] = pcb;
        handler.handle(prompts);
        char[] pwd1 = pcb.getPassword();
        pcb.clearPassword();
        String ls = SystemProperties.getProperty((String)"line.separator");
        if (pwd1 == null || pwd1.length < 6) {
            String m = String.valueOf(Messages.getString("StorePasswdCmd.21")) + ls;
            errors[0] = new TextOutputCallback(2, m);
            handler.handle(errors);
            return false;
        }
        if (Arrays.equals(this.keyPasswordChars, pwd1)) {
            String m = String.valueOf(Messages.getString("StorePasswdCmd.22")) + ls;
            errors[0] = new TextOutputCallback(2, m);
            handler.handle(errors);
            return false;
        }
        p = Messages.getFormattedString("KeyPasswdCmd.28", this.alias);
        pcb = new PasswordCallback(p, false);
        prompts[0] = pcb;
        handler.handle(prompts);
        char[] pwd2 = pcb.getPassword();
        pcb.clearPassword();
        if (!Arrays.equals(pwd1, pwd2)) {
            String m = String.valueOf(Messages.getString("StorePasswdCmd.24")) + ls;
            errors[0] = new TextOutputCallback(2, m);
            handler.handle(errors);
            return false;
        }
        this.newPasswordChars = pwd2;
        return true;
    }
}

