/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.SourcePosition;
import gnu.classpath.tools.gjdoc.ClassDocImpl;
import gnu.classpath.tools.gjdoc.DocImpl;
import gnu.classpath.tools.gjdoc.MemberDocImpl;
import gnu.classpath.tools.gjdoc.expr.CircularExpressionException;
import gnu.classpath.tools.gjdoc.expr.Evaluator;
import gnu.classpath.tools.gjdoc.expr.IllegalExpressionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldDocImpl
extends MemberDocImpl
implements FieldDoc,
Cloneable {
    private boolean isTransient;
    private boolean isVolatile;
    private String valueLiteral;
    private Object constantValue;
    private boolean constantValueEvaluated;

    private FieldDocImpl(ClassDoc containingClass, PackageDoc containingPackage, SourcePosition position) {
        super(containingClass, containingPackage, position);
    }

    private static FieldDocImpl createFieldDoc(FieldDocImpl prototype, String fieldDef, String fieldValueLiteral) {
        if (fieldValueLiteral != null && fieldValueLiteral.length() == 0) {
            fieldValueLiteral = null;
        }
        try {
            FieldDocImpl fieldDoc = (FieldDocImpl)prototype.clone();
            String dimSuffix = "";
            while (fieldDef.trim().endsWith("[") || fieldDef.trim().endsWith("]")) {
                fieldDef = fieldDef.trim();
                dimSuffix = String.valueOf(fieldDef.charAt(fieldDef.length() - 1)) + dimSuffix;
                fieldDef = fieldDef.substring(0, fieldDef.length() - 1);
            }
            fieldDoc.setTypeName(String.valueOf(fieldDoc.getTypeName()) + dimSuffix);
            fieldDoc.setName(fieldDef.trim());
            fieldDoc.setValueLiteral(fieldValueLiteral);
            return fieldDoc;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Collection<FieldDoc> createFromSource(ClassDoc containingClass, PackageDoc containingPackage, char[] source, int startIndex, int endIndex) {
        int state;
        ArrayList<FieldDoc> rcList = new ArrayList<FieldDoc>();
        FieldDocImpl fd = new FieldDocImpl(containingClass, containingPackage, DocImpl.getPosition(containingClass, source, startIndex));
        int ndx = fd.parseModifiers(source, startIndex, endIndex);
        if (containingClass.isInterface()) {
            fd.accessLevel = 0;
        }
        int prevState = state = 1;
        int bracketCount = 0;
        StringBuffer fieldNameBuf = new StringBuffer();
        StringBuffer fieldValueLiteralBuf = new StringBuffer();
        int i = ndx;
        while (i < endIndex) {
            char c = source[i];
            char nextChar = '\u0000';
            if (i + 1 < endIndex) {
                nextChar = source[i + 1];
            }
            switch (state) {
                case 1: {
                    if ('/' == c && '/' == nextChar) {
                        prevState = state;
                        state = 8;
                        break;
                    }
                    if ('/' == c && '*' == nextChar) {
                        prevState = state;
                        state = 7;
                        break;
                    }
                    if (',' == c || ';' == c) {
                        rcList.add(FieldDocImpl.createFieldDoc(fd, fieldNameBuf.toString(), null));
                        fieldNameBuf.setLength(0);
                        break;
                    }
                    if ('=' == c) {
                        state = 2;
                        break;
                    }
                    if (' ' == c || '\n' == c || '\r' == c || '\t' == c) break;
                    fieldNameBuf.append(c);
                    break;
                }
                case 2: {
                    if ('/' == c && '/' == nextChar) {
                        prevState = state;
                        state = 8;
                        break;
                    }
                    if ('/' == c && '*' == nextChar) {
                        prevState = state;
                        state = 7;
                        break;
                    }
                    if ('\"' == c) {
                        prevState = state;
                        state = 3;
                        fieldValueLiteralBuf.append(c);
                        break;
                    }
                    if ('\'' == c) {
                        prevState = state;
                        state = 5;
                        fieldValueLiteralBuf.append(c);
                        break;
                    }
                    if ('{' == c || '(' == c) {
                        ++bracketCount;
                        fieldValueLiteralBuf.append(c);
                        break;
                    }
                    if ('}' == c || ')' == c) {
                        --bracketCount;
                        fieldValueLiteralBuf.append(c);
                        break;
                    }
                    if (bracketCount == 0 && (',' == c || ';' == c)) {
                        rcList.add(FieldDocImpl.createFieldDoc(fd, fieldNameBuf.toString(), fieldValueLiteralBuf.toString()));
                        fieldNameBuf.setLength(0);
                        fieldValueLiteralBuf.setLength(0);
                        state = 1;
                        break;
                    }
                    fieldValueLiteralBuf.append(c);
                    break;
                }
                case 3: {
                    fieldValueLiteralBuf.append(c);
                    if ('\\' == c) {
                        state = 4;
                        break;
                    }
                    if ('\"' != c) break;
                    state = prevState;
                    break;
                }
                case 5: {
                    fieldValueLiteralBuf.append(c);
                    if ('\\' == c) {
                        state = 6;
                        break;
                    }
                    if ('\'' != c) break;
                    state = prevState;
                    break;
                }
                case 4: {
                    fieldValueLiteralBuf.append(c);
                    state = 3;
                    break;
                }
                case 6: {
                    fieldValueLiteralBuf.append(c);
                    state = 5;
                    break;
                }
                case 8: {
                    if ('\n' != c) break;
                    state = prevState;
                    break;
                }
                case 7: {
                    if ('*' != c || '/' != nextChar) break;
                    ++i;
                    state = prevState;
                }
            }
            ++i;
        }
        if (fieldNameBuf.length() > 0) {
            rcList.add(FieldDocImpl.createFieldDoc(fd, fieldNameBuf.toString(), fieldValueLiteralBuf.toString()));
        }
        return rcList;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public SerialFieldTag[] serialFieldTags() {
        return new SerialFieldTag[0];
    }

    @Override
    public int modifierSpecifier() {
        return super.modifierSpecifier() | (this.isVolatile() ? 64 : 0) | (this.isTransient() ? 128 : 0);
    }

    @Override
    protected boolean processModifier(String word) {
        if (super.processModifier(word)) {
            return true;
        }
        if (word.equals("transient")) {
            this.isTransient = true;
            return true;
        }
        if (word.equals("volatile")) {
            this.isVolatile = true;
            return true;
        }
        return false;
    }

    @Override
    void resolve() {
        this.resolveTags();
    }

    public boolean hasSerialTag() {
        return true;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public Object constantValue() {
        return this.constantValue(new HashSet<FieldDoc>());
    }

    public Object constantValue(Set<FieldDoc> visitedFields) {
        if (!this.isStatic() || !this.isFinal() || !this.type().isPrimitive() && !"java.lang.String".equals(this.type().qualifiedTypeName()) || this.type.dimension().length() > 0 || this.valueLiteral == null) {
            return null;
        }
        if (!this.constantValueEvaluated) {
            visitedFields.add(this);
            String expression = "(" + this.type().typeName() + ")(" + this.valueLiteral + ")";
            try {
                this.constantValue = Evaluator.evaluate(expression, visitedFields, (ClassDocImpl)this.containingClass());
            }
            catch (CircularExpressionException e) {
                System.err.println("WARNING: Cannot resolve expression for field " + this.containingClass.qualifiedTypeName() + "." + this.name() + ": " + e.getMessage());
            }
            catch (IllegalExpressionException illegalExpressionException) {}
            this.constantValueEvaluated = true;
        }
        return this.constantValue;
    }

    private static void appendCharString(StringBuffer result, char c, boolean inSingleCuotes) {
        switch (c) {
            case '\b': {
                result.append("\\b");
                break;
            }
            case '\t': {
                result.append("\\t");
                break;
            }
            case '\n': {
                result.append("\\n");
                break;
            }
            case '\f': {
                result.append("\\f");
                break;
            }
            case '\r': {
                result.append("\\r");
                break;
            }
            case '\"': {
                result.append("\\\"");
                break;
            }
            case '\'': {
                result.append(inSingleCuotes ? "\\'" : "'");
                break;
            }
            default: {
                if (c >= ' ' && c <= '\u007f') {
                    result.append(c);
                    break;
                }
                result.append("\\u");
                String hexValue = Integer.toString(c, 16);
                int zeroCount = 4 - hexValue.length();
                int i = 0;
                while (i < zeroCount) {
                    result.append('0');
                    ++i;
                }
                result.append(hexValue);
            }
        }
    }

    @Override
    public String constantValueExpression() {
        Object value = this.constantValue();
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            StringBuffer result = new StringBuffer("\"");
            char[] chars = ((String)value).toCharArray();
            int i = 0;
            while (i < chars.length) {
                FieldDocImpl.appendCharString(result, chars[i], false);
                ++i;
            }
            result.append("\"");
            return result.toString();
        }
        if (value instanceof Float) {
            return String.valueOf(value.toString()) + "f";
        }
        if (value instanceof Long) {
            return String.valueOf(value.toString()) + "L";
        }
        if (value instanceof Character) {
            StringBuffer result = new StringBuffer("'");
            FieldDocImpl.appendCharString(result, ((Character)value).charValue(), false);
            result.append("'");
            return result.toString();
        }
        return value.toString();
    }

    void setValueLiteral(String valueLiteral) {
        this.valueLiteral = valueLiteral;
    }

    @Override
    public boolean isStatic() {
        return super.isStatic() || this.containingClass().isInterface();
    }

    @Override
    public boolean isFinal() {
        return super.isFinal() || this.containingClass().isInterface();
    }
}

