/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.common;

import gnu.classpath.tools.common.SecurityProviderInfo;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.logging.Logger;

public abstract class ProviderUtil {
    private static final Logger log = Logger.getLogger(ProviderUtil.class.getName());

    public static final SecurityProviderInfo addProvider(String providerClass) {
        log.entering(ProviderUtil.class.getName(), "addProvider", providerClass);
        Provider provider = null;
        try {
            provider = (Provider)Class.forName(providerClass.trim()).newInstance();
        }
        catch (InstantiationException instantiationException) {
            log.fine("InstantiationException while creating [" + providerClass + "]. Ignore");
        }
        catch (IllegalAccessException illegalAccessException) {
            log.fine("IllegalAccessException while creating [" + providerClass + "]. Ignore");
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.fine("ClassNotFoundException while creating [" + providerClass + "]. Ignore");
        }
        int position = provider != null ? ProviderUtil.addProvider(provider) : -1;
        SecurityProviderInfo result = new SecurityProviderInfo(provider, position);
        log.exiting(ProviderUtil.class.getName(), "addProvider", result);
        return result;
    }

    public static final int addProvider(final Provider provider) {
        log.entering(ProviderUtil.class.getName(), "addProvider", provider);
        Integer actualPosition = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                int result = Security.insertProviderAt(provider, 1);
                return result;
            }
        });
        int result = actualPosition;
        log.fine("Provider [" + provider.getName() + "] installed? " + (result != -1));
        log.exiting(ProviderUtil.class.getName(), "addProvider", actualPosition);
        return result;
    }

    public static final void removeProvider(final String providerName) {
        log.entering(ProviderUtil.class.getName(), "removeProvider", providerName);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Security.removeProvider(providerName);
                return null;
            }
        });
        log.exiting(ProviderUtil.class.getName(), "removeProvider");
    }
}

