/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.local;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseOptions;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.local.LocalTransport;
import org.elasticsearch.transport.support.TransportStatus;

public class LocalTransportChannel
implements TransportChannel {
    private static final String LOCAL_TRANSPORT_PROFILE = "default";
    private final LocalTransport sourceTransport;
    private final TransportServiceAdapter sourceTransportServiceAdapter;
    private final LocalTransport targetTransport;
    private final String action;
    private final long requestId;
    private final Version version;

    public LocalTransportChannel(LocalTransport sourceTransport, TransportServiceAdapter sourceTransportServiceAdapter, LocalTransport targetTransport, String action, long requestId, Version version) {
        this.sourceTransport = sourceTransport;
        this.sourceTransportServiceAdapter = sourceTransportServiceAdapter;
        this.targetTransport = targetTransport;
        this.action = action;
        this.requestId = requestId;
        this.version = version;
    }

    @Override
    public String action() {
        return this.action;
    }

    @Override
    public String getProfileName() {
        return LOCAL_TRANSPORT_PROFILE;
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        this.sendResponse(response, TransportResponseOptions.EMPTY);
    }

    @Override
    public void sendResponse(TransportResponse response, TransportResponseOptions options) throws IOException {
        try (BytesStreamOutput stream = new BytesStreamOutput();){
            stream.setVersion(this.version);
            stream.writeLong(this.requestId);
            byte status = 0;
            status = TransportStatus.setResponse(status);
            stream.writeByte(status);
            response.writeTo(stream);
            final byte[] data = stream.bytes().toBytes();
            this.targetTransport.workers().execute(new Runnable(){

                @Override
                public void run() {
                    LocalTransportChannel.this.targetTransport.messageReceived(data, LocalTransportChannel.this.action, LocalTransportChannel.this.sourceTransport, LocalTransportChannel.this.version, null);
                }
            });
            this.sourceTransportServiceAdapter.onResponseSent(this.requestId, this.action, response, options);
        }
    }

    @Override
    public void sendResponse(Throwable error) throws IOException {
        BytesStreamOutput stream = new BytesStreamOutput();
        this.writeResponseExceptionHeader(stream);
        RemoteTransportException tx = new RemoteTransportException(this.targetTransport.nodeName(), this.targetTransport.boundAddress().boundAddresses()[0], this.action, error);
        stream.writeThrowable(tx);
        final byte[] data = stream.bytes().toBytes();
        this.targetTransport.workers().execute(new Runnable(){

            @Override
            public void run() {
                LocalTransportChannel.this.targetTransport.messageReceived(data, LocalTransportChannel.this.action, LocalTransportChannel.this.sourceTransport, LocalTransportChannel.this.version, null);
            }
        });
        this.sourceTransportServiceAdapter.onResponseSent(this.requestId, this.action, error);
    }

    private void writeResponseExceptionHeader(BytesStreamOutput stream) throws IOException {
        stream.writeLong(this.requestId);
        byte status = 0;
        status = TransportStatus.setResponse(status);
        status = TransportStatus.setError(status);
        stream.writeByte(status);
    }
}

