/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.script;

import com.google.common.collect.Maps;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptParameterParser;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.fetch.script.ScriptFieldsContext;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptFieldsParseElement
implements SearchParseElement {
    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        XContentParser.Token token;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            String fieldName = currentFieldName;
            ScriptParameterParser scriptParameterParser = new ScriptParameterParser();
            Script script = null;
            Map<Object, Object> params = null;
            boolean ignoreException = false;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (context.parseFieldMatcher().match(currentFieldName, Script.ScriptField.SCRIPT)) {
                        script = Script.parse(parser, context.parseFieldMatcher());
                        continue;
                    }
                    if (!"params".equals(currentFieldName)) continue;
                    params = parser.map();
                    continue;
                }
                if (!token.isValue()) continue;
                if ("ignore_failure".equals(currentFieldName)) {
                    ignoreException = parser.booleanValue();
                    continue;
                }
                scriptParameterParser.token(currentFieldName, token, parser, context.parseFieldMatcher());
            }
            if (script == null) {
                ScriptParameterParser.ScriptParameterValue scriptValue = scriptParameterParser.getDefaultScriptParameterValue();
                if (scriptValue != null) {
                    if (params == null) {
                        params = Maps.newHashMap();
                    }
                    script = new Script(scriptValue.script(), scriptValue.scriptType(), scriptParameterParser.lang(), params);
                }
            } else if (params != null) {
                throw new SearchParseException(context, "script params must be specified inside script object", parser.getTokenLocation());
            }
            if (script == null) {
                throw new SearchParseException(context, "must specify a script in script fields", parser.getTokenLocation());
            }
            SearchScript searchScript = context.scriptService().search(context.lookup(), script, ScriptContext.Standard.SEARCH);
            context.scriptFields().add(new ScriptFieldsContext.ScriptField(fieldName, searchScript, ignoreException));
        }
    }
}

