/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.movavg.models;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.pipeline.movavg.MovAvgParser;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModelBuilder;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModelStreams;

public class HoltLinearModel
extends MovAvgModel {
    protected static final ParseField NAME_FIELD = new ParseField("holt", new String[0]);
    private final double alpha;
    private final double beta;
    public static final MovAvgModelStreams.Stream STREAM = new MovAvgModelStreams.Stream(){

        @Override
        public MovAvgModel readResult(StreamInput in) throws IOException {
            return new HoltLinearModel(in.readDouble(), in.readDouble());
        }

        @Override
        public String getName() {
            return NAME_FIELD.getPreferredName();
        }
    };

    public HoltLinearModel(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
    }

    @Override
    public boolean canBeMinimized() {
        return true;
    }

    @Override
    public MovAvgModel neighboringModel() {
        double newValue = Math.random();
        switch ((int)(Math.random() * 2.0)) {
            case 0: {
                return new HoltLinearModel(newValue, this.beta);
            }
            case 1: {
                return new HoltLinearModel(this.alpha, newValue);
            }
        }
        assert (false) : "Random value fell outside of range [0-1]";
        return new HoltLinearModel(newValue, this.beta);
    }

    @Override
    public MovAvgModel clone() {
        return new HoltLinearModel(this.alpha, this.beta);
    }

    @Override
    protected <T extends Number> double[] doPredict(Collection<T> values, int numPredictions) {
        return this.next(values, numPredictions);
    }

    @Override
    public <T extends Number> double next(Collection<T> values) {
        return this.next(values, 1)[0];
    }

    public <T extends Number> double[] next(Collection<T> values, int numForecasts) {
        if (values.size() == 0) {
            return this.emptyPredictions(numForecasts);
        }
        double s = 0.0;
        double last_s = 0.0;
        double b = 0.0;
        double last_b = 0.0;
        int counter = 0;
        Iterator<T> i$ = values.iterator();
        while (i$.hasNext()) {
            Number v;
            Number last = v = (Number)i$.next();
            if (counter == 1) {
                s = v.doubleValue();
                b = v.doubleValue() - last.doubleValue();
            } else {
                s = this.alpha * v.doubleValue() + (1.0 - this.alpha) * (last_s + last_b);
                b = this.beta * (s - last_s) + (1.0 - this.beta) * last_b;
            }
            ++counter;
            last_s = s;
            last_b = b;
        }
        double[] forecastValues = new double[numForecasts];
        for (int i = 0; i < numForecasts; ++i) {
            forecastValues[i] = s + (double)i * b;
        }
        return forecastValues;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(STREAM.getName());
        out.writeDouble(this.alpha);
        out.writeDouble(this.beta);
    }

    public static class HoltLinearModelBuilder
    implements MovAvgModelBuilder {
        private Double alpha;
        private Double beta;

        public HoltLinearModelBuilder alpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public HoltLinearModelBuilder beta(double beta) {
            this.beta = beta;
            return this;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(MovAvgParser.MODEL.getPreferredName(), NAME_FIELD.getPreferredName());
            builder.startObject(MovAvgParser.SETTINGS.getPreferredName());
            if (this.alpha != null) {
                builder.field("alpha", this.alpha);
            }
            if (this.beta != null) {
                builder.field("beta", this.beta);
            }
            builder.endObject();
            return builder;
        }
    }

    public static class DoubleExpModelParser
    extends MovAvgModel.AbstractModelParser {
        @Override
        public String getName() {
            return NAME_FIELD.getPreferredName();
        }

        @Override
        public MovAvgModel parse(@Nullable Map<String, Object> settings, String pipelineName, int windowSize, ParseFieldMatcher parseFieldMatcher) throws ParseException {
            double alpha = this.parseDoubleParam(settings, "alpha", 0.3);
            double beta = this.parseDoubleParam(settings, "beta", 0.1);
            this.checkUnrecognizedParams(settings);
            return new HoltLinearModel(alpha, beta);
        }
    }
}

